/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anwort auf eine nicht auswertbares Telegramm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsAxlNegativeQuittung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_0_SONSTIGE_FEHLERURSACHE = new AttTlsAxlNegativeQuittung("sonstige Fehlerursache", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID = new AttTlsAxlNegativeQuittung("unbekannte oder nicht auswertbare ID", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP = new AttTlsAxlNegativeQuittung("unbekannter oder nicht auswertbarer Typ", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_3_VERSION_NICHT_VERFUEGBAR = new AttTlsAxlNegativeQuittung("Version nicht verfügbar", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_12_PUFFERINHALT_NICHT_VERFUEGBAR = new AttTlsAxlNegativeQuittung("Pufferinhalt nicht verfügbar", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsAxlNegativeQuittung ZUSTAND_15_KANAL_PASSIVIERT = new AttTlsAxlNegativeQuittung("Kanal passiviert", 		Short
	.valueOf("15"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsAxlNegativeQuittung getZustand(final 		Short
	 value) {
		for (AttTlsAxlNegativeQuittung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsAxlNegativeQuittung getZustand(final String value) {
		for (AttTlsAxlNegativeQuittung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsAxlNegativeQuittung> getZustaende() {
		List<AttTlsAxlNegativeQuittung> list = new ArrayList<AttTlsAxlNegativeQuittung>();
		list.add(ZUSTAND_0_SONSTIGE_FEHLERURSACHE);
		list.add(ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID);
		list.add(ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP);
		list.add(ZUSTAND_3_VERSION_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_12_PUFFERINHALT_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_15_KANAL_PASSIVIERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSAxlNegativeQuittung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsAxlNegativeQuittung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsAxlNegativeQuittung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
