/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fahrzeugklassencodes gemäß TLS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsFahrzeugklassencode extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_1_PKW_GRUPPE = new AttTlsFahrzeugklassencode("Pkw-Gruppe", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_2_PKW_MIT_ANHAENGER = new AttTlsFahrzeugklassencode("Pkw mit Anhänger", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_3_LKW = new AttTlsFahrzeugklassencode("Lkw", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_4_LKW_MIT_ANHAENGER_UND_SATTELKRAFTFAHRZEUGE = new AttTlsFahrzeugklassencode("Lkw mit Anhänger und Sattelkraftfahrzeuge", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_5_BUSSE = new AttTlsFahrzeugklassencode("Busse", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_6_NICHT_KLASSIFIZIERBARE_KFZ = new AttTlsFahrzeugklassencode("nicht klassifizierbare Kfz", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_7_PKW = new AttTlsFahrzeugklassencode("Pkw", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_8_LKW_MIT_ANHAENGER = new AttTlsFahrzeugklassencode("Lkw mit Anhänger", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_9_SATTELKRAFTFAHRZEUGE = new AttTlsFahrzeugklassencode("Sattelkraftfahrzeuge", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_10_KRAD = new AttTlsFahrzeugklassencode("Krad", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_11_LIEFERWAGEN = new AttTlsFahrzeugklassencode("Lieferwagen", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_32_PKW_AEHNLICHE = new AttTlsFahrzeugklassencode("Pkw-Ähnliche", 		Byte
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_33_LKW_AEHNLICHE = new AttTlsFahrzeugklassencode("Lkw-Ähnliche", 		Byte
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencode ZUSTAND_64_PKW_AEHNLICHE_UND_LKW_AEHNLICHE_ALLE_FAHRZEUGE_ = new AttTlsFahrzeugklassencode("Pkw-Ähnliche und Lkw-Ähnliche (alle Fahrzeuge)", 		Byte
	.valueOf("64"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsFahrzeugklassencode getZustand(final 		Byte
	 value) {
		for (AttTlsFahrzeugklassencode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsFahrzeugklassencode getZustand(final String value) {
		for (AttTlsFahrzeugklassencode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsFahrzeugklassencode> getZustaende() {
		List<AttTlsFahrzeugklassencode> list = new ArrayList<AttTlsFahrzeugklassencode>();
		list.add(ZUSTAND_1_PKW_GRUPPE);
		list.add(ZUSTAND_2_PKW_MIT_ANHAENGER);
		list.add(ZUSTAND_3_LKW);
		list.add(ZUSTAND_4_LKW_MIT_ANHAENGER_UND_SATTELKRAFTFAHRZEUGE);
		list.add(ZUSTAND_5_BUSSE);
		list.add(ZUSTAND_6_NICHT_KLASSIFIZIERBARE_KFZ);
		list.add(ZUSTAND_7_PKW);
		list.add(ZUSTAND_8_LKW_MIT_ANHAENGER);
		list.add(ZUSTAND_9_SATTELKRAFTFAHRZEUGE);
		list.add(ZUSTAND_10_KRAD);
		list.add(ZUSTAND_11_LIEFERWAGEN);
		list.add(ZUSTAND_32_PKW_AEHNLICHE);
		list.add(ZUSTAND_33_LKW_AEHNLICHE);
		list.add(ZUSTAND_64_PKW_AEHNLICHE_UND_LKW_AEHNLICHE_ALLE_FAHRZEUGE_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSFahrzeugklassencode.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsFahrzeugklassencode(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsFahrzeugklassencode(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
