/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Klassifizierung nach Silhouette und
					Achskonfiguration.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsFahrzeugklassencodeAchslast extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_0_UNBEKANNTER_FAHRZEUGTYP_ = new AttTlsFahrzeugklassencodeAchslast("unbekannter Fahrzeugtyp ", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_1_PKW_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Pkw (E, E)", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_2_PKW_MIT_ANHAENGER_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Pkw mit Anhänger (E, E + E)", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_3_PKW_MIT_ANHAENGER_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Pkw mit Anhänger (E, E + Dp)", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_4_KLEINTRANSPORTER_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Kleintransporter (E, E)", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_5_KLEINTRANSPORTER_MIT_ANHAENGER_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Kleintransporter mit Anhänger (E, E + E)", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_6_KLEINTRANSPORTER_MIT_ANHAENGER_E_E_DP = new AttTlsFahrzeugklassencodeAchslast("Kleintransporter mit Anhänger (E, E + Dp", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_8_LKW_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw (E, E)", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_9_LKW_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw (E, Dp)", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_10_LKW_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw (E, Dr)", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_11_LKW_DP_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw (Dp, E)", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_12_LKW_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw (Dp, Dp)", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_32_LKW_MIT_ANHAENGER_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + E)", 		Short
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_33_LKW_MIT_ANHAENGER_E_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + E, E)", 		Short
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_34_LKW_MIT_ANHAENGER_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + Dp)", 		Short
	.valueOf("34"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_35_LKW_MIT_ANHAENGER_E_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + E, Dp)", 		Short
	.valueOf("35"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_36_LKW_MIT_ANHAENGER_E_E_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + Dp, Dp)", 		Short
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_37_LKW_MIT_ANHAENGER_E_E_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, E + E, Dr) ", 		Short
	.valueOf("37"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_40_LKW_MIT_ANHAENGER_E_DP_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + E)", 		Short
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_41_LKW_MIT_ANHAENGER_E_DP_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + E , E)", 		Short
	.valueOf("41"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_42_LKW_MIT_ANHAENGER_E_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + Dp)", 		Short
	.valueOf("42"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_43_LKW_MIT_ANHAENGER_E_DP_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + E, Dp)", 		Short
	.valueOf("43"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_44_LKW_MIT_ANHAENGER_E_DP_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + Dp, Dp)", 		Short
	.valueOf("44"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_45_LKW_MIT_ANHAENGER_E_DP_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dp + E, Dr)", 		Short
	.valueOf("45"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_48_LKW_MIT_ANHAENGER_E_DR_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + E)", 		Short
	.valueOf("48"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_49_LKW_MIT_ANHAENGER_E_DR_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + E , E)", 		Short
	.valueOf("49"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_50_LKW_MIT_ANHAENGER_E_DR_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + Dp)", 		Short
	.valueOf("50"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_51_LKW_MIT_ANHAENGER_E_DR_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + E, Dp)", 		Short
	.valueOf("51"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_52_LKW_MIT_ANHAENGER_E_DR_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + Dp, Dp)", 		Short
	.valueOf("52"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_53_LKW_MIT_ANHAENGER_E_DR_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(E, Dr + E, Dr)", 		Short
	.valueOf("53"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_56_LKW_MIT_ANHAENGER_DP_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + E)", 		Short
	.valueOf("56"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_57_LKW_MIT_ANHAENGER_DP_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + E , E)", 		Short
	.valueOf("57"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_58_LKW_MIT_ANHAENGER_DP_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + Dp)", 		Short
	.valueOf("58"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_59_LKW_MIT_ANHAENGER_DP_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + E, Dp)", 		Short
	.valueOf("59"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_60_LKW_MIT_ANHAENGER_DP_E_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + Dp, Dp)", 		Short
	.valueOf("60"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_61_LKW_MIT_ANHAENGER_DP_E_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, E + E, Dr)", 		Short
	.valueOf("61"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_64_LKW_MIT_ANHAENGER_DP_DP_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + E)", 		Short
	.valueOf("64"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_65_LKW_MIT_ANHAENGER_DP_DP_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + E , E)", 		Short
	.valueOf("65"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_66_LKW_MIT_ANHAENGER_DP_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + Dp)", 		Short
	.valueOf("66"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_67_LKW_MIT_ANHAENGER_DP_DP_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + E, Dp)", 		Short
	.valueOf("67"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_68_LKW_MIT_ANHAENGER_DP_DP_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + Dp, Dp)", 		Short
	.valueOf("68"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_69_LKW_MIT_ANHAENGER_DP_DP_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + E, Dr)", 		Short
	.valueOf("69"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_70_LKW_MIT_ANHAENGER_DP_DP_DR_ = new AttTlsFahrzeugklassencodeAchslast("Lkw mit Anhänger(Dp, Dp + Dr)", 		Short
	.valueOf("70"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_96_SATTELKRAFTFAHRZEUG_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, E + E) ", 		Short
	.valueOf("96"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_97_SATTELKRAFTFAHRZEUG_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, E + Dp)", 		Short
	.valueOf("97"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_98_SATTELKRAFTFAHRZEUG_E_E_DR_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, E + Dr)", 		Short
	.valueOf("98"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_99_SATTELKRAFTFAHRZEUG_E_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, E + E, E)", 		Short
	.valueOf("99"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_104_SATTELKRAFTFAHRZEUG_E_DP_E_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, Dp + E)", 		Short
	.valueOf("104"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_105_SATTELKRAFTFAHRZEUG_E_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, Dp + Dp)", 		Short
	.valueOf("105"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_106_SATTELKRAFTFAHRZEUG_E_DP_DR_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, Dp + Dr)", 		Short
	.valueOf("106"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_107_SATTELKRAFTFAHRZEUG_E_DP_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Sattelkraftfahrzeug (E, Dp + E, E)", 		Short
	.valueOf("107"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_120_BUS_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, E)", 		Short
	.valueOf("120"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_121_BUS_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, Dp)", 		Short
	.valueOf("121"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_122_BUS_E_E_E_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, E + E)", 		Short
	.valueOf("122"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_123_BUS_E_E_DP_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, E + Dp)", 		Short
	.valueOf("123"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_124_BUS_E_DP_E_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, Dp +E)", 		Short
	.valueOf("124"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsFahrzeugklassencodeAchslast ZUSTAND_125_BUS_E_DP_DP_ = new AttTlsFahrzeugklassencodeAchslast("Bus (E, Dp + Dp)", 		Short
	.valueOf("125"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsFahrzeugklassencodeAchslast getZustand(final 		Short
	 value) {
		for (AttTlsFahrzeugklassencodeAchslast e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsFahrzeugklassencodeAchslast getZustand(final String value) {
		for (AttTlsFahrzeugklassencodeAchslast e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsFahrzeugklassencodeAchslast> getZustaende() {
		List<AttTlsFahrzeugklassencodeAchslast> list = new ArrayList<AttTlsFahrzeugklassencodeAchslast>();
		list.add(ZUSTAND_0_UNBEKANNTER_FAHRZEUGTYP_);
		list.add(ZUSTAND_1_PKW_E_E_);
		list.add(ZUSTAND_2_PKW_MIT_ANHAENGER_E_E_E_);
		list.add(ZUSTAND_3_PKW_MIT_ANHAENGER_E_E_DP_);
		list.add(ZUSTAND_4_KLEINTRANSPORTER_E_E_);
		list.add(ZUSTAND_5_KLEINTRANSPORTER_MIT_ANHAENGER_E_E_E_);
		list.add(ZUSTAND_6_KLEINTRANSPORTER_MIT_ANHAENGER_E_E_DP);
		list.add(ZUSTAND_8_LKW_E_E_);
		list.add(ZUSTAND_9_LKW_E_DP_);
		list.add(ZUSTAND_10_LKW_E_DR_);
		list.add(ZUSTAND_11_LKW_DP_E_);
		list.add(ZUSTAND_12_LKW_DP_DP_);
		list.add(ZUSTAND_32_LKW_MIT_ANHAENGER_E_E_E_);
		list.add(ZUSTAND_33_LKW_MIT_ANHAENGER_E_E_E_E_);
		list.add(ZUSTAND_34_LKW_MIT_ANHAENGER_E_E_DP_);
		list.add(ZUSTAND_35_LKW_MIT_ANHAENGER_E_E_E_DP_);
		list.add(ZUSTAND_36_LKW_MIT_ANHAENGER_E_E_DP_DP_);
		list.add(ZUSTAND_37_LKW_MIT_ANHAENGER_E_E_E_DR_);
		list.add(ZUSTAND_40_LKW_MIT_ANHAENGER_E_DP_E_);
		list.add(ZUSTAND_41_LKW_MIT_ANHAENGER_E_DP_E_E_);
		list.add(ZUSTAND_42_LKW_MIT_ANHAENGER_E_DP_DP_);
		list.add(ZUSTAND_43_LKW_MIT_ANHAENGER_E_DP_E_DP_);
		list.add(ZUSTAND_44_LKW_MIT_ANHAENGER_E_DP_DP_DP_);
		list.add(ZUSTAND_45_LKW_MIT_ANHAENGER_E_DP_E_DR_);
		list.add(ZUSTAND_48_LKW_MIT_ANHAENGER_E_DR_E_);
		list.add(ZUSTAND_49_LKW_MIT_ANHAENGER_E_DR_E_E_);
		list.add(ZUSTAND_50_LKW_MIT_ANHAENGER_E_DR_DP_);
		list.add(ZUSTAND_51_LKW_MIT_ANHAENGER_E_DR_E_DP_);
		list.add(ZUSTAND_52_LKW_MIT_ANHAENGER_E_DR_DP_DP_);
		list.add(ZUSTAND_53_LKW_MIT_ANHAENGER_E_DR_E_DR_);
		list.add(ZUSTAND_56_LKW_MIT_ANHAENGER_DP_E_E_);
		list.add(ZUSTAND_57_LKW_MIT_ANHAENGER_DP_E_E_E_);
		list.add(ZUSTAND_58_LKW_MIT_ANHAENGER_DP_E_DP_);
		list.add(ZUSTAND_59_LKW_MIT_ANHAENGER_DP_E_E_DP_);
		list.add(ZUSTAND_60_LKW_MIT_ANHAENGER_DP_E_DP_DP_);
		list.add(ZUSTAND_61_LKW_MIT_ANHAENGER_DP_E_E_DR_);
		list.add(ZUSTAND_64_LKW_MIT_ANHAENGER_DP_DP_E_);
		list.add(ZUSTAND_65_LKW_MIT_ANHAENGER_DP_DP_E_E_);
		list.add(ZUSTAND_66_LKW_MIT_ANHAENGER_DP_DP_DP_);
		list.add(ZUSTAND_67_LKW_MIT_ANHAENGER_DP_DP_E_DP_);
		list.add(ZUSTAND_68_LKW_MIT_ANHAENGER_DP_DP_DP_DP_);
		list.add(ZUSTAND_69_LKW_MIT_ANHAENGER_DP_DP_E_DR_);
		list.add(ZUSTAND_70_LKW_MIT_ANHAENGER_DP_DP_DR_);
		list.add(ZUSTAND_96_SATTELKRAFTFAHRZEUG_E_E_E_);
		list.add(ZUSTAND_97_SATTELKRAFTFAHRZEUG_E_E_DP_);
		list.add(ZUSTAND_98_SATTELKRAFTFAHRZEUG_E_E_DR_);
		list.add(ZUSTAND_99_SATTELKRAFTFAHRZEUG_E_E_E_E_);
		list.add(ZUSTAND_104_SATTELKRAFTFAHRZEUG_E_DP_E_);
		list.add(ZUSTAND_105_SATTELKRAFTFAHRZEUG_E_DP_DP_);
		list.add(ZUSTAND_106_SATTELKRAFTFAHRZEUG_E_DP_DR_);
		list.add(ZUSTAND_107_SATTELKRAFTFAHRZEUG_E_DP_E_E_);
		list.add(ZUSTAND_120_BUS_E_E_);
		list.add(ZUSTAND_121_BUS_E_DP_);
		list.add(ZUSTAND_122_BUS_E_E_E_);
		list.add(ZUSTAND_123_BUS_E_E_DP_);
		list.add(ZUSTAND_124_BUS_E_DP_E_);
		list.add(ZUSTAND_125_BUS_E_DP_DP_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSFahrzeugklassencodeAchslast.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsFahrzeugklassencodeAchslast(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsFahrzeugklassencodeAchslast(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
