/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Enthält die Ermittlung der Fehlerursache in der TLS
					Kommunikation, die aufgrund von Messwertausfällen
					ermittelt wurden.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsFehlerAnalyse extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Fehlerursache konnte nicht ermittelt werden.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_0_UNBEKANNTE_URSACHE = new AttTlsFehlerAnalyse("unbekannte Ursache", 		Byte
	.valueOf("0"));

	/**
	Verbindung zum KRI xxx oder KRI selbst
								defekt. Verbindung zum KRI oder KRI instand
								setzen.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_1_KRI_ODER_VERBINDUNG_ZUM_KRI_DEFEKT = new AttTlsFehlerAnalyse("KRI oder Verbindung zum KRI defekt", 		Byte
	.valueOf("1"));

	/**
	Modem am Inselbus xxx oder Inselbus selbst
								defekt. Modem oder Inselbus instand setzen.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_2_MODEM_INSELBUS_ODER_INSELBUS_DEFEKT = new AttTlsFehlerAnalyse("Modem-Inselbus oder Inselbus defekt", 		Byte
	.valueOf("2"));

	/**
	Inselbus xxx gestört: Für die DE der
								Steuermodule x1, x2,.. sind keine Daten
								verfügbar. Inselbus xxx instand setzen.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_3_INSELBUS_DEFEKT = new AttTlsFehlerAnalyse("Inselbus defekt", 		Byte
	.valueOf("3"));

	/**
	Modem am Steuermodul x oder Steuermodul
								defekt. Modem am Steuermodul x oder
								Steuermodul instand setzen.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_4_MODEM_STEUERMODUL_ODER_STEUERMODUL_DEFEKT = new AttTlsFehlerAnalyse("Modem-Steuermodul oder Steuermodul defekt", 		Byte
	.valueOf("4"));

	/**
	EAK x am Steuermodul y defekt. EAK x am
								Steuermodul y instand setzen.
	<p>
	
	</p>
	*/
	public static final AttTlsFehlerAnalyse ZUSTAND_5_EAK_AM_STEUERMODUL_DEFEKT = new AttTlsFehlerAnalyse("EAK am Steuermodul defekt", 		Byte
	.valueOf("5"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsFehlerAnalyse getZustand(final 		Byte
	 value) {
		for (AttTlsFehlerAnalyse e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsFehlerAnalyse getZustand(final String value) {
		for (AttTlsFehlerAnalyse e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsFehlerAnalyse> getZustaende() {
		List<AttTlsFehlerAnalyse> list = new ArrayList<AttTlsFehlerAnalyse>();
		list.add(ZUSTAND_0_UNBEKANNTE_URSACHE);
		list.add(ZUSTAND_1_KRI_ODER_VERBINDUNG_ZUM_KRI_DEFEKT);
		list.add(ZUSTAND_2_MODEM_INSELBUS_ODER_INSELBUS_DEFEKT);
		list.add(ZUSTAND_3_INSELBUS_DEFEKT);
		list.add(ZUSTAND_4_MODEM_STEUERMODUL_ODER_STEUERMODUL_DEFEKT);
		list.add(ZUSTAND_5_EAK_AM_STEUERMODUL_DEFEKT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TlsFehlerAnalyse.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsFehlerAnalyse(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsFehlerAnalyse(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
