/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Hersteller gemäss TLS.
<p>
In der Regel wird bei Fehlermeldungen der Hersteller
					angegeben, der den Fehler erkannt hat, nicht
					derjenige, der für den Fehler verantwortlich ist
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 33L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsHersteller extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("33");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_0_HERSTELLER_UNBEKANNT = new AttTlsHersteller("Hersteller unbekannt", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_1_AEG = new AttTlsHersteller("AEG", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_2_ANDI = new AttTlsHersteller("ANDI", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_3_SIGNALBAU_HUBER_ANT_BOSCH_TELECOM_ = new AttTlsHersteller("Signalbau Huber (ANT, Bosch Telecom)", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_4_AVE_GMBH = new AttTlsHersteller("ave GmbH", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_5_DAMBACH = new AttTlsHersteller("Dambach", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_6_HEUSCH_BOESEFELDT_GMBH = new AttTlsHersteller("Heusch/Boesefeldt GmbH", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_7_DEUTSCHE_SYSTEM_TECHNIK_DST_ = new AttTlsHersteller("Deutsche System Technik (DST)", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_8_PINTSCH_BAMAG = new AttTlsHersteller("Pintsch-Bamag", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_9_PRODATA_GMBH = new AttTlsHersteller("Prodata GmbH", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_10_SIEMENS_AG = new AttTlsHersteller("Siemens AG", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_11_SOCAL_LIGHT_TVB = new AttTlsHersteller("Socal-Light/TVB", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_12_DAIMLER_BENZ_AEROSPACE_AG = new AttTlsHersteller("Daimler-Benz Aerospace AG", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_13_WEISS_ELECTRONIC_GMBH = new AttTlsHersteller("Weiss-Electronic GmbH", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_14_SEGOR_GMBH = new AttTlsHersteller("Segor GmbH", 		Short
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_15_FEIG_ELECTRONIC_GMBH = new AttTlsHersteller("Feig Electronic GmbH", 		Short
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_16_ERWIN_SICK_GMBH = new AttTlsHersteller("Erwin Sick GmbH", 		Short
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_17_MICKS_MSR_GMBH = new AttTlsHersteller("MicKS MSR GmbH", 		Short
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_18_WEISS_SYSTEME = new AttTlsHersteller("Weiß-Systeme", 		Short
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_19_BLAU_INDUSTRIE_ELEKTRONIK = new AttTlsHersteller("Blau Industrie-Elektronik", 		Short
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_20_QSG_MBH = new AttTlsHersteller("QSG mbH", 		Short
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_21_BOSCHUNG = new AttTlsHersteller("Boschung", 		Short
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_22_CLAUS_SCHRICK = new AttTlsHersteller("Claus Schrick", 		Short
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_23_STUEHRENBERG_GMBH = new AttTlsHersteller("Stührenberg GmbH", 		Short
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_24_ZIMMERMANN_GMBH = new AttTlsHersteller("Zimmermann GmbH", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_25_SAUBER_GISIN = new AttTlsHersteller("Sauber + Gisin", 		Short
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_26_PAT_GMBH = new AttTlsHersteller("PAT GmbH", 		Short
	.valueOf("26"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_27_REC_DIGITALE_PROCESSTECHNIK = new AttTlsHersteller("rec digitale Processtechnik", 		Short
	.valueOf("27"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_28_STERIA_INFORMATIC_AG = new AttTlsHersteller("Steria Informatic AG", 		Short
	.valueOf("28"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_29_ROBOT_FOTO_UND_ELECTRONIC_GMBH = new AttTlsHersteller("Robot Foto und Electronic GmbH", 		Short
	.valueOf("29"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_30_TRAFFIC_DATA_SYSTEMS_GMBH = new AttTlsHersteller("Traffic Data Systems GmbH", 		Short
	.valueOf("30"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_31_KISTLER_INSTRUMENTE_AG_WINTERTHUR_CH_ = new AttTlsHersteller("Kistler Instrumente AG Winterthur (CH)", 		Short
	.valueOf("31"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsHersteller ZUSTAND_32_KAPPICH_KNISS_SYSTEMBERATUNG_K2S_ = new AttTlsHersteller("Kappich+Kniß Systemberatung (K2S)", 		Short
	.valueOf("32"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsHersteller getZustand(final 		Short
	 value) {
		for (AttTlsHersteller e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsHersteller getZustand(final String value) {
		for (AttTlsHersteller e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsHersteller> getZustaende() {
		List<AttTlsHersteller> list = new ArrayList<AttTlsHersteller>();
		list.add(ZUSTAND_0_HERSTELLER_UNBEKANNT);
		list.add(ZUSTAND_1_AEG);
		list.add(ZUSTAND_2_ANDI);
		list.add(ZUSTAND_3_SIGNALBAU_HUBER_ANT_BOSCH_TELECOM_);
		list.add(ZUSTAND_4_AVE_GMBH);
		list.add(ZUSTAND_5_DAMBACH);
		list.add(ZUSTAND_6_HEUSCH_BOESEFELDT_GMBH);
		list.add(ZUSTAND_7_DEUTSCHE_SYSTEM_TECHNIK_DST_);
		list.add(ZUSTAND_8_PINTSCH_BAMAG);
		list.add(ZUSTAND_9_PRODATA_GMBH);
		list.add(ZUSTAND_10_SIEMENS_AG);
		list.add(ZUSTAND_11_SOCAL_LIGHT_TVB);
		list.add(ZUSTAND_12_DAIMLER_BENZ_AEROSPACE_AG);
		list.add(ZUSTAND_13_WEISS_ELECTRONIC_GMBH);
		list.add(ZUSTAND_14_SEGOR_GMBH);
		list.add(ZUSTAND_15_FEIG_ELECTRONIC_GMBH);
		list.add(ZUSTAND_16_ERWIN_SICK_GMBH);
		list.add(ZUSTAND_17_MICKS_MSR_GMBH);
		list.add(ZUSTAND_18_WEISS_SYSTEME);
		list.add(ZUSTAND_19_BLAU_INDUSTRIE_ELEKTRONIK);
		list.add(ZUSTAND_20_QSG_MBH);
		list.add(ZUSTAND_21_BOSCHUNG);
		list.add(ZUSTAND_22_CLAUS_SCHRICK);
		list.add(ZUSTAND_23_STUEHRENBERG_GMBH);
		list.add(ZUSTAND_24_ZIMMERMANN_GMBH);
		list.add(ZUSTAND_25_SAUBER_GISIN);
		list.add(ZUSTAND_26_PAT_GMBH);
		list.add(ZUSTAND_27_REC_DIGITALE_PROCESSTECHNIK);
		list.add(ZUSTAND_28_STERIA_INFORMATIC_AG);
		list.add(ZUSTAND_29_ROBOT_FOTO_UND_ELECTRONIC_GMBH);
		list.add(ZUSTAND_30_TRAFFIC_DATA_SYSTEMS_GMBH);
		list.add(ZUSTAND_31_KISTLER_INSTRUMENTE_AG_WINTERTHUR_CH_);
		list.add(ZUSTAND_32_KAPPICH_KNISS_SYSTEMBERATUNG_K2S_);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSHersteller.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsHersteller(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsHersteller(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
