/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ID zum Abruf von TLS-Telegrammen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsIDAbruf extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsIDAbruf ZUSTAND_17_FEHLERMELDUNGEN = new AttTlsIDAbruf("Fehlermeldungen", 		Byte
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsIDAbruf ZUSTAND_18_STATUSNACHRICHTEN = new AttTlsIDAbruf("Statusnachrichten", 		Byte
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsIDAbruf ZUSTAND_19_PARAMETER = new AttTlsIDAbruf("Parameter", 		Byte
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsIDAbruf ZUSTAND_20_ERGEBNISMELDUNGEN = new AttTlsIDAbruf("Ergebnismeldungen", 		Byte
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsIDAbruf ZUSTAND_21_BEFEHLSZUSTAENDE = new AttTlsIDAbruf("Befehlszustände", 		Byte
	.valueOf("21"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsIDAbruf getZustand(final 		Byte
	 value) {
		for (AttTlsIDAbruf e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsIDAbruf getZustand(final String value) {
		for (AttTlsIDAbruf e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsIDAbruf> getZustaende() {
		List<AttTlsIDAbruf> list = new ArrayList<AttTlsIDAbruf>();
		list.add(ZUSTAND_17_FEHLERMELDUNGEN);
		list.add(ZUSTAND_18_STATUSNACHRICHTEN);
		list.add(ZUSTAND_19_PARAMETER);
		list.add(ZUSTAND_20_ERGEBNISMELDUNGEN);
		list.add(ZUSTAND_21_BEFEHLSZUSTAENDE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSIDAbruf.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsIDAbruf(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsIDAbruf(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
