/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Länge des folgenden Bezeichners (z.B. Dateiname).
<p>
Wird die Länge des Bezeichners auf 0 gesetzt,
					wird ein laufender Dateitransfer (in Antwortrichtung) abgebrochen.
					DE-Blöcke, welche sich bereits in der OSI2-Schicht
					(Lokalbus-&#47;Inselbustreiber) bzw. im SM befinden, werden nicht gelöscht
					und gelten als versendet. Sollte der Dateitransfer nicht vollständig
					abgeschlossen sein, wird eine negativen Quittung (Code=24) mit der
					Jobnummer des ursprünglichen Abrufes bzw. laufenden Datentransfers gesendet.
					Als Antwort auf den Abruf ("Abbruch der Übertragung") wird eine positive
					Quittung mit DE-Block Typ 28 gesendet. Dies gilt auch, wenn der
					Dateitransfer bereits vollständig abgearbeitet wurde.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
@Wertebereich(
	minimum = -1L,
	maximum = 221L,
	einheit = ""
)
public class AttTlsLaengeBezeichner extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("-1");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("221");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Die Länge wird von KEx aus dem Bezeichner ermittelt.
	<p>
	
	</p>
	*/
	public static final AttTlsLaengeBezeichner ZUSTAND_1N_AUTOMATISCH_ERMITTELN = new AttTlsLaengeBezeichner("automatisch ermitteln", 		Short
	.valueOf("-1"));

	/**
	Der aktuelle Dateitransfer wird abgebrochen.
	<p>
	
	</p>
	*/
	public static final AttTlsLaengeBezeichner ZUSTAND_0_ABBRUCH_DATEITRANSFER = new AttTlsLaengeBezeichner("Abbruch Dateitransfer", 		Short
	.valueOf("0"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLaengeBezeichner getZustand(final 		Short
	 value) {
		for (AttTlsLaengeBezeichner e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLaengeBezeichner getZustand(final String value) {
		for (AttTlsLaengeBezeichner e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLaengeBezeichner> getZustaende() {
		List<AttTlsLaengeBezeichner> list = new ArrayList<AttTlsLaengeBezeichner>();
		list.add(ZUSTAND_1N_AUTOMATISCH_ERMITTELN);
		list.add(ZUSTAND_0_ABBRUCH_DATEITRANSFER);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLängeBezeichner.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLaengeBezeichner(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsLaengeBezeichner(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
