/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Straßenart (BAB, Landstraße, ...).
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsLandeskennung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_0_UNBEKANNT = new AttTlsLandeskennung("unbekannt", 		Byte
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_1_SCHLESWIG_HOLSTEIN = new AttTlsLandeskennung("Schleswig-Holstein", 		Byte
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_2_HAMBURG = new AttTlsLandeskennung("Hamburg", 		Byte
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_3_NIEDERSACHSEN = new AttTlsLandeskennung("Niedersachsen", 		Byte
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_4_BREMEN = new AttTlsLandeskennung("Bremen", 		Byte
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_5_NORDRHEIN_WESTFALEN = new AttTlsLandeskennung("Nordrhein-Westfalen", 		Byte
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_6_HESSEN = new AttTlsLandeskennung("Hessen", 		Byte
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_7_RHEINLAND_PFALZ = new AttTlsLandeskennung("Rheinland-Pfalz", 		Byte
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_8_BADEN_WUERTTEMBERG = new AttTlsLandeskennung("Baden-Württemberg", 		Byte
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_9_BAYERN = new AttTlsLandeskennung("Bayern", 		Byte
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_10_SAARLAND = new AttTlsLandeskennung("Saarland", 		Byte
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_11_BERLIN = new AttTlsLandeskennung("Berlin", 		Byte
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_12_BRANDENBURG = new AttTlsLandeskennung("Brandenburg", 		Byte
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_13_MECKLENBURG_VORPOMMERN = new AttTlsLandeskennung("Mecklenburg-Vorpommern", 		Byte
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_14_SACHSEN = new AttTlsLandeskennung("Sachsen", 		Byte
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_15_SACHSEN_ANHALT = new AttTlsLandeskennung("Sachsen-Anhalt", 		Byte
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLandeskennung ZUSTAND_16_THUERINGEN = new AttTlsLandeskennung("Thüringen", 		Byte
	.valueOf("16"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLandeskennung getZustand(final 		Byte
	 value) {
		for (AttTlsLandeskennung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLandeskennung getZustand(final String value) {
		for (AttTlsLandeskennung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLandeskennung> getZustaende() {
		List<AttTlsLandeskennung> list = new ArrayList<AttTlsLandeskennung>();
		list.add(ZUSTAND_0_UNBEKANNT);
		list.add(ZUSTAND_1_SCHLESWIG_HOLSTEIN);
		list.add(ZUSTAND_2_HAMBURG);
		list.add(ZUSTAND_3_NIEDERSACHSEN);
		list.add(ZUSTAND_4_BREMEN);
		list.add(ZUSTAND_5_NORDRHEIN_WESTFALEN);
		list.add(ZUSTAND_6_HESSEN);
		list.add(ZUSTAND_7_RHEINLAND_PFALZ);
		list.add(ZUSTAND_8_BADEN_WUERTTEMBERG);
		list.add(ZUSTAND_9_BAYERN);
		list.add(ZUSTAND_10_SAARLAND);
		list.add(ZUSTAND_11_BERLIN);
		list.add(ZUSTAND_12_BRANDENBURG);
		list.add(ZUSTAND_13_MECKLENBURG_VORPOMMERN);
		list.add(ZUSTAND_14_SACHSEN);
		list.add(ZUSTAND_15_SACHSEN_ANHALT);
		list.add(ZUSTAND_16_THUERINGEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLandeskennung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLandeskennung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsLandeskennung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
