/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Erfassungsintervalldauer der Langzeitdaten.
<p>
Es sind nur Stundenwerte zugelassen, die ganzzahlige
					Teiler oder ganzzahlige Mehrfache von 24 Stunden
					sind (1, 2, 3, 4, 6, 8, 12, 24 Stunden).
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsLveErfassungsIntervalldauerLangzeitdaten extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_129__1_STUNDE = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("1 Stunde", 		Short
	.valueOf("129"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_130__2_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("2 Stunden", 		Short
	.valueOf("130"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_131__3_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("3 Stunden", 		Short
	.valueOf("131"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_132__4_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("4 Stunden", 		Short
	.valueOf("132"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_134__6_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("6 Stunden", 		Short
	.valueOf("134"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_136__8_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("8 Stunden", 		Short
	.valueOf("136"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_140__12_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("12 Stunden", 		Short
	.valueOf("140"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveErfassungsIntervalldauerLangzeitdaten ZUSTAND_152__24_STUNDEN = new AttTlsLveErfassungsIntervalldauerLangzeitdaten("24 Stunden", 		Short
	.valueOf("152"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveErfassungsIntervalldauerLangzeitdaten getZustand(final 		Short
	 value) {
		for (AttTlsLveErfassungsIntervalldauerLangzeitdaten e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveErfassungsIntervalldauerLangzeitdaten getZustand(final String value) {
		for (AttTlsLveErfassungsIntervalldauerLangzeitdaten e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveErfassungsIntervalldauerLangzeitdaten> getZustaende() {
		List<AttTlsLveErfassungsIntervalldauerLangzeitdaten> list = new ArrayList<AttTlsLveErfassungsIntervalldauerLangzeitdaten>();
		list.add(ZUSTAND_129__1_STUNDE);
		list.add(ZUSTAND_130__2_STUNDEN);
		list.add(ZUSTAND_131__3_STUNDEN);
		list.add(ZUSTAND_132__4_STUNDEN);
		list.add(ZUSTAND_134__6_STUNDEN);
		list.add(ZUSTAND_136__8_STUNDEN);
		list.add(ZUSTAND_140__12_STUNDEN);
		list.add(ZUSTAND_152__24_STUNDEN);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLveErfassungsIntervalldauerLangzeitdaten.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveErfassungsIntervalldauerLangzeitdaten(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsLveErfassungsIntervalldauerLangzeitdaten(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
