/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenversion der Kurzzeitdaten.
<p>
Mit Hilfe dieser Bytes wird die Datenversion
					ausgewählt, mit der die zyklisch erfassten
					Verkehrsdaten übertragen werden sollen. Bei Geräten,
					die die Version 4 nicht unterstützen, wird eine 4 in
					diesem Byte mit einer negativen Quittung
					(Fehlerursache 3) beantwortet. Wenn auf die
					Versionen 4 umgeschaltet wird, ohne dass zuvor mit
					dem DEBlock Typ 37 eine entsprechende Parametrierung
					der Grenzen der Geschwindigkeitsklassen vorgenommen
					wurde, dann werden die dort beschriebenen
					Defaultwerte für die Grenzen der
					Geschwindigkeitsklassen verwendet.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttTlsLveVersionKurzzeitdaten extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_0_VERSION_0 = new AttTlsLveVersionKurzzeitdaten("Version 0", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_1_VERSION_1 = new AttTlsLveVersionKurzzeitdaten("Version 1", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_2_VERSION_2 = new AttTlsLveVersionKurzzeitdaten("Version 2", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_3_VERSION_3 = new AttTlsLveVersionKurzzeitdaten("Version 3", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_4_VERSION_4 = new AttTlsLveVersionKurzzeitdaten("Version 4", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionKurzzeitdaten ZUSTAND_255_KURZZEITDATEN_AUS = new AttTlsLveVersionKurzzeitdaten("Kurzzeitdaten aus", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveVersionKurzzeitdaten getZustand(final 		Short
	 value) {
		for (AttTlsLveVersionKurzzeitdaten e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveVersionKurzzeitdaten getZustand(final String value) {
		for (AttTlsLveVersionKurzzeitdaten e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveVersionKurzzeitdaten> getZustaende() {
		List<AttTlsLveVersionKurzzeitdaten> list = new ArrayList<AttTlsLveVersionKurzzeitdaten>();
		list.add(ZUSTAND_0_VERSION_0);
		list.add(ZUSTAND_1_VERSION_1);
		list.add(ZUSTAND_2_VERSION_2);
		list.add(ZUSTAND_3_VERSION_3);
		list.add(ZUSTAND_4_VERSION_4);
		list.add(ZUSTAND_255_KURZZEITDATEN_AUS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLveVersionKurzzeitdaten.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveVersionKurzzeitdaten(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsLveVersionKurzzeitdaten(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
