/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenversion der Langzeitdaten.
<p>
Mit Hilfe dieser Bytes wird die Datenversion
					ausgewählt, mit der die zyklisch erfassten
					Verkehrsdaten übertragen werden sollen. Geräte, von
					denen eine nicht implementierte Version gefordert
					wird, antworten mit einer negativen Quittung
					(Fehlerursache 3). Wenn auf die Versionen 17, 18, 22
					oder 23 umgeschaltet wird, ohne dass zuvor mit dem
					DE-Block Typ 38 eine entsprechende Parametrierung
					der Grenzen der Geschwindigkeitsklassen vorgenommen
					wurde, dann werden die dort beschriebenen
					Defaultwerte für die Grenzen der
					Geschwindigkeitsklassen verwendet.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 8
 */
public class AttTlsLveVersionLangzeitdaten extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_10_VERSION_10 = new AttTlsLveVersionLangzeitdaten("Version 10", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_11_VERSION_11 = new AttTlsLveVersionLangzeitdaten("Version 11", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_12_VERSION_12 = new AttTlsLveVersionLangzeitdaten("Version 12", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_13_VERSION_13 = new AttTlsLveVersionLangzeitdaten("Version 13", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_14_VERSION_14 = new AttTlsLveVersionLangzeitdaten("Version 14", 		Short
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_15_VERSION_15 = new AttTlsLveVersionLangzeitdaten("Version 15", 		Short
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_16_VERSION_16 = new AttTlsLveVersionLangzeitdaten("Version 16", 		Short
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_17_VERSION_17 = new AttTlsLveVersionLangzeitdaten("Version 17", 		Short
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_18_VERSION_18 = new AttTlsLveVersionLangzeitdaten("Version 18", 		Short
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_19_VERSION_19 = new AttTlsLveVersionLangzeitdaten("Version 19", 		Short
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_20_VERSION_20 = new AttTlsLveVersionLangzeitdaten("Version 20", 		Short
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_21_VERSION_21 = new AttTlsLveVersionLangzeitdaten("Version 21", 		Short
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_22_VERSION_22 = new AttTlsLveVersionLangzeitdaten("Version 22", 		Short
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_23_VERSION_23 = new AttTlsLveVersionLangzeitdaten("Version 23", 		Short
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_24_VERSION_24 = new AttTlsLveVersionLangzeitdaten("Version 24", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsLveVersionLangzeitdaten ZUSTAND_255_LANGZEITDATEN_AUS = new AttTlsLveVersionLangzeitdaten("Langzeitdaten aus", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsLveVersionLangzeitdaten getZustand(final 		Short
	 value) {
		for (AttTlsLveVersionLangzeitdaten e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsLveVersionLangzeitdaten getZustand(final String value) {
		for (AttTlsLveVersionLangzeitdaten e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsLveVersionLangzeitdaten> getZustaende() {
		List<AttTlsLveVersionLangzeitdaten> list = new ArrayList<AttTlsLveVersionLangzeitdaten>();
		list.add(ZUSTAND_10_VERSION_10);
		list.add(ZUSTAND_11_VERSION_11);
		list.add(ZUSTAND_12_VERSION_12);
		list.add(ZUSTAND_13_VERSION_13);
		list.add(ZUSTAND_14_VERSION_14);
		list.add(ZUSTAND_15_VERSION_15);
		list.add(ZUSTAND_16_VERSION_16);
		list.add(ZUSTAND_17_VERSION_17);
		list.add(ZUSTAND_18_VERSION_18);
		list.add(ZUSTAND_19_VERSION_19);
		list.add(ZUSTAND_20_VERSION_20);
		list.add(ZUSTAND_21_VERSION_21);
		list.add(ZUSTAND_22_VERSION_22);
		list.add(ZUSTAND_23_VERSION_23);
		list.add(ZUSTAND_24_VERSION_24);
		list.add(ZUSTAND_255_LANGZEITDATEN_AUS);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSLveVersionLangzeitdaten.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsLveVersionLangzeitdaten(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsLveVersionLangzeitdaten(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
