/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anwort auf eine nicht auswertbares Telegramm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsSysNegativeQuittung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_0_SONSTIGE_FEHLERURSACHE = new AttTlsSysNegativeQuittung("sonstige Fehlerursache", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID = new AttTlsSysNegativeQuittung("unbekannte oder nicht auswertbare ID", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP = new AttTlsSysNegativeQuittung("unbekannter oder nicht auswertbarer Typ", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_3_KEIN_RUECKMELDUNG_MOEGLICH_DA_KANAL_GESTOERT = new AttTlsSysNegativeQuittung("Kein Rückmeldung möglich, da Kanal gestört", 		Short
	.valueOf("3"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_4_FREI = new AttTlsSysNegativeQuittung("frei", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_5_KOMMUNIKATIONSSTATUS_ENTHAELT_UNGUELTIGEN_WERT = new AttTlsSysNegativeQuittung("Kommunikationsstatus enthält ungültigen Wert", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_6_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_MEHR_E_A_KANAELE_ALS_PHYS_VORHANDEN = new AttTlsSysNegativeQuittung("Nachricht DE-Zuordnung enthält mehr E/A-Kanäle als phys. vorhanden", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_7_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_UNZULAESSIGE_DE_MIT_SAMMELADRESSE_XXX1_1111B_ = new AttTlsSysNegativeQuittung("Nachricht DE-Zuordnung enthält unzulässige DE mit Sammeladresse (XXX1 1111b)", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_8_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_ZU_EINEM_E_A_KANAL_DIE_FALSCHE_FG = new AttTlsSysNegativeQuittung("Nachricht DE-Zuordnung enthält zu einem E/A-Kanal die falsche FG", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_21_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_NICHT_VERFUEGBAR = new AttTlsSysNegativeQuittung("Datei bzw. dateiähnlicher Datenstrom nicht verfügbar", 		Short
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_22_ZUGRIFF_AUF_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_NICHT_MOEGLICH = new AttTlsSysNegativeQuittung("Zugriff auf Datei bzw. dateiähnlicher Datenstrom nicht möglich", 		Short
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_23_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_FEHLERHAFT_EMPFANGEN = new AttTlsSysNegativeQuittung("Datei bzw. dateiähnlicher Datenstrom fehlerhaft empfangen", 		Short
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_24_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_WURDE_NICHT_VOLLSTAENDIG_GESENDET = new AttTlsSysNegativeQuittung("Datei bzw. dateiähnlicher Datenstrom wurde nicht vollständig gesendet", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_64_NICHT_VORHANDENE_FUNKTIONSGRUPPE = new AttTlsSysNegativeQuittung("nicht vorhandene Funktionsgruppe", 		Short
	.valueOf("64"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_65_NICHT_VORHANDENER_DE = new AttTlsSysNegativeQuittung("nicht vorhandener DE", 		Short
	.valueOf("65"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_66_RICHTUNGSBIT_IM_ABRUFTELEGRAMM_WAR_1 = new AttTlsSysNegativeQuittung("Richtungsbit im Abruftelegramm war 1", 		Short
	.valueOf("66"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_67_JOBNUMMER_IN_ABRUFTELEGRAMM_IST_0 = new AttTlsSysNegativeQuittung("Jobnummer in Abruftelegramm ist 0", 		Short
	.valueOf("67"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_68_ANZAHL_EINZELTELEGRAMME_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR = new AttTlsSysNegativeQuittung("Anzahl Einzeltelegramme ist nicht mit gesamter OSI7-Länge vereinbar", 		Short
	.valueOf("68"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_69_LAENGENBYTE_DES_EINZELTELEGRAMMS_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR = new AttTlsSysNegativeQuittung("Längenbyte des Einzeltelegramms ist nicht mit gesamter OSI7-Länge vereinbar", 		Short
	.valueOf("69"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_70_ANZAHL_DE_BLOECKE_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR = new AttTlsSysNegativeQuittung("Anzahl DE-Blöcke ist nicht mit gesamter OSI7-Länge vereinbar", 		Short
	.valueOf("70"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_71_LAENGE_DE_BLOCK_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR = new AttTlsSysNegativeQuittung("Länge DE-Block ist nicht mit gesamter OSI7-Länge vereinbar", 		Short
	.valueOf("71"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_72_ANZAHL_DE_BLOECKE_IST_NICHT_MIT_DEM_LAENGENBYTE_DES_EINZELTELEGRAMMS_VEREINBAR = new AttTlsSysNegativeQuittung("Anzahl DE-Blöcke ist nicht mit dem Längenbyte des Einzeltelegramms vereinbar", 		Short
	.valueOf("72"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_73_LAENGE_DE_BLOCK_IST_NICHT_MIT_DEM_LAENGENBYTE_DES_EINZELTELEGRAMMS_VEREINBAR = new AttTlsSysNegativeQuittung("Länge DE-Block ist nicht mit dem Längenbyte des Einzeltelegramms vereinbar", 		Short
	.valueOf("73"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_74_EMPFAENGER_ODER_UEBERTRAGUNGSWEG_IST_GESTOERT = new AttTlsSysNegativeQuittung("Empfänger oder Übertragungsweg ist gestört", 		Short
	.valueOf("74"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_75_ANZAHL_DER_DE_BLOECKE_IST_UNZULAESSIG = new AttTlsSysNegativeQuittung("Anzahl der DE-Blöcke ist unzulässig", 		Short
	.valueOf("75"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_76_FALSCHE_KNOTENNUMMER = new AttTlsSysNegativeQuittung("falsche Knotennummer", 		Short
	.valueOf("76"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_77_FEHLERHAFTE_OSI_3_ROUTINGINFORMATION = new AttTlsSysNegativeQuittung("fehlerhafte OSI-3 Routinginformation", 		Short
	.valueOf("77"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsSysNegativeQuittung ZUSTAND_78_ANZAHL_EINZELTELEGRAMME_UNZULAESSIG = new AttTlsSysNegativeQuittung("Anzahl Einzeltelegramme unzulässig", 		Short
	.valueOf("78"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsSysNegativeQuittung getZustand(final 		Short
	 value) {
		for (AttTlsSysNegativeQuittung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsSysNegativeQuittung getZustand(final String value) {
		for (AttTlsSysNegativeQuittung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsSysNegativeQuittung> getZustaende() {
		List<AttTlsSysNegativeQuittung> list = new ArrayList<AttTlsSysNegativeQuittung>();
		list.add(ZUSTAND_0_SONSTIGE_FEHLERURSACHE);
		list.add(ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID);
		list.add(ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP);
		list.add(ZUSTAND_3_KEIN_RUECKMELDUNG_MOEGLICH_DA_KANAL_GESTOERT);
		list.add(ZUSTAND_4_FREI);
		list.add(ZUSTAND_5_KOMMUNIKATIONSSTATUS_ENTHAELT_UNGUELTIGEN_WERT);
		list.add(ZUSTAND_6_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_MEHR_E_A_KANAELE_ALS_PHYS_VORHANDEN);
		list.add(ZUSTAND_7_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_UNZULAESSIGE_DE_MIT_SAMMELADRESSE_XXX1_1111B_);
		list.add(ZUSTAND_8_NACHRICHT_DE_ZUORDNUNG_ENTHAELT_ZU_EINEM_E_A_KANAL_DIE_FALSCHE_FG);
		list.add(ZUSTAND_21_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_22_ZUGRIFF_AUF_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_NICHT_MOEGLICH);
		list.add(ZUSTAND_23_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_FEHLERHAFT_EMPFANGEN);
		list.add(ZUSTAND_24_DATEI_BZW_DATEIAEHNLICHER_DATENSTROM_WURDE_NICHT_VOLLSTAENDIG_GESENDET);
		list.add(ZUSTAND_64_NICHT_VORHANDENE_FUNKTIONSGRUPPE);
		list.add(ZUSTAND_65_NICHT_VORHANDENER_DE);
		list.add(ZUSTAND_66_RICHTUNGSBIT_IM_ABRUFTELEGRAMM_WAR_1);
		list.add(ZUSTAND_67_JOBNUMMER_IN_ABRUFTELEGRAMM_IST_0);
		list.add(ZUSTAND_68_ANZAHL_EINZELTELEGRAMME_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR);
		list.add(ZUSTAND_69_LAENGENBYTE_DES_EINZELTELEGRAMMS_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR);
		list.add(ZUSTAND_70_ANZAHL_DE_BLOECKE_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR);
		list.add(ZUSTAND_71_LAENGE_DE_BLOCK_IST_NICHT_MIT_GESAMTER_OSI7_LAENGE_VEREINBAR);
		list.add(ZUSTAND_72_ANZAHL_DE_BLOECKE_IST_NICHT_MIT_DEM_LAENGENBYTE_DES_EINZELTELEGRAMMS_VEREINBAR);
		list.add(ZUSTAND_73_LAENGE_DE_BLOCK_IST_NICHT_MIT_DEM_LAENGENBYTE_DES_EINZELTELEGRAMMS_VEREINBAR);
		list.add(ZUSTAND_74_EMPFAENGER_ODER_UEBERTRAGUNGSWEG_IST_GESTOERT);
		list.add(ZUSTAND_75_ANZAHL_DER_DE_BLOECKE_IST_UNZULAESSIG);
		list.add(ZUSTAND_76_FALSCHE_KNOTENNUMMER);
		list.add(ZUSTAND_77_FEHLERHAFTE_OSI_3_ROUTINGINFORMATION);
		list.add(ZUSTAND_78_ANZAHL_EINZELTELEGRAMME_UNZULAESSIG);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSSysNegativeQuittung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsSysNegativeQuittung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsSysNegativeQuittung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
