/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Niederschlagart.
<p>
In der Atmosphäre fallender Niederschlag. Wird
					gleichzeitig Niederschlagsintensität ermittelt, ist
					diese an der gleichen Stelle vorzunehmen. Es wird
					darauf hingewiesen, dass von der Streckenstation
					bzw. der Sensorik nicht alle Ausprägungen
					unterstützt werden müssen. Welcher
					Differenzierungsgrad notwendig und sinnvoll ist,
					hängt von der Anwendung ab. Bei einfachen
					Anwendungen können die Ausprägungen 0 und 40, bei
					normalen Anforderungen 0, 60 und 70 ( entspricht den
					bisher verwendeten Ausprägungen 00, 01, 02 des Typs
					63 ) ausreichen. Es werden die Klassifikation und
					die Codes nach WMO Tabelle 4680 verwendet.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 254L,
	einheit = ""
)
public class AttTlsUfdNiederschlagart extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("254");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Kein Niederschlag.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_0_KEIN_NIEDERSCHLAG = new AttTlsUfdNiederschlagart("kein Niederschlag", 		Short
	.valueOf("0"));

	/**
	Niederschlag aller Art.
	<p>
	Nicht näher Klassifizier- und
								quantifizierbar oder Sensorik nicht dafür
								ausgelegt.
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_40_NIEDERSCHLAG_ALLER_ART = new AttTlsUfdNiederschlagart("Niederschlag aller Art", 		Short
	.valueOf("40"));

	/**
	Leichter oder mittlerer Niederschlag aller
								Art (kleiner 50 Partikel&#47;Minute).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_41_LEICHTER_MITTLERER_NIEDERSCHLAG = new AttTlsUfdNiederschlagart("Leichter/mittlerer Niederschlag", 		Short
	.valueOf("41"));

	/**
	42 Starker Niederschlag aller Art ( &gt; 50
								Partikel&#47;Minute).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_42_STARKER_NIEDERSCHLAG = new AttTlsUfdNiederschlagart("starker Niederschlag", 		Short
	.valueOf("42"));

	/**
	Sprühregen (keine weitere Klassifikation von
								Sprühregen möglich).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_50_SPRUEHREGEN = new AttTlsUfdNiederschlagart("Sprühregen", 		Short
	.valueOf("50"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_51_SPRUEHREGEN_WMO1 = new AttTlsUfdNiederschlagart("Sprühregen WMO1", 		Short
	.valueOf("51"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_52_SPRUEHREGEN_WMO2 = new AttTlsUfdNiederschlagart("Sprühregen WMO2", 		Short
	.valueOf("52"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_53_SPRUEHREGEN_WMO3 = new AttTlsUfdNiederschlagart("Sprühregen WMO3", 		Short
	.valueOf("53"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_54_SPRUEHREGEN_WMO4 = new AttTlsUfdNiederschlagart("Sprühregen WMO4", 		Short
	.valueOf("54"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_55_SPRUEHREGEN_WMO5 = new AttTlsUfdNiederschlagart("Sprühregen WMO5", 		Short
	.valueOf("55"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_56_SPRUEHREGEN_WMO6 = new AttTlsUfdNiederschlagart("Sprühregen WMO6", 		Short
	.valueOf("56"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_57_SPRUEHREGEN_WMO7 = new AttTlsUfdNiederschlagart("Sprühregen WMO7", 		Short
	.valueOf("57"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_58_SPRUEHREGEN_WMO8 = new AttTlsUfdNiederschlagart("Sprühregen WMO8", 		Short
	.valueOf("58"));

	/**
	Sprühregen (Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_59_SPRUEHREGEN_WMO9 = new AttTlsUfdNiederschlagart("Sprühregen WMO9", 		Short
	.valueOf("59"));

	/**
	Regen bzw. flüssiger Niederschlag (Keine
								weitere Klassifikation von Regen möglich).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_60_REGEN = new AttTlsUfdNiederschlagart("Regen", 		Short
	.valueOf("60"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_61_REGEN_WMO1 = new AttTlsUfdNiederschlagart("Regen WMO1", 		Short
	.valueOf("61"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_62_REGEN_WMO2 = new AttTlsUfdNiederschlagart("Regen WMO2", 		Short
	.valueOf("62"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_63_REGEN_WMO3 = new AttTlsUfdNiederschlagart("Regen WMO3", 		Short
	.valueOf("63"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_64_REGEN_WMO4 = new AttTlsUfdNiederschlagart("Regen WMO4", 		Short
	.valueOf("64"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_65_REGEN_WMO5 = new AttTlsUfdNiederschlagart("Regen WMO5", 		Short
	.valueOf("65"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_66_REGEN_WMO6 = new AttTlsUfdNiederschlagart("Regen WMO6", 		Short
	.valueOf("66"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_67_REGEN_WMO7 = new AttTlsUfdNiederschlagart("Regen WMO7", 		Short
	.valueOf("67"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_68_REGEN_WMO8 = new AttTlsUfdNiederschlagart("Regen WMO8", 		Short
	.valueOf("68"));

	/**
	Regen bzw. flüssiger
								Niederschlag(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_69_REGEN_WMO9 = new AttTlsUfdNiederschlagart("Regen WMO9", 		Short
	.valueOf("69"));

	/**
	Schnee bzw. gefrorener Niederschlag (Keine
								weitere Klassifikation von gefrorenem
								Niederschlag möglich).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_70_SCHNEEG_GEFRORENER_NIEDERSCHLAG = new AttTlsUfdNiederschlagart("SchneeG/gefrorener Niederschlag", 		Short
	.valueOf("70"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_71_SCHNEE_WMO1 = new AttTlsUfdNiederschlagart("Schnee WMO1", 		Short
	.valueOf("71"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_72_SCHNEE_WMO2 = new AttTlsUfdNiederschlagart("Schnee WMO2", 		Short
	.valueOf("72"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_73_SCHNEE_WMO3 = new AttTlsUfdNiederschlagart("Schnee WMO3", 		Short
	.valueOf("73"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_74_GRAUPEL_WMO1 = new AttTlsUfdNiederschlagart("Graupel WMO1", 		Short
	.valueOf("74"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_75_GRAUPEL_WMO2 = new AttTlsUfdNiederschlagart("Graupel WMO2", 		Short
	.valueOf("75"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_76_GRAUPEL_WMO3 = new AttTlsUfdNiederschlagart("Graupel WMO3", 		Short
	.valueOf("76"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_77_HAGEL_WMO1 = new AttTlsUfdNiederschlagart("Hagel WMO1", 		Short
	.valueOf("77"));

	/**
	Regen bzw. flüssiger Niederschlag
								(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_78_HAGEL_WMO2 = new AttTlsUfdNiederschlagart("Hagel WMO2", 		Short
	.valueOf("78"));

	/**
	Regen bzw. flüssiger
								Niederschlag(Klassikfikation nach WMO).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_79_HAGEL_WMO3 = new AttTlsUfdNiederschlagart("Hagel WMO3", 		Short
	.valueOf("79"));

	/**
	Sensorik kann auf Grund der herrschenden
								Bedingungen Zustand nicht bestimmen.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdNiederschlagart ZUSTAND_255_ZUSTAND_NICHT_ERMITTELBAR = new AttTlsUfdNiederschlagart("Zustand nicht ermittelbar", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsUfdNiederschlagart getZustand(final 		Short
	 value) {
		for (AttTlsUfdNiederschlagart e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsUfdNiederschlagart getZustand(final String value) {
		for (AttTlsUfdNiederschlagart e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsUfdNiederschlagart> getZustaende() {
		List<AttTlsUfdNiederschlagart> list = new ArrayList<AttTlsUfdNiederschlagart>();
		list.add(ZUSTAND_0_KEIN_NIEDERSCHLAG);
		list.add(ZUSTAND_40_NIEDERSCHLAG_ALLER_ART);
		list.add(ZUSTAND_41_LEICHTER_MITTLERER_NIEDERSCHLAG);
		list.add(ZUSTAND_42_STARKER_NIEDERSCHLAG);
		list.add(ZUSTAND_50_SPRUEHREGEN);
		list.add(ZUSTAND_51_SPRUEHREGEN_WMO1);
		list.add(ZUSTAND_52_SPRUEHREGEN_WMO2);
		list.add(ZUSTAND_53_SPRUEHREGEN_WMO3);
		list.add(ZUSTAND_54_SPRUEHREGEN_WMO4);
		list.add(ZUSTAND_55_SPRUEHREGEN_WMO5);
		list.add(ZUSTAND_56_SPRUEHREGEN_WMO6);
		list.add(ZUSTAND_57_SPRUEHREGEN_WMO7);
		list.add(ZUSTAND_58_SPRUEHREGEN_WMO8);
		list.add(ZUSTAND_59_SPRUEHREGEN_WMO9);
		list.add(ZUSTAND_60_REGEN);
		list.add(ZUSTAND_61_REGEN_WMO1);
		list.add(ZUSTAND_62_REGEN_WMO2);
		list.add(ZUSTAND_63_REGEN_WMO3);
		list.add(ZUSTAND_64_REGEN_WMO4);
		list.add(ZUSTAND_65_REGEN_WMO5);
		list.add(ZUSTAND_66_REGEN_WMO6);
		list.add(ZUSTAND_67_REGEN_WMO7);
		list.add(ZUSTAND_68_REGEN_WMO8);
		list.add(ZUSTAND_69_REGEN_WMO9);
		list.add(ZUSTAND_70_SCHNEEG_GEFRORENER_NIEDERSCHLAG);
		list.add(ZUSTAND_71_SCHNEE_WMO1);
		list.add(ZUSTAND_72_SCHNEE_WMO2);
		list.add(ZUSTAND_73_SCHNEE_WMO3);
		list.add(ZUSTAND_74_GRAUPEL_WMO1);
		list.add(ZUSTAND_75_GRAUPEL_WMO2);
		list.add(ZUSTAND_76_GRAUPEL_WMO3);
		list.add(ZUSTAND_77_HAGEL_WMO1);
		list.add(ZUSTAND_78_HAGEL_WMO2);
		list.add(ZUSTAND_79_HAGEL_WMO3);
		list.add(ZUSTAND_255_ZUSTAND_NICHT_ERMITTELBAR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSUfdNiederschlagart.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsUfdNiederschlagart(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsUfdNiederschlagart(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
