/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Zustand der Fahrbahnoberfläche.
<p>
Es ist zu beachten, dass in Relation zur Strecke die
					Messung immer nur punktförmig sein kann und daher
					die Ergebnisse entsprechend interpretiert werden
					müssen. Die Benetzung bzw. Bedeckung wird immer
					bezogen auf eine glatte ebene Fläche. Die
					Einschätzung der Gefährlichkeit einer Benetzung oder
					Bedeckung in Bezug zur Beschaffenheit des
					Fahrbahnbelags (Rauhigkeit etc.) und den besonderen
					Bedingungen der betreffenden Straßenstrecke muss in
					der Zentrale vorgenommen werden. Es ist nicht
					erforderlich, dass die Sensortechnik alle Zustände
					direkt als solches detektieren kann. Es genügt
					vielmehr, wenn die zur Bildung der Zustände
					beitragenden Einflüsse gemessen werden können, so
					dass der betreffende Zustand als wahrscheinlich
					angenommen werden kann. Von einer Fahrbahnmessstelle
					müssen nicht alle Ausprägungen unterstützt werden.
					Die Menge der Benetzung bzw. Bedeckung, soweit
					bestimmbar, wird durch die ?Wasserfilmdicke? (mm
					bzw. l&#47;m2 ) angegeben.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 254L,
	einheit = ""
)
public class AttTlsUfdZustandFahrbahnoberflaeche extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("254");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Fahrbahn ist vollkommen Trocken (kleiner ca.
								30 ml&#47;m2 = 0,03 mm), schnee- und eisfrei.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_0_TROCKEN = new AttTlsUfdZustandFahrbahnoberflaeche("trocken", 		Short
	.valueOf("0"));

	/**
	Fahrbahn ist feucht bzw. nass, oder schnee-
								oder eisbedeckt.
	<p>
	Fahrbahn ist feucht bzw. nass, oder schnee-
								oder eisbedeckt. Die Benetzung bzw.
								Bedeckung übersteigt ca. 30 ml&#47;m2 = 0,03 mm.
								Nähere Differenzierung der Bedeckungsart
								nicht möglich.
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_1_FEUCHT = new AttTlsUfdZustandFahrbahnoberflaeche("feucht", 		Short
	.valueOf("1"));

	/**
	Fahrbahn ist benetzt mit flüssigem Wasser
								bzw. wässriger Lösung.
	<p>
	Die Menge übersteigt ca. 30 ml&#47;m2 = 0,03 mm.
								Nähere Differenzierung nicht möglich.
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_32_NASS = new AttTlsUfdZustandFahrbahnoberflaeche("nass", 		Short
	.valueOf("32"));

	/**
	Fahrbahn ist bedeckt mit gefrorenem Wasser
								bzw. wässriger Lösung in festem Zustand.
								Weitere Differenzierung nicht möglich.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_64_GEFRORENES_WASSER = new AttTlsUfdZustandFahrbahnoberflaeche("gefrorenes Wasser", 		Short
	.valueOf("64"));

	/**
	Fahrbahn ist bedeckt mit Schnee oder
								Schneematsch. Gemisch von flüssigem und
								gefrorenem Wasser bzw. wässriger Lösung.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_65_SCHNEE_SCHNEEMATSCH = new AttTlsUfdZustandFahrbahnoberflaeche("Schnee/Schneematsch", 		Short
	.valueOf("65"));

	/**
	Fahrbahn ist bedeckt mit Eis (festes,
								gefrorenes Wasser bzw. gefrorene wässrige
								Lösung).
	<p>
	
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_66_EIS = new AttTlsUfdZustandFahrbahnoberflaeche("Eis", 		Short
	.valueOf("66"));

	/**
	Fahrbahn ist bedeckt mit Rauhreif.
	<p>
	Fahrbahn ist bedeckt mit Rauhreif. Aus der
								Luft sublimierte Eiskristalle ohne deckende
								Eisfläche. Die Taupunkttemperatur liegt nahe
								der Fahrbahnoberflächen- Temperatur und
								liegt unter der Gefriertemperatur.
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_67_RAUREIF = new AttTlsUfdZustandFahrbahnoberflaeche("Raureif", 		Short
	.valueOf("67"));

	/**
	Sensorik kann auf Grund der herrschenden
								Bedingungen Zustand nicht bestimmen.
	<p>
	
	</p>
	*/
	public static final AttTlsUfdZustandFahrbahnoberflaeche ZUSTAND_255_ZUSTAND_NICHT_ERMITTELBAR = new AttTlsUfdZustandFahrbahnoberflaeche("Zustand nicht ermittelbar", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsUfdZustandFahrbahnoberflaeche getZustand(final 		Short
	 value) {
		for (AttTlsUfdZustandFahrbahnoberflaeche e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsUfdZustandFahrbahnoberflaeche getZustand(final String value) {
		for (AttTlsUfdZustandFahrbahnoberflaeche e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsUfdZustandFahrbahnoberflaeche> getZustaende() {
		List<AttTlsUfdZustandFahrbahnoberflaeche> list = new ArrayList<AttTlsUfdZustandFahrbahnoberflaeche>();
		list.add(ZUSTAND_0_TROCKEN);
		list.add(ZUSTAND_1_FEUCHT);
		list.add(ZUSTAND_32_NASS);
		list.add(ZUSTAND_64_GEFRORENES_WASSER);
		list.add(ZUSTAND_65_SCHNEE_SCHNEEMATSCH);
		list.add(ZUSTAND_66_EIS);
		list.add(ZUSTAND_67_RAUREIF);
		list.add(ZUSTAND_255_ZUSTAND_NICHT_ERMITTELBAR);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSUfdZustandFahrbahnoberfläche.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsUfdZustandFahrbahnoberflaeche(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsUfdZustandFahrbahnoberflaeche(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
