/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Schwere des Ausfalls bei defekten LED-Ketten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class AttTlsWzgLedKettenSchwereDesAusfalls extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgLedKettenSchwereDesAusfalls ZUSTAND_0_KEINE_STOERUNG = new AttTlsWzgLedKettenSchwereDesAusfalls("Keine Störung", 		Byte
	.valueOf("0"));

	/**
	Min. 1 Kette ausgefallen, aber noch keine Gefahr, dass Zeichen nicht darstellbar.
	<p>
	Es ist mindestens eine Kette ausgefallen aber es besteht noch keine Gefahr, dass beim
								Ausfall
								einer weiteren Kette ein Zeichen nicht mehr darstellbar sein wird.
	</p>
	*/
	public static final AttTlsWzgLedKettenSchwereDesAusfalls ZUSTAND_1_MIN_1_KETTE_AUSGEFALLEN_ABER_NOCH_KEINE_GEFAHR_DASS_ZEICHEN_NICHT_DARSTELLBAR = new AttTlsWzgLedKettenSchwereDesAusfalls("Min. 1 Kette ausgefallen, aber noch keine Gefahr, dass Zeichen nicht darstellbar", 		Byte
	.valueOf("1"));

	/**
	Ausfall einer weiteren Kette kann zu nicht darstellbaren Zeichen führen.
	<p>
	Der Ausfall einer weiteren Kette kann zu nicht darstellbaren Zeichen führen.
	</p>
	*/
	public static final AttTlsWzgLedKettenSchwereDesAusfalls ZUSTAND_2_AUSFALL_EINER_WEITEREN_KETTE_KANN_ZU_NICHT_DARSTELLBAREN_ZEICHEN_FUEHREN = new AttTlsWzgLedKettenSchwereDesAusfalls("Ausfall einer weiteren Kette kann zu nicht darstellbaren Zeichen führen", 		Byte
	.valueOf("2"));

	/**
	Ausfall der Ketten hat bereits zu nicht darstellbaren Zeichen geführt.
	<p>
	Der Ausfall der Ketten hat bereits zu nicht darstellbaren Zeichen geführt.
	</p>
	*/
	public static final AttTlsWzgLedKettenSchwereDesAusfalls ZUSTAND_3_AUSFALL_DER_KETTEN_HAT_BEREITS_ZU_NICHT_DARSTELLBAREN_ZEICHEN_GEFUEHRT = new AttTlsWzgLedKettenSchwereDesAusfalls("Ausfall der Ketten hat bereits zu nicht darstellbaren Zeichen geführt", 		Byte
	.valueOf("3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsWzgLedKettenSchwereDesAusfalls getZustand(final 		Byte
	 value) {
		for (AttTlsWzgLedKettenSchwereDesAusfalls e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsWzgLedKettenSchwereDesAusfalls getZustand(final String value) {
		for (AttTlsWzgLedKettenSchwereDesAusfalls e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsWzgLedKettenSchwereDesAusfalls> getZustaende() {
		List<AttTlsWzgLedKettenSchwereDesAusfalls> list = new ArrayList<AttTlsWzgLedKettenSchwereDesAusfalls>();
		list.add(ZUSTAND_0_KEINE_STOERUNG);
		list.add(ZUSTAND_1_MIN_1_KETTE_AUSGEFALLEN_ABER_NOCH_KEINE_GEFAHR_DASS_ZEICHEN_NICHT_DARSTELLBAR);
		list.add(ZUSTAND_2_AUSFALL_EINER_WEITEREN_KETTE_KANN_ZU_NICHT_DARSTELLBAREN_ZEICHEN_FUEHREN);
		list.add(ZUSTAND_3_AUSFALL_DER_KETTEN_HAT_BEREITS_ZU_NICHT_DARSTELLBAREN_ZEICHEN_GEFUEHRT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSWzgLedKettenSchwereDesAusfalls.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsWzgLedKettenSchwereDesAusfalls(final 		Byte
	 value) {
		super(value);
	}
	
	private AttTlsWzgLedKettenSchwereDesAusfalls(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
