/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Anwort auf eine nicht auswertbares Telegramm.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
@Wertebereich(
	minimum = 0L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsWzgNegativeQuittung extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_0_SONSTIGE_FEHLERURSACHE = new AttTlsWzgNegativeQuittung("sonstige Fehlerursache", 		Short
	.valueOf("0"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID = new AttTlsWzgNegativeQuittung("unbekannte oder nicht auswertbare ID", 		Short
	.valueOf("1"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP = new AttTlsWzgNegativeQuittung("unbekannter oder nicht auswertbarer Typ", 		Short
	.valueOf("2"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_4_STELLCODE_AUF_DIESEM_WZG_ODER_AQ_NICHT_VORHANDEN = new AttTlsWzgNegativeQuittung("Stellcode auf diesem Wzg oder AQ nicht vorhanden", 		Short
	.valueOf("4"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_5_STELLCODE_WEGEN_DEFEKTER_ANZEIGE_LAMPEN_PRISMA_ODER_ROLLO_NICHT_SCHALTBAR = new AttTlsWzgNegativeQuittung("Stellcode wegen defekter Anzeige (Lampen, Prisma oder Rollo) nicht schaltbar", 		Short
	.valueOf("5"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_6_STELLCODE_WEGEN_SONSTIGER_HARDWARESTOERUNGEN_NICHT_SCHALTBAR = new AttTlsWzgNegativeQuittung("Stellcode wegen sonstiger Hardwarestörungen nicht schaltbar", 		Short
	.valueOf("6"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_7_HELLIGKEITSWERT_NICHT_EINSTELLBAR = new AttTlsWzgNegativeQuittung("Helligkeitswert nicht einstellbar", 		Short
	.valueOf("7"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_8_KEINE_AUTOMATISCHE_HELLIGKEITSSTEUERUNG_MOEGLICH = new AttTlsWzgNegativeQuittung("Keine automatische Helligkeitssteuerung möglich", 		Short
	.valueOf("8"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_9_BETRIEBSART_UNBEKANNT_BZW_NICHT_EINSTELLBAR = new AttTlsWzgNegativeQuittung("Betriebsart unbekannt bzw. nicht einstellbar", 		Short
	.valueOf("9"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_10_BEFEHL_BZW_PROGRAMM_IN_DIESER_BETRIEBSART_NICHT_AUSFUEHRBAR = new AttTlsWzgNegativeQuittung("Befehl bzw. Programm in dieser Betriebsart nicht ausführbar", 		Short
	.valueOf("10"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_11_NACHRICHT_NICHT_BEARBEITBAR_DA_PROJEKTIERUNGSDATEN_FEHLERHAFT_SIND = new AttTlsWzgNegativeQuittung("Nachricht nicht bearbeitbar, da Projektierungsdaten fehlerhaft sind", 		Short
	.valueOf("11"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_12_PUFFERINHALT_NICHT_VERFUEGBAR = new AttTlsWzgNegativeQuittung("Pufferinhalt nicht verfügbar", 		Short
	.valueOf("12"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_13_PRISMENCODE_NICHT_ZULAESSIG_Z_B_STELLUNG_4_FUER_DREIKANTPRISMA_ODER_BLINKERCODE_FUER_PRISMA_ = new AttTlsWzgNegativeQuittung("Prismencode nicht zulässig (z.B. Stellung 4 für Dreikantprisma oder Blinkercode für Prisma)", 		Short
	.valueOf("13"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_14_FUNKTIONSBYTE_UNZULAESSIG_Z_B_BLINKFUNKTION_NICHT_VORHANDEN_ = new AttTlsWzgNegativeQuittung("Funktionsbyte unzulässig (z.B. Blinkfunktion nicht vorhanden)", 		Short
	.valueOf("14"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_15_KANAL_PASSIVIERT = new AttTlsWzgNegativeQuittung("Kanal passiviert", 		Short
	.valueOf("15"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_16_VERRIEGELUNGSMATRIX_VERLETZT_FUER_STELLZUSTAENDE_EINES_AQ_ODER_PROGRAMM_EINER_KBA_ = new AttTlsWzgNegativeQuittung("Verriegelungsmatrix verletzt (für Stellzustände eines AQ oder Programm einer KBA)", 		Short
	.valueOf("16"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_17_ANZAHL_PRISMEN_ANZEIGEN_ODER_DES_IM_TELEGRAMM_STIMMT_NICHT_MIT_VORHANDENER_ANZAHL_UEBEREIN = new AttTlsWzgNegativeQuittung("Anzahl Prismen/Anzeigen oder DEs im Telegramm stimmt nicht mit vorhandener Anzahl überein", 		Short
	.valueOf("17"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_18_KEIN_FREIER_SPEICHERPLATZ_ZUM_ABLEGEN_VON_PROGRAMMDATEN_VORHANDEN = new AttTlsWzgNegativeQuittung("Kein freier Speicherplatz zum Ablegen von Programmdaten vorhanden", 		Short
	.valueOf("18"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_19_WECHSELTEXT_NICHT_DARSTELLBAR_DA_ZU_LANG = new AttTlsWzgNegativeQuittung("Wechseltext nicht darstellbar, da zu lang", 		Short
	.valueOf("19"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_20_WECHSELTEXT_ENTHAELT_NICHT_DARSTELLBARE_ZEICHEN = new AttTlsWzgNegativeQuittung("Wechseltext enthält nicht darstellbare Zeichen", 		Short
	.valueOf("20"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_21_FALSCHES_ANZEIGEPRINZIP = new AttTlsWzgNegativeQuittung("falsches Anzeigeprinzip", 		Short
	.valueOf("21"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_22_UNBEKANNTER_STELLCODE_GRAFIKTEXTKONSERVENNUMMER = new AttTlsWzgNegativeQuittung("unbekannter Stellcode/Grafiktextkonservennummer", 		Short
	.valueOf("22"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_23_UNBEKANNTE_BILDDEFINITION_GRAFIKTEXTKONSERVE = new AttTlsWzgNegativeQuittung("unbekannte Bilddefinition/Grafiktextkonserve", 		Short
	.valueOf("23"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_24_FEHLERHAFTE_BILDDEFINITION_GRAFIKTEXTKONSERVE = new AttTlsWzgNegativeQuittung("fehlerhafte Bilddefinition/Grafiktextkonserve", 		Short
	.valueOf("24"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_25_BEREITS_VERWENDETE_BILDDEFINITION_GRAFIKTEXTKONSERVE = new AttTlsWzgNegativeQuittung("bereits verwendete Bilddefinition/Grafiktextkonserve", 		Short
	.valueOf("25"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_32_VORHERIGES_PROGRAMM_NOCH_NICHT_ABGESCHLOSSEN = new AttTlsWzgNegativeQuittung("vorheriges Programm noch nicht abgeschlossen", 		Short
	.valueOf("32"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_33_BETRIEBSARTENWECHSEL_NICHT_ABGESCHLOSSEN = new AttTlsWzgNegativeQuittung("Betriebsartenwechsel nicht abgeschlossen", 		Short
	.valueOf("33"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_34_BETRIEBSART_NICHT_EINDEUTIG_FESTSTELLBAR = new AttTlsWzgNegativeQuittung("Betriebsart nicht eindeutig feststellbar", 		Short
	.valueOf("34"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_35_HELLIGKEITSUMSCHALTUNG_NOCH_NICHT_ABGESCHLOSSEN = new AttTlsWzgNegativeQuittung("Helligkeitsumschaltung noch nicht abgeschlossen", 		Short
	.valueOf("35"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_36_HELLIGKEIT_NICHT_EINDEUTIG_FESTSTELLBAR = new AttTlsWzgNegativeQuittung("Helligkeit nicht eindeutig feststellbar", 		Short
	.valueOf("36"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_37_KEINE_PROGRAMMDATEN_VERFUEGBAR = new AttTlsWzgNegativeQuittung("Keine Programmdaten verfügbar", 		Short
	.valueOf("37"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_38_UEBERGANG_ZUM_SIGNALPROGRAMM_NICHT_DEFINIERT = new AttTlsWzgNegativeQuittung("Übergang zum Signalprogramm nicht definiert", 		Short
	.valueOf("38"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_39_UEBERGANG_ZUM_GRUNDPROGRAMM_NICHT_DEFINIERT = new AttTlsWzgNegativeQuittung("Übergang zum Grundprogramm nicht definiert", 		Short
	.valueOf("39"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_40_PROGRAMMDATEN_UNVOLLSTAENDIG = new AttTlsWzgNegativeQuittung("Programmdaten unvollständig", 		Short
	.valueOf("40"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_41_STELLCODE_VORRAT_NICHT_AENDERBAR = new AttTlsWzgNegativeQuittung("Stellcode-Vorrat nicht änderbar", 		Short
	.valueOf("41"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_42_STELLCODE_DEFINITION_NICHT_AENDERBAR = new AttTlsWzgNegativeQuittung("Stellcode-Definition nicht änderbar", 		Short
	.valueOf("42"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_43_UNZULAESSIGER_STELLCODE = new AttTlsWzgNegativeQuittung("Unzulässiger Stellcode", 		Short
	.valueOf("43"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_44_KURZVERSION_MIT_DIESEM_STELLCODE_NICHT_ZULAESSIG = new AttTlsWzgNegativeQuittung("Kurzversion mit diesem Stellcode nicht zulässig", 		Short
	.valueOf("44"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_45_STELLCODE_BEI_STEUERUNGSPRINZIP_1_NICHT_ZULAESSIG = new AttTlsWzgNegativeQuittung("Stellcode bei Steuerungsprinzip 1 nicht zulässig", 		Short
	.valueOf("45"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_46_LANGVERSION_NICHT_ZULAESSIG = new AttTlsWzgNegativeQuittung("Langversion nicht zulässig", 		Short
	.valueOf("46"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_47_LOESCHEN_BENUTZTER_STELLCODES_NICHT_ZULAESSIG = new AttTlsWzgNegativeQuittung("Löschen benutzter Stellcodes nicht zulässig", 		Short
	.valueOf("47"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgNegativeQuittung ZUSTAND_48_PROGRAMMDEFINITION_ENTHAELT_UNDEFINIERTEN_STELLCODE = new AttTlsWzgNegativeQuittung("Programmdefinition enthält undefinierten Stellcode", 		Short
	.valueOf("48"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsWzgNegativeQuittung getZustand(final 		Short
	 value) {
		for (AttTlsWzgNegativeQuittung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsWzgNegativeQuittung getZustand(final String value) {
		for (AttTlsWzgNegativeQuittung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsWzgNegativeQuittung> getZustaende() {
		List<AttTlsWzgNegativeQuittung> list = new ArrayList<AttTlsWzgNegativeQuittung>();
		list.add(ZUSTAND_0_SONSTIGE_FEHLERURSACHE);
		list.add(ZUSTAND_1_UNBEKANNTE_ODER_NICHT_AUSWERTBARE_ID);
		list.add(ZUSTAND_2_UNBEKANNTER_ODER_NICHT_AUSWERTBARER_TYP);
		list.add(ZUSTAND_4_STELLCODE_AUF_DIESEM_WZG_ODER_AQ_NICHT_VORHANDEN);
		list.add(ZUSTAND_5_STELLCODE_WEGEN_DEFEKTER_ANZEIGE_LAMPEN_PRISMA_ODER_ROLLO_NICHT_SCHALTBAR);
		list.add(ZUSTAND_6_STELLCODE_WEGEN_SONSTIGER_HARDWARESTOERUNGEN_NICHT_SCHALTBAR);
		list.add(ZUSTAND_7_HELLIGKEITSWERT_NICHT_EINSTELLBAR);
		list.add(ZUSTAND_8_KEINE_AUTOMATISCHE_HELLIGKEITSSTEUERUNG_MOEGLICH);
		list.add(ZUSTAND_9_BETRIEBSART_UNBEKANNT_BZW_NICHT_EINSTELLBAR);
		list.add(ZUSTAND_10_BEFEHL_BZW_PROGRAMM_IN_DIESER_BETRIEBSART_NICHT_AUSFUEHRBAR);
		list.add(ZUSTAND_11_NACHRICHT_NICHT_BEARBEITBAR_DA_PROJEKTIERUNGSDATEN_FEHLERHAFT_SIND);
		list.add(ZUSTAND_12_PUFFERINHALT_NICHT_VERFUEGBAR);
		list.add(ZUSTAND_13_PRISMENCODE_NICHT_ZULAESSIG_Z_B_STELLUNG_4_FUER_DREIKANTPRISMA_ODER_BLINKERCODE_FUER_PRISMA_);
		list.add(ZUSTAND_14_FUNKTIONSBYTE_UNZULAESSIG_Z_B_BLINKFUNKTION_NICHT_VORHANDEN_);
		list.add(ZUSTAND_15_KANAL_PASSIVIERT);
		list.add(ZUSTAND_16_VERRIEGELUNGSMATRIX_VERLETZT_FUER_STELLZUSTAENDE_EINES_AQ_ODER_PROGRAMM_EINER_KBA_);
		list.add(ZUSTAND_17_ANZAHL_PRISMEN_ANZEIGEN_ODER_DES_IM_TELEGRAMM_STIMMT_NICHT_MIT_VORHANDENER_ANZAHL_UEBEREIN);
		list.add(ZUSTAND_18_KEIN_FREIER_SPEICHERPLATZ_ZUM_ABLEGEN_VON_PROGRAMMDATEN_VORHANDEN);
		list.add(ZUSTAND_19_WECHSELTEXT_NICHT_DARSTELLBAR_DA_ZU_LANG);
		list.add(ZUSTAND_20_WECHSELTEXT_ENTHAELT_NICHT_DARSTELLBARE_ZEICHEN);
		list.add(ZUSTAND_21_FALSCHES_ANZEIGEPRINZIP);
		list.add(ZUSTAND_22_UNBEKANNTER_STELLCODE_GRAFIKTEXTKONSERVENNUMMER);
		list.add(ZUSTAND_23_UNBEKANNTE_BILDDEFINITION_GRAFIKTEXTKONSERVE);
		list.add(ZUSTAND_24_FEHLERHAFTE_BILDDEFINITION_GRAFIKTEXTKONSERVE);
		list.add(ZUSTAND_25_BEREITS_VERWENDETE_BILDDEFINITION_GRAFIKTEXTKONSERVE);
		list.add(ZUSTAND_32_VORHERIGES_PROGRAMM_NOCH_NICHT_ABGESCHLOSSEN);
		list.add(ZUSTAND_33_BETRIEBSARTENWECHSEL_NICHT_ABGESCHLOSSEN);
		list.add(ZUSTAND_34_BETRIEBSART_NICHT_EINDEUTIG_FESTSTELLBAR);
		list.add(ZUSTAND_35_HELLIGKEITSUMSCHALTUNG_NOCH_NICHT_ABGESCHLOSSEN);
		list.add(ZUSTAND_36_HELLIGKEIT_NICHT_EINDEUTIG_FESTSTELLBAR);
		list.add(ZUSTAND_37_KEINE_PROGRAMMDATEN_VERFUEGBAR);
		list.add(ZUSTAND_38_UEBERGANG_ZUM_SIGNALPROGRAMM_NICHT_DEFINIERT);
		list.add(ZUSTAND_39_UEBERGANG_ZUM_GRUNDPROGRAMM_NICHT_DEFINIERT);
		list.add(ZUSTAND_40_PROGRAMMDATEN_UNVOLLSTAENDIG);
		list.add(ZUSTAND_41_STELLCODE_VORRAT_NICHT_AENDERBAR);
		list.add(ZUSTAND_42_STELLCODE_DEFINITION_NICHT_AENDERBAR);
		list.add(ZUSTAND_43_UNZULAESSIGER_STELLCODE);
		list.add(ZUSTAND_44_KURZVERSION_MIT_DIESEM_STELLCODE_NICHT_ZULAESSIG);
		list.add(ZUSTAND_45_STELLCODE_BEI_STEUERUNGSPRINZIP_1_NICHT_ZULAESSIG);
		list.add(ZUSTAND_46_LANGVERSION_NICHT_ZULAESSIG);
		list.add(ZUSTAND_47_LOESCHEN_BENUTZTER_STELLCODES_NICHT_ZULAESSIG);
		list.add(ZUSTAND_48_PROGRAMMDEFINITION_ENTHAELT_UNDEFINIERTEN_STELLCODE);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSWzgNegativeQuittung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsWzgNegativeQuittung(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsWzgNegativeQuittung(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
