/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Gültige WVZ-Code entsprechend TLS.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = -1L,
	maximum = 255L,
	einheit = ""
)
public class AttTlsWzgWvzCode extends Zahl<		Short
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MIN_VALUE =
				Short
		.valueOf("-1");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Short
	 MAX_VALUE =
				Short
		.valueOf("255");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "";
	
	/**
	Anzeige ist ausgeschaltet.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_1N_AUS = new AttTlsWzgWvzCode("aus", 		Short
	.valueOf("-1"));

	/**
	101 Gefahrenstelle.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_1_GEFAHRENSTELLE = new AttTlsWzgWvzCode("Gefahrenstelle", 		Short
	.valueOf("1"));

	/**
	112 Unebene Fahrbahn.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_2_UNEBENE_FAHRBAHN = new AttTlsWzgWvzCode("Unebene Fahrbahn", 		Short
	.valueOf("2"));

	/**
	113 Glättegefahr.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_3_GLAETTEGEFAHR = new AttTlsWzgWvzCode("Glättegefahr", 		Short
	.valueOf("3"));

	/**
	114 Schleudergefahr bei Nässe oder Schmutz.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_4_SCHLEUDERGEFAHR = new AttTlsWzgWvzCode("Schleudergefahr", 		Short
	.valueOf("4"));

	/**
	120 (120 - 30) verengte Fahrbahn.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_5_VERENGTE_FAHRBAHN = new AttTlsWzgWvzCode("verengte Fahrbahn", 		Short
	.valueOf("5"));

	/**
	121 - 10 (120 - 10) einseitig verengte
								Fahrbahn rechts.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_6_VERENGTE_FAHRBAHN_RECHTS = new AttTlsWzgWvzCode("verengte Fahrbahn rechts", 		Short
	.valueOf("6"));

	/**
	121 - 20 (120 - 20) einseitig verengte
								Fahrbahn links.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_7_VERENGTE_FAHRBAHN_LINKS = new AttTlsWzgWvzCode("verengte Fahrbahn links", 		Short
	.valueOf("7"));

	/**
	123 Baustelle.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_8_BAUSTELLE = new AttTlsWzgWvzCode("Baustelle", 		Short
	.valueOf("8"));

	/**
	124 Stau.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_9_STAU = new AttTlsWzgWvzCode("Stau", 		Short
	.valueOf("9"));

	/**
	125 Gegenverkehr.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_10_GEGENVERKEHR = new AttTlsWzgWvzCode("Gegenverkehr", 		Short
	.valueOf("10"));

	/**
	- Schneefall.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_11_SCHNEEFALL = new AttTlsWzgWvzCode("Schneefall", 		Short
	.valueOf("11"));

	/**
	131 Lichtzeichenanlage.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_12_LICHTZEICHENANLAGE = new AttTlsWzgWvzCode("Lichtzeichenanlage", 		Short
	.valueOf("12"));

	/**
	274 - 52 Zulässige Höchstgeschwindigkeit 20
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_20__20_KM_H = new AttTlsWzgWvzCode("20 km/h", 		Short
	.valueOf("20"));

	/**
	274 - 53 Zulässige Höchstgeschwindigkeit 30
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_21__30_KM_H = new AttTlsWzgWvzCode("30 km/h", 		Short
	.valueOf("21"));

	/**
	274 - 54 Zulässige Höchstgeschwindigkeit 40
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_22__40_KM_H = new AttTlsWzgWvzCode("40 km/h", 		Short
	.valueOf("22"));

	/**
	274 - 55 Zulässige Höchstgeschwindigkeit 50
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_23__50_KM_H = new AttTlsWzgWvzCode("50 km/h", 		Short
	.valueOf("23"));

	/**
	274 - 56 Zulässige Höchstgeschwindigkeit 60
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_24__60_KM_H = new AttTlsWzgWvzCode("60 km/h", 		Short
	.valueOf("24"));

	/**
	274 - 57 Zulässige Höchstgeschwindigkeit 70
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_25__70_KM_H = new AttTlsWzgWvzCode("70 km/h", 		Short
	.valueOf("25"));

	/**
	274 - 58 Zulässige Höchstgeschwindigkeit 80
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_26__80_KM_H = new AttTlsWzgWvzCode("80 km/h", 		Short
	.valueOf("26"));

	/**
	274 - 59 Zulässige Höchstgeschwindigkeit 90
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_27__90_KM_H = new AttTlsWzgWvzCode("90 km/h", 		Short
	.valueOf("27"));

	/**
	274 - 60 Zulässige Höchstgeschwindigkeit 100
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_28__100_KM_H = new AttTlsWzgWvzCode("100 km/h", 		Short
	.valueOf("28"));

	/**
	274 - 61 Zulässige Höchstgeschwindigkeit 110
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_29__110_KM_H = new AttTlsWzgWvzCode("110 km/h", 		Short
	.valueOf("29"));

	/**
	274 - 62 Zulässige Höchstgeschwindigkeit 120
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_30__120_KM_H = new AttTlsWzgWvzCode("120 km/h", 		Short
	.valueOf("30"));

	/**
	276 Überholverbot für Kraftfahrzeuge aller
								Art.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_31_UEBERHOLVERBOT_ALLE = new AttTlsWzgWvzCode("Überholverbot alle", 		Short
	.valueOf("31"));

	/**
	277 Überholverbot für Lkw.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_32_UEBERHOLVERBOT_LKW = new AttTlsWzgWvzCode("Überholverbot Lkw", 		Short
	.valueOf("32"));

	/**
	274-63 Zulässige Höchstgeschwindigkeit 130
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_33__130_KM_H = new AttTlsWzgWvzCode("130 km/h", 		Short
	.valueOf("33"));

	/**
	270 Verkehrsverbot bei SMOG.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_38_VERKEHRSVERBOT_BEI_SMOG = new AttTlsWzgWvzCode("Verkehrsverbot bei SMOG", 		Short
	.valueOf("38"));

	/**
	250 Verbot für Fahrzeuge aller Art.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_39_VERBOT_FUER_FAHRZEUGE_ALLER_ART = new AttTlsWzgWvzCode("Verbot für Fahrzeuge aller Art", 		Short
	.valueOf("39"));

	/**
	278-52 Ende der zulässigen
								Höchstgeschwindigkeit 20 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_40_ENDE_20_KM_H = new AttTlsWzgWvzCode("Ende 20 km/h", 		Short
	.valueOf("40"));

	/**
	278-53 Ende der zulässigen
								Höchstgeschwindigkeit 30 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_41_ENDE_30_KM_H = new AttTlsWzgWvzCode("Ende 30 km/h", 		Short
	.valueOf("41"));

	/**
	278-54 Ende der zulässigen
								Höchstgeschwindigkeit 40 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_42_ENDE_40_KM_H = new AttTlsWzgWvzCode("Ende 40 km/h", 		Short
	.valueOf("42"));

	/**
	278-55 Ende der zulässigen
								Höchstgeschwindigkeit 50 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_43_ENDE_50_KM_H = new AttTlsWzgWvzCode("Ende 50 km/h", 		Short
	.valueOf("43"));

	/**
	278-56 Ende der zulässigen
								Höchstgeschwindigkeit 60 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_44_ENDE_60_KM_H = new AttTlsWzgWvzCode("Ende 60 km/h", 		Short
	.valueOf("44"));

	/**
	278-57 Ende der zulässigen
								Höchstgeschwindigkeit 70 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_45_ENDE_70_KM_H = new AttTlsWzgWvzCode("Ende 70 km/h", 		Short
	.valueOf("45"));

	/**
	278-58 Ende der zulässigen
								Höchstgeschwindigkeit 80 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_46_ENDE_80_KM_H = new AttTlsWzgWvzCode("Ende 80 km/h", 		Short
	.valueOf("46"));

	/**
	278-59 Ende der zulässigen
								Höchstgeschwindigkeit 90 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_47_ENDE_90_KM_H = new AttTlsWzgWvzCode("Ende 90 km/h", 		Short
	.valueOf("47"));

	/**
	278-60 Ende der zulässigen
								Höchstgeschwindigkeit 100 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_48_ENDE_100_KM_H = new AttTlsWzgWvzCode("Ende 100 km/h", 		Short
	.valueOf("48"));

	/**
	278-61 Ende der zulässigen
								Höchstgeschwindigkeit 110 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_49_ENDE_110_KM_H = new AttTlsWzgWvzCode("Ende 110 km/h", 		Short
	.valueOf("49"));

	/**
	278-62 Ende der zulässigen
								Höchstgeschwindigkeit 120 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_50_ENDE_120_KM_H = new AttTlsWzgWvzCode("Ende 120 km/h", 		Short
	.valueOf("50"));

	/**
	280 Ende Überholverbot für Kraftfahrzeuge
								aller Art.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_51_ENDE_UEBERHOLVERBOT_ALLE = new AttTlsWzgWvzCode("Ende Überholverbot alle", 		Short
	.valueOf("51"));

	/**
	281 Ende Überholverbot für Lkw.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_52_ENDE_UEBERHOLVERBOT_LKW = new AttTlsWzgWvzCode("Ende Überholverbot Lkw", 		Short
	.valueOf("52"));

	/**
	282 Ende sämtlicher Streckenverbote.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_53_ENDE_SAEMTLICHER_STRECKENVERBOTE = new AttTlsWzgWvzCode("Ende sämtlicher Streckenverbote", 		Short
	.valueOf("53"));

	/**
	278 - Ende der zulässigen
								Höchstgeschwindigkeit 130 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_54_ENDE_130_KM_H = new AttTlsWzgWvzCode("Ende 130 km/h", 		Short
	.valueOf("54"));

	/**
	gelbes Blinklicht.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_61_GELBES_BLINKLICHT = new AttTlsWzgWvzCode("gelbes Blinklicht", 		Short
	.valueOf("61"));

	/**
	STAU.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_62_STAU = new AttTlsWzgWvzCode("STAU", 		Short
	.valueOf("62"));

	/**
	STAUGEFAHR.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_63_STAUGEFAHR = new AttTlsWzgWvzCode("STAUGEFAHR", 		Short
	.valueOf("63"));

	/**
	NEBEL.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_64_NEBEL = new AttTlsWzgWvzCode("NEBEL", 		Short
	.valueOf("64"));

	/**
	NÄSSE.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_65_NAESSE = new AttTlsWzgWvzCode("NÄSSE", 		Short
	.valueOf("65"));

	/**
	UNFALL.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_66_UNFALL = new AttTlsWzgWvzCode("UNFALL", 		Short
	.valueOf("66"));

	/**
	SICHT.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_67_SICHT = new AttTlsWzgWvzCode("SICHT", 		Short
	.valueOf("67"));

	/**
	
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_68_SMOG = new AttTlsWzgWvzCode("SMOG", 		Short
	.valueOf("68"));

	/**
	1006-32 ROLLSPLITT.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_69_ROLLSPLITT = new AttTlsWzgWvzCode("ROLLSPLITT", 		Short
	.valueOf("69"));

	/**
	MÄHARBEITEN.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_70_MAEHARBEITEN = new AttTlsWzgWvzCode("MÄHARBEITEN", 		Short
	.valueOf("70"));

	/**
	Ozon.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_71_OZON = new AttTlsWzgWvzCode("OZON", 		Short
	.valueOf("71"));

	/**
	Lärmschutz.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_72_LAERMSCHUTZ = new AttTlsWzgWvzCode("LÄRMSCHUTZ", 		Short
	.valueOf("72"));

	/**
	1004-34 600 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_74__600_M = new AttTlsWzgWvzCode("600 m", 		Short
	.valueOf("74"));

	/**
	1004-32 200 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_78__200_M = new AttTlsWzgWvzCode("200 m", 		Short
	.valueOf("78"));

	/**
	1004 300 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_79__300_M = new AttTlsWzgWvzCode("300 m", 		Short
	.valueOf("79"));

	/**
	1004-33 400 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_80__400_M = new AttTlsWzgWvzCode("400 m", 		Short
	.valueOf("80"));

	/**
	1004 500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_81__500_M = new AttTlsWzgWvzCode("500 m", 		Short
	.valueOf("81"));

	/**
	1004 1000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_82__1000_M = new AttTlsWzgWvzCode("1000 m", 		Short
	.valueOf("82"));

	/**
	1004 1500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_83__1500_M = new AttTlsWzgWvzCode("1500 m", 		Short
	.valueOf("83"));

	/**
	1004-35 2000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_84__2000_M = new AttTlsWzgWvzCode("2000 m", 		Short
	.valueOf("84"));

	/**
	1004 2500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_85__2500_M = new AttTlsWzgWvzCode("2500 m", 		Short
	.valueOf("85"));

	/**
	1004 3000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_86__3000_M = new AttTlsWzgWvzCode("3000 m", 		Short
	.valueOf("86"));

	/**
	1004 4000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_87__4000_M = new AttTlsWzgWvzCode("4000 m", 		Short
	.valueOf("87"));

	/**
	1004 5000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_88__5000_M = new AttTlsWzgWvzCode("5000 m", 		Short
	.valueOf("88"));

	/**
	1001-30 auf 500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_91_AUF_500_M = new AttTlsWzgWvzCode("auf 500 m", 		Short
	.valueOf("91"));

	/**
	1001-30 auf 1000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_92_AUF_1000_M = new AttTlsWzgWvzCode("auf 1000 m", 		Short
	.valueOf("92"));

	/**
	1001-30 auf 1500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_93_AUF_1500_M = new AttTlsWzgWvzCode("auf 1500 m", 		Short
	.valueOf("93"));

	/**
	1001-30 auf 2000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_94_AUF_2000_M = new AttTlsWzgWvzCode("auf 2000 m", 		Short
	.valueOf("94"));

	/**
	1001-30 auf 2500 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_95_AUF_2500_M = new AttTlsWzgWvzCode("auf 2500 m", 		Short
	.valueOf("95"));

	/**
	1001-30 auf 3000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_96_AUF_3000_M = new AttTlsWzgWvzCode("auf 3000 m", 		Short
	.valueOf("96"));

	/**
	1001-30 auf 4000 m.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_97_AUF_4000_M = new AttTlsWzgWvzCode("auf 4000 m", 		Short
	.valueOf("97"));

	/**
	101-30 auf 5 km.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_98_AUF_5_KM = new AttTlsWzgWvzCode("auf 5 km", 		Short
	.valueOf("98"));

	/**
	2,8 t.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_100__2_8_T = new AttTlsWzgWvzCode("2,8 t", 		Short
	.valueOf("100"));

	/**
	4 t.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_101__4_T = new AttTlsWzgWvzCode("4 t", 		Short
	.valueOf("101"));

	/**
	1052-35 7,5 t.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_102__7_5_T = new AttTlsWzgWvzCode("7,5 t", 		Short
	.valueOf("102"));

	/**
	1007-30 Gefahr unerwarteter Glatteisbildung.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_103_GLATTEISBILDUNG = new AttTlsWzgWvzCode("Glatteisbildung", 		Short
	.valueOf("103"));

	/**
	1048-12 nur Lkw (Piktogramm).
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_104_NUR_LKW_PIKTOGRAMM_ = new AttTlsWzgWvzCode("nur Lkw (Piktogramm)", 		Short
	.valueOf("104"));

	/**
	1048-10 nur Pkw (Piktogramm).
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_105_NUR_PKW_PIKTOGRAMM_ = new AttTlsWzgWvzCode("nur Pkw (Piktogramm)", 		Short
	.valueOf("105"));

	/**
	1006-38 Staugefahr (Piktogramm).
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_106_STAUGEFAHR_PIKTOGRAMM_ = new AttTlsWzgWvzCode("Staugefahr (Piktogramm)", 		Short
	.valueOf("106"));

	/**
	ROT.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_107_ROT = new AttTlsWzgWvzCode("ROT", 		Short
	.valueOf("107"));

	/**
	GELB.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_108_GELB = new AttTlsWzgWvzCode("GELB", 		Short
	.valueOf("108"));

	/**
	GRÜN.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_109_GRUEN = new AttTlsWzgWvzCode("GRÜN", 		Short
	.valueOf("109"));

	/**
	ROT&#47;GELB.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_110_ROT_GELB = new AttTlsWzgWvzCode("ROT/GELB", 		Short
	.valueOf("110"));

	/**
	Fahrstreifen gesperrt = diagonales Kreuz rot.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_111_ROTES_KREUZ = new AttTlsWzgWvzCode("rotes Kreuz", 		Short
	.valueOf("111"));

	/**
	Fahrstreifen halten = Pfeil nach unten grün.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_112_GRUENER_PFEIL_UNTEN = new AttTlsWzgWvzCode("grüner Pfeil unten", 		Short
	.valueOf("112"));

	/**
	Fahrstreifen wechseln = gelber Pfeil nach
								links unten.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_113_GELBER_PFEIL_LINKS = new AttTlsWzgWvzCode("gelber Pfeil links", 		Short
	.valueOf("113"));

	/**
	Fahrstreifen wechseln = gelber Pfeil nach
								rechts unten.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_114_GELBER_PFEIL_RECHTS = new AttTlsWzgWvzCode("gelber Pfeil rechts", 		Short
	.valueOf("114"));

	/**
	380 Richtgeschwindigkeit 30 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_121_RICHTGESCHWINDIGKEIT_30_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 30 km/h", 		Short
	.valueOf("121"));

	/**
	380 Richtgeschwindigkeit 40 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_122_RICHTGESCHWINDIGKEIT_40_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 40 km/h", 		Short
	.valueOf("122"));

	/**
	380 Richtgeschwindigkeit 50 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_123_RICHTGESCHWINDIGKEIT_50_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 50 km/h", 		Short
	.valueOf("123"));

	/**
	380 Richtgeschwindigkeit 60 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_124_RICHTGESCHWINDIGKEIT_60_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 60 km/h", 		Short
	.valueOf("124"));

	/**
	380 Richtgeschwindigkeit 70 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_125_RICHTGESCHWINDIGKEIT_70_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 70 km/h", 		Short
	.valueOf("125"));

	/**
	380-52 Richtgeschwindigkeit 80 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_126_RICHTGESCHWINDIGKEIT_80_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 80 km/h", 		Short
	.valueOf("126"));

	/**
	380 Richtgeschwindigkeit 90 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_127_RICHTGESCHWINDIGKEIT_90_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 90 km/h", 		Short
	.valueOf("127"));

	/**
	380-54 Richtgeschwindigkeit 100 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_128_RICHTGESCHWINDIGKEIT_100_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 100 km/h", 		Short
	.valueOf("128"));

	/**
	380 Richtgeschwindigkeit 110 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_129_RICHTGESCHWINDIGKEIT_110_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 110 km/h", 		Short
	.valueOf("129"));

	/**
	380 Richtgeschwindigkeit 120 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_130_RICHTGESCHWINDIGKEIT_120_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 120 km/h", 		Short
	.valueOf("130"));

	/**
	380 Richtgeschwindigkeit 130 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_131_RICHTGESCHWINDIGKEIT_130_KM_H = new AttTlsWzgWvzCode("Richtgeschwindigkeit 130 km/h", 		Short
	.valueOf("131"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 30
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_141_ENDE_RICHTGESCHWINDIGKEIT_30_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 30 km/h", 		Short
	.valueOf("141"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 40
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_142_ENDE_RICHTGESCHWINDIGKEIT_40_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 40 km/h", 		Short
	.valueOf("142"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 50
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_143_ENDE_RICHTGESCHWINDIGKEIT_50_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 50 km/h", 		Short
	.valueOf("143"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 60
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_144_ENDE_RICHTGESCHWINDIGKEIT_60_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 60 km/h", 		Short
	.valueOf("144"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 70
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_145_ENDE_RICHTGESCHWINDIGKEIT_70_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 70 km/h", 		Short
	.valueOf("145"));

	/**
	381-52 Aufhebung der Richtgeschwindigkeit 80
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_146_ENDE_RICHTGESCHWINDIGKEIT_80_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 80 km/h", 		Short
	.valueOf("146"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 90
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_147_ENDE_RICHTGESCHWINDIGKEIT_90_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 90 km/h", 		Short
	.valueOf("147"));

	/**
	381-54 Aufhebung der Richtgeschwindigkeit
								100 km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_148_ENDERICHTGESCHWINDIGKEIT_100_KM_H = new AttTlsWzgWvzCode("EndeRichtgeschwindigkeit 100 km/h", 		Short
	.valueOf("148"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 110
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_149_ENDE_RICHTGESCHWINDIGKEIT_110_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 110 km/h", 		Short
	.valueOf("149"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 120
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_150_ENDE_RICHTGESCHWINDIGKEIT_120_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 120 km/h", 		Short
	.valueOf("150"));

	/**
	381 Aufhebung der Richtgeschwindigkeit 130
								km&#47;h.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_151_ENDE_RICHTGESCHWINDIGKEIT_130_KM_H = new AttTlsWzgWvzCode("Ende Richtgeschwindigkeit 130 km/h", 		Short
	.valueOf("151"));

	/**
	Pfeil nach rechts.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_200_PFEIL_NACH_RECHTS = new AttTlsWzgWvzCode("Pfeil nach rechts", 		Short
	.valueOf("200"));

	/**
	anlagenspezifische WVZ-Codes 0.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_201_ANLAGENSPEZIFISCHE_WVZ_CODES_0 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 0", 		Short
	.valueOf("201"));

	/**
	anlagenspezifische WVZ-Codes 1.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_202_ANLAGENSPEZIFISCHE_WVZ_CODES_1 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 1", 		Short
	.valueOf("202"));

	/**
	anlagenspezifische WVZ-Codes 2.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_203_ANLAGENSPEZIFISCHE_WVZ_CODES_2 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 2", 		Short
	.valueOf("203"));

	/**
	anlagenspezifische WVZ-Codes 3.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_204_ANLAGENSPEZIFISCHE_WVZ_CODES_3 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 3", 		Short
	.valueOf("204"));

	/**
	anlagenspezifische WVZ-Codes 4.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_205_ANLAGENSPEZIFISCHE_WVZ_CODES_4 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 4", 		Short
	.valueOf("205"));

	/**
	anlagenspezifische WVZ-Codes 5.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_206_ANLAGENSPEZIFISCHE_WVZ_CODES_5 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 5", 		Short
	.valueOf("206"));

	/**
	anlagenspezifische WVZ-Codes 6.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_207_ANLAGENSPEZIFISCHE_WVZ_CODES_6 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 6", 		Short
	.valueOf("207"));

	/**
	anlagenspezifische WVZ-Codes 7.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_208_ANLAGENSPEZIFISCHE_WVZ_CODES_7 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 7", 		Short
	.valueOf("208"));

	/**
	anlagenspezifische WVZ-Codes 8.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_209_ANLAGENSPEZIFISCHE_WVZ_CODES_8 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 8", 		Short
	.valueOf("209"));

	/**
	anlagenspezifische WVZ-Codes 9.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_210_ANLAGENSPEZIFISCHE_WVZ_CODES_9 = new AttTlsWzgWvzCode("anlagenspezifische WVZ-Codes 9", 		Short
	.valueOf("210"));

	/**
	Prisma Seite 1.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_241_PRISMA_SEITE_1 = new AttTlsWzgWvzCode("Prisma Seite 1", 		Short
	.valueOf("241"));

	/**
	Prisma Seite 2.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_242_PRISMA_SEITE_2 = new AttTlsWzgWvzCode("Prisma Seite 2", 		Short
	.valueOf("242"));

	/**
	Prisma Seite 3.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_243_PRISMA_SEITE_3 = new AttTlsWzgWvzCode("Prisma Seite 3", 		Short
	.valueOf("243"));

	/**
	Prisma Seite 4.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_244_PRISMA_SEITE_4 = new AttTlsWzgWvzCode("Prisma Seite 4", 		Short
	.valueOf("244"));

	/**
	undefinierte Stellung (nur Meldung).
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_245_UNDEFINIERTE_STELLUNG = new AttTlsWzgWvzCode("undefinierte Stellung", 		Short
	.valueOf("245"));

	/**
	Wartungsstellung (Rollo geschlossen).
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_251_WARTUNGSSTELLUNG = new AttTlsWzgWvzCode("Wartungsstellung", 		Short
	.valueOf("251"));

	/**
	RESERVIERT.
	<p>
	
	</p>
	*/
	public static final AttTlsWzgWvzCode ZUSTAND_255_RESERVIERT = new AttTlsWzgWvzCode("RESERVIERT", 		Short
	.valueOf("255"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttTlsWzgWvzCode getZustand(final 		Short
	 value) {
		for (AttTlsWzgWvzCode e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttTlsWzgWvzCode getZustand(final String value) {
		for (AttTlsWzgWvzCode e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttTlsWzgWvzCode> getZustaende() {
		List<AttTlsWzgWvzCode> list = new ArrayList<AttTlsWzgWvzCode>();
		list.add(ZUSTAND_1N_AUS);
		list.add(ZUSTAND_1_GEFAHRENSTELLE);
		list.add(ZUSTAND_2_UNEBENE_FAHRBAHN);
		list.add(ZUSTAND_3_GLAETTEGEFAHR);
		list.add(ZUSTAND_4_SCHLEUDERGEFAHR);
		list.add(ZUSTAND_5_VERENGTE_FAHRBAHN);
		list.add(ZUSTAND_6_VERENGTE_FAHRBAHN_RECHTS);
		list.add(ZUSTAND_7_VERENGTE_FAHRBAHN_LINKS);
		list.add(ZUSTAND_8_BAUSTELLE);
		list.add(ZUSTAND_9_STAU);
		list.add(ZUSTAND_10_GEGENVERKEHR);
		list.add(ZUSTAND_11_SCHNEEFALL);
		list.add(ZUSTAND_12_LICHTZEICHENANLAGE);
		list.add(ZUSTAND_20__20_KM_H);
		list.add(ZUSTAND_21__30_KM_H);
		list.add(ZUSTAND_22__40_KM_H);
		list.add(ZUSTAND_23__50_KM_H);
		list.add(ZUSTAND_24__60_KM_H);
		list.add(ZUSTAND_25__70_KM_H);
		list.add(ZUSTAND_26__80_KM_H);
		list.add(ZUSTAND_27__90_KM_H);
		list.add(ZUSTAND_28__100_KM_H);
		list.add(ZUSTAND_29__110_KM_H);
		list.add(ZUSTAND_30__120_KM_H);
		list.add(ZUSTAND_31_UEBERHOLVERBOT_ALLE);
		list.add(ZUSTAND_32_UEBERHOLVERBOT_LKW);
		list.add(ZUSTAND_33__130_KM_H);
		list.add(ZUSTAND_38_VERKEHRSVERBOT_BEI_SMOG);
		list.add(ZUSTAND_39_VERBOT_FUER_FAHRZEUGE_ALLER_ART);
		list.add(ZUSTAND_40_ENDE_20_KM_H);
		list.add(ZUSTAND_41_ENDE_30_KM_H);
		list.add(ZUSTAND_42_ENDE_40_KM_H);
		list.add(ZUSTAND_43_ENDE_50_KM_H);
		list.add(ZUSTAND_44_ENDE_60_KM_H);
		list.add(ZUSTAND_45_ENDE_70_KM_H);
		list.add(ZUSTAND_46_ENDE_80_KM_H);
		list.add(ZUSTAND_47_ENDE_90_KM_H);
		list.add(ZUSTAND_48_ENDE_100_KM_H);
		list.add(ZUSTAND_49_ENDE_110_KM_H);
		list.add(ZUSTAND_50_ENDE_120_KM_H);
		list.add(ZUSTAND_51_ENDE_UEBERHOLVERBOT_ALLE);
		list.add(ZUSTAND_52_ENDE_UEBERHOLVERBOT_LKW);
		list.add(ZUSTAND_53_ENDE_SAEMTLICHER_STRECKENVERBOTE);
		list.add(ZUSTAND_54_ENDE_130_KM_H);
		list.add(ZUSTAND_61_GELBES_BLINKLICHT);
		list.add(ZUSTAND_62_STAU);
		list.add(ZUSTAND_63_STAUGEFAHR);
		list.add(ZUSTAND_64_NEBEL);
		list.add(ZUSTAND_65_NAESSE);
		list.add(ZUSTAND_66_UNFALL);
		list.add(ZUSTAND_67_SICHT);
		list.add(ZUSTAND_68_SMOG);
		list.add(ZUSTAND_69_ROLLSPLITT);
		list.add(ZUSTAND_70_MAEHARBEITEN);
		list.add(ZUSTAND_71_OZON);
		list.add(ZUSTAND_72_LAERMSCHUTZ);
		list.add(ZUSTAND_74__600_M);
		list.add(ZUSTAND_78__200_M);
		list.add(ZUSTAND_79__300_M);
		list.add(ZUSTAND_80__400_M);
		list.add(ZUSTAND_81__500_M);
		list.add(ZUSTAND_82__1000_M);
		list.add(ZUSTAND_83__1500_M);
		list.add(ZUSTAND_84__2000_M);
		list.add(ZUSTAND_85__2500_M);
		list.add(ZUSTAND_86__3000_M);
		list.add(ZUSTAND_87__4000_M);
		list.add(ZUSTAND_88__5000_M);
		list.add(ZUSTAND_91_AUF_500_M);
		list.add(ZUSTAND_92_AUF_1000_M);
		list.add(ZUSTAND_93_AUF_1500_M);
		list.add(ZUSTAND_94_AUF_2000_M);
		list.add(ZUSTAND_95_AUF_2500_M);
		list.add(ZUSTAND_96_AUF_3000_M);
		list.add(ZUSTAND_97_AUF_4000_M);
		list.add(ZUSTAND_98_AUF_5_KM);
		list.add(ZUSTAND_100__2_8_T);
		list.add(ZUSTAND_101__4_T);
		list.add(ZUSTAND_102__7_5_T);
		list.add(ZUSTAND_103_GLATTEISBILDUNG);
		list.add(ZUSTAND_104_NUR_LKW_PIKTOGRAMM_);
		list.add(ZUSTAND_105_NUR_PKW_PIKTOGRAMM_);
		list.add(ZUSTAND_106_STAUGEFAHR_PIKTOGRAMM_);
		list.add(ZUSTAND_107_ROT);
		list.add(ZUSTAND_108_GELB);
		list.add(ZUSTAND_109_GRUEN);
		list.add(ZUSTAND_110_ROT_GELB);
		list.add(ZUSTAND_111_ROTES_KREUZ);
		list.add(ZUSTAND_112_GRUENER_PFEIL_UNTEN);
		list.add(ZUSTAND_113_GELBER_PFEIL_LINKS);
		list.add(ZUSTAND_114_GELBER_PFEIL_RECHTS);
		list.add(ZUSTAND_121_RICHTGESCHWINDIGKEIT_30_KM_H);
		list.add(ZUSTAND_122_RICHTGESCHWINDIGKEIT_40_KM_H);
		list.add(ZUSTAND_123_RICHTGESCHWINDIGKEIT_50_KM_H);
		list.add(ZUSTAND_124_RICHTGESCHWINDIGKEIT_60_KM_H);
		list.add(ZUSTAND_125_RICHTGESCHWINDIGKEIT_70_KM_H);
		list.add(ZUSTAND_126_RICHTGESCHWINDIGKEIT_80_KM_H);
		list.add(ZUSTAND_127_RICHTGESCHWINDIGKEIT_90_KM_H);
		list.add(ZUSTAND_128_RICHTGESCHWINDIGKEIT_100_KM_H);
		list.add(ZUSTAND_129_RICHTGESCHWINDIGKEIT_110_KM_H);
		list.add(ZUSTAND_130_RICHTGESCHWINDIGKEIT_120_KM_H);
		list.add(ZUSTAND_131_RICHTGESCHWINDIGKEIT_130_KM_H);
		list.add(ZUSTAND_141_ENDE_RICHTGESCHWINDIGKEIT_30_KM_H);
		list.add(ZUSTAND_142_ENDE_RICHTGESCHWINDIGKEIT_40_KM_H);
		list.add(ZUSTAND_143_ENDE_RICHTGESCHWINDIGKEIT_50_KM_H);
		list.add(ZUSTAND_144_ENDE_RICHTGESCHWINDIGKEIT_60_KM_H);
		list.add(ZUSTAND_145_ENDE_RICHTGESCHWINDIGKEIT_70_KM_H);
		list.add(ZUSTAND_146_ENDE_RICHTGESCHWINDIGKEIT_80_KM_H);
		list.add(ZUSTAND_147_ENDE_RICHTGESCHWINDIGKEIT_90_KM_H);
		list.add(ZUSTAND_148_ENDERICHTGESCHWINDIGKEIT_100_KM_H);
		list.add(ZUSTAND_149_ENDE_RICHTGESCHWINDIGKEIT_110_KM_H);
		list.add(ZUSTAND_150_ENDE_RICHTGESCHWINDIGKEIT_120_KM_H);
		list.add(ZUSTAND_151_ENDE_RICHTGESCHWINDIGKEIT_130_KM_H);
		list.add(ZUSTAND_200_PFEIL_NACH_RECHTS);
		list.add(ZUSTAND_201_ANLAGENSPEZIFISCHE_WVZ_CODES_0);
		list.add(ZUSTAND_202_ANLAGENSPEZIFISCHE_WVZ_CODES_1);
		list.add(ZUSTAND_203_ANLAGENSPEZIFISCHE_WVZ_CODES_2);
		list.add(ZUSTAND_204_ANLAGENSPEZIFISCHE_WVZ_CODES_3);
		list.add(ZUSTAND_205_ANLAGENSPEZIFISCHE_WVZ_CODES_4);
		list.add(ZUSTAND_206_ANLAGENSPEZIFISCHE_WVZ_CODES_5);
		list.add(ZUSTAND_207_ANLAGENSPEZIFISCHE_WVZ_CODES_6);
		list.add(ZUSTAND_208_ANLAGENSPEZIFISCHE_WVZ_CODES_7);
		list.add(ZUSTAND_209_ANLAGENSPEZIFISCHE_WVZ_CODES_8);
		list.add(ZUSTAND_210_ANLAGENSPEZIFISCHE_WVZ_CODES_9);
		list.add(ZUSTAND_241_PRISMA_SEITE_1);
		list.add(ZUSTAND_242_PRISMA_SEITE_2);
		list.add(ZUSTAND_243_PRISMA_SEITE_3);
		list.add(ZUSTAND_244_PRISMA_SEITE_4);
		list.add(ZUSTAND_245_UNDEFINIERTE_STELLUNG);
		list.add(ZUSTAND_251_WARTUNGSSTELLUNG);
		list.add(ZUSTAND_255_RESERVIERT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut TLSWzgWvzCode.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttTlsWzgWvzCode(final 		Short
	 value) {
		super(value);
	}
	
	private AttTlsWzgWvzCode(final String zustand, final 		Short
	 value) {
		super(zustand, value);
	}
	
}
