/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Konfigurierende Eigenschaften der Objekte des Typs.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class KdDe extends AbstractKonfigurationsDatensatz<KdDe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _bezeichnung
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 _cluster
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _eAKanal
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _dEKanal
				;
				private String
				 _umsetzungsModul
				= new String
				()
				;
		
			/**
			Bezeichnung des DE (zu Dokumentationszwecken).
			<p>
			
			</p>
			
			@return der Wert von Bezeichnung.
			*/
				public String
				 getBezeichnung() {
				return _bezeichnung;
			}
		
			/**
			Bezeichnung des DE (zu Dokumentationszwecken).
			<p>
			
			</p>
			
			@param _bezeichnung der neue Wert von Bezeichnung.
			*/
			public void setBezeichnung(String
			 _bezeichnung) {
				if (_bezeichnung.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichnung = _bezeichnung;
			}
		
			/**
			Legt fest, ob es sich bei der DE um einen
									Clusterkanal handelt.
			<p>
			
			</p>
			
			@return der Wert von Cluster.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
				 getCluster() {
				return _cluster;
			}
		
			/**
			Legt fest, ob es sich bei der DE um einen
									Clusterkanal handelt.
			<p>
			
			</p>
			
			@param _cluster der neue Wert von Cluster.
			*/
			public void setCluster(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
			 _cluster) {
				this._cluster = _cluster;
			}
		
			/**
			Zugeordnete EA-Kanalnummer des DE am zugehörigen
									EAK.
			<p>
			
			</p>
			
			@return der Wert von EAKanal.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getEAKanal() {
				return _eAKanal;
			}
		
			/**
			Zugeordnete EA-Kanalnummer des DE am zugehörigen
									EAK.
			<p>
			
			</p>
			
			@param _eAKanal der neue Wert von EAKanal.
			*/
			public void setEAKanal(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _eAKanal) {
				this._eAKanal = _eAKanal;
			}
		
			/**
			DE-Nummer des Datenendgerätes.
			<p>
			
			</p>
			
			@return der Wert von DEKanal.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getDEKanal() {
				return _dEKanal;
			}
		
			/**
			DE-Nummer des Datenendgerätes.
			<p>
			
			</p>
			
			@param _dEKanal der neue Wert von DEKanal.
			*/
			public void setDEKanal(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _dEKanal) {
				this._dEKanal = _dEKanal;
			}
		
			/**
			Das für die Umsetzung des Protokolls (Lesen und
									Schreiben) verwendete Modul an diesem Knoten.
									Wird kein Modul angegeben, wird jeweils das
									Standardumsetzungmodul für diesen Objekttyp
									verwendet. Text ist der Klassennamen des
									UmsetzungsModuls.
			<p>
			
			</p>
			
			@return der Wert von UmsetzungsModul.
			*/
				public String
				 getUmsetzungsModul() {
				return _umsetzungsModul;
			}
		
			/**
			Das für die Umsetzung des Protokolls (Lesen und
									Schreiben) verwendete Modul an diesem Knoten.
									Wird kein Modul angegeben, wird jeweils das
									Standardumsetzungmodul für diesen Objekttyp
									verwendet. Text ist der Klassennamen des
									UmsetzungsModuls.
			<p>
			
			</p>
			
			@param _umsetzungsModul der neue Wert von UmsetzungsModul.
			*/
			public void setUmsetzungsModul(String
			 _umsetzungsModul) {
				if (_umsetzungsModul.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._umsetzungsModul = _umsetzungsModul;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getBezeichnung() != null) {
						datum.getTextValue("Bezeichnung").setText(getBezeichnung());
					}
					// GanzzahlAttributTyp
					if (getCluster() != null) {
		                if (getCluster().isZustand()) {
		                    datum.getUnscaledValue("Cluster").setText(getCluster().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Cluster").set(getCluster().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEAKanal() != null) {
		                if (getEAKanal().isZustand()) {
		                    datum.getUnscaledValue("EAKanal").setText(getEAKanal().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EAKanal").set(getEAKanal().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDEKanal() != null) {
		                if (getDEKanal().isZustand()) {
		                    datum.getUnscaledValue("DEKanal").setText(getDEKanal().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DEKanal").set(getDEKanal().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getUmsetzungsModul() != null) {
						datum.getTextValue("UmsetzungsModul").setText(getUmsetzungsModul());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setBezeichnung(daten.getTextValue("Bezeichnung").getText());
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Cluster").isState()) {
								setCluster(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
								.getZustand(daten.getScaledValue("Cluster").getText()));
							} else {
							setCluster(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttJaNein
							(daten.
								getUnscaledValue
							("Cluster").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setEAKanal(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("EAKanal").
									shortValue
							()));
					// GanzzahlAttributTyp
							setDEKanal(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("DEKanal").
									shortValue
							()));
					// ZeichenkettenAttributTyp
						setUmsetzungsModul(daten.getTextValue("UmsetzungsModul").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setBezeichnung(getBezeichnung());
							klon.setCluster(getCluster());
							klon.setEAKanal(getEAKanal());
							klon.setDEKanal(getDEKanal());
							klon.setUmsetzungsModul(getUmsetzungsModul());
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.de";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdDe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
