/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenendgerätekanal der Funktionsgruppe 1,
					LokaleVerkehrsErfassung.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface DeLve extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.De
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.deLve"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Parameter für Geschwindigkeitsklassen bei
						Kurzzeitdaten (FG 1 &#47; Typ 37).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 37"Parameter
								für Geschwindigkeitsklassen bei
								Kurzzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für die
								KlasseLkw-Ähnliche (LkwÄ-33).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Auf einen Abruf mit ID 19 (Abruf Parameter)
								antwortet die Streckenstationen mit 2
								DE-Blöcken Typ 37, je einem für
								?Pkw-Ähnliche? und für ?Lkw-Ähnliche?.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht übertragt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 4 benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe();
	
	/**
	SVE-Betriebsparameter(FG 1 &#47; Typ 34).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								34"SVE-Betriebsparameter"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt die
								herstellerunabhängigen Parameter, die für
								den Betrieb der SVE benötigt werden. Die
								Betriebsparameter gelten für die gesamte
								Richtungsfahrbahn.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsSveBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsSveBetriebsParameter getPdTlsSveBetriebsParameter();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Krad (Krad-10).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKrad();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte Betriebsmeldungen erzeugen und
						versenden.
	<p>
	
	</p>
	@return der Datensatz TlsBetriebsMeldungErzeugen.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen();
	
	/**
	Kfz-Einzeldaten (nur für Prüfzwecke) (FG 1 &#47; Typ
						63).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								63"Kfz-Einzeldaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur wird nur zu
								Prüfzwecken (s. Abschnitt IV) verwendet.
								Dieser DE-Block wird über eine
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Schnittstelle, die den Spezifikationen des
								Lokalbusses genügt, zur Verfügung gestellt.
								Wird verwendet mit ID 4 (Ergebnisse) in
								Antwortrichtung. Die Übertragung geschieht
								nur spontan nach Fahrzeugdetektion. Die
								Daten können nicht abgerufen werden. Dieser
								DE-Block muss mit Zeitstempel Typ 30
								gesendet werden.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveKfzEinzelDaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveKfzEinzelDaten getOdTlsLveKfzEinzelDaten();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Sattelkraftfahrzeuge
								(SattelKfz-9).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSattelKfz();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Lkw-Ähnliche (LkwÄ-33).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwAe();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Kurzzeitdaten (FG 1 &#47; Typ 37).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 37"Parameter
								für Geschwindigkeitsklassen bei
								Kurzzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für die Klasse
								Pkw-Ähnliche (PkwÄ-32) .
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Auf einen Abruf mit ID 19 (Abruf Parameter)
								antwortet die Streckenstationen mit 2
								DE-Blöcken Typ 37, je einem für
								?Pkw-Ähnliche? und für ?Lkw-Ähnliche?.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht übertragt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 4 benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenPkwAe();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz De.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz DeLve.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeLve getKdDeLve();
	
	/**
	Kanalsteuerung (FG alle &#47; Typ 29).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								29"Kanalsteuerung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Abruf- und Antwortrichtung oder mit ID 34
								(Statusnachricht aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der DE-Block"Kanalsteuerung" beeinflusst die
								Betriebsweise eines DEs. Bisher sind nur die
								beiden Betriebsweisen"Normalbetrieb"
								und"Passiv" vorgesehen. Über die
								Betriebsweise"Passiv" ist das Passivieren
								eines Kanals möglich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Funktion ist grundsätzlich für alle DEs
								vorgesehen, mit Ausnahme der Systemkanäle
								(FG 254). Sie dient insbesondere zum
								Abschalten von Kanälen, die Flattermeldungen
								produzieren oder aufgrund von Baustellen
								etc. nicht verwendet werden. Der
								Zustand"Passiv" muss spannungsausfallsicher
								abgelegt sein. Reaktionen eines passivierten
								Kanals (
								&lt;verweis pid="KanalsteuerungFG4" txt="Spezielles Verhalten in der FG4"&gt;&lt;&#47;verweis&gt;
	
								):
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende DE-Fehlermeldung (Typ
								1): keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- DE-Fehlermeldung (Typ 1) im
								Initialisierungsablauf normale Meldung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage DE-Fehlermeldungen (Typ 1):
								normale Antwort
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Fehlermeldung im Initialisierungsablauf
								(außer Typ 1) keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Fehlermeldung keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Fehlermeldungen (außer Typ 1)
								keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- spontan entstehende Anwenderdaten keine
								Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Anwenderdaten im Initialisierungsablauf 2
								keine Reaktion
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Abfrage Anwenderdaten keine Reaktion1
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Befehle Anwenderdaten2 keine Antwort,
								keine Ausführung3
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Statusnachricht Kanalsteuerung normale
								Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								- Zuweisung und Abfrage Parameterdaten
								normale Antwort und Ausführung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Einstellung des Kanalsteuerbytes erfolgt
								mit einem Kanalsteuerbefehl (ID 2, Typ 29),
								der mit Rückmeldung (ID 2, Typ 29)
								beantwortet wird. Die Meldung kann auch mit
								ID 18, Typ 29 abgefragt werden. Um die
								relevanten Kanalinformationen an einer
								Stelle zur Verfügung zu haben, wird das
								Passivierungsbit zusätzlich in der
								DE-Fehlermeldung übertragen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								&lt;wichtig&gt;
									&lt;anker pid="KanalsteuerungFG4"&gt;&lt;&#47;anker&gt;
	
									Spezielles Verhalten in der FG4
								&lt;&#47;wichtig&gt;
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Passivieren von DEs in der FG
								4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Der Wzg&#47;WWW wird ausgeschaltet oder das
								Rollo geschlossen. Bei Wzgs&#47;WWWs mit
								Prismentechnik wird, falls vorhanden, die
								Neutralstellung eingestellt. Die
								Stellzustandsänderung wird spontan zur UZ
								gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten von passivierten DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1. An passivierte DEs wird im Autarkbetrieb
								keine Grundeinstellung ausgegeben, d.h. sie
								bleiben im Zustand"Aus" oder"Rollo
								geschlossen".
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2. Befehle an passivierte Kanäle werden
								ausgeführt. Dadurch sind passive DEs
								schaltbar.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								3. Passivierte DEs senden immer ihre
								spontanen Meldungen, unabhängig vom
								Identifier und auch während der
								Initialisierung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Somit ist das Verhalten passiver und aktiver
								Kanäle - außer im Autarkbetrieb - gleich.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Verhalten beim Aktivieren von passivierten
								DEs in der FG 4:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Beim Aktivieren wird der Stellzustand des
								zugehörigen Wzgs&#47;WWWs vom EAK nicht
								verändert. Im Falle"Kommunikationsstatus
								lebt" werden DE-Fehlermeldung (Typ 1, ID 1)
								und bei"DE ok" abhängig von der Technologie
								der Zeichen nicht darstellbare WVZ (ID 1,
								Typ 2), defekte Lampen (ID 1, Typ 3) oder
								gestörte Textpositionen (ID 1, Typ 4) und
								der Stellzustand (ID 5, Typ 55, bei
								Altanlagen auch 48,50,58) gesendet. Im
								Falle"Kommunikationsstatus tot" wird die
								Grundeinstellung ausgegeben.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ansonsten gilt entsprechend die Definition
								in Anhang 6, Teil 2, Kapitel 3.2.5.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloKanalSteuerung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Pkw mit Anhänger (PkwA-2)
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwA();
	
	/**
	Parameter für Geschwindigkeitsklassen bei Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 38"Parameter für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung für Leichtverkehr ohne
								Anhänger (LVo-32).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Für welche und wieviele Fahrzeugklassen das Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese Nachricht überträgt die Konfiguration der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22, und 24 benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese DE-Block-Struktur ist optional.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBPA();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Pkw-Gruppe (PkwG -1).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwG();
	
	/**
	Lve-Betriebsparameter (FG 1 &#47; Typ 32).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								32"Lve-Betriebsparameter"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht überträgt Parameter, welcher
								für den Betrieb der Lve benötigt werden. Die
								Betriebsparameter werden i.d.R. für alle
								Kanäle einer Richtungsfahrbahn gemeinsam
								verändert.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveBetriebsParameter.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveBetriebsParameter getPdTlsLveBetriebsParameter();
	
	/**
	Abfragetelegramm für einen DE-Block.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockAbruf.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf();
	
	/**
	Positive Quittung (FG 1 &#47; Typ 28).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 28 "Positive Quittung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten) in Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die positive Quittung wird für den Abschluss
								von Transaktionen (z.B. Pufferabruf DE-Typ 20)
								verwendet, welche aus mehreren Telegrammen
								bestehen können und dessen Ende nicht genau
								vorhersehbar ist. Mit Hilfe der positiven
								Quittung wird ein erkennbares Ende der
								Transaktion gegeben und die noch offene
								Jobnummer quittiert.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLvePositiveQuittung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLvePositiveQuittung getOdTlsLvePositiveQuittung();
	
	/**
	Ermöglich das Senden eines (beliegigen) DE-Blocks.
	<p>
	
	</p>
	@return der Datensatz TlsGloDeBlockSenden.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Pkw (Pkw-7).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkw();
	
	/**
	DE-Fehler (FG alle &#47; Typ 1).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG alle (ausser FG 254): DE-Block-Struktur
								im Typ 1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Die
								Nachricht wird vom E&#47;AKonzentrator oder vom
								SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind ein oder mehrere Kanäle des
								E&#47;A-Konzentrators defekt, die Kommunikation
								des E&#47;A-Konzentrators ist jedoch noch
								funktionsfähig.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Bei Eintritt der Störung sendet der
								E&#47;A-Konzentrator eine Nachricht mit je einem
								DE-Block pro gestörtem Kanal und Fehlercode
								Bit 0 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit 0
								= 0, defekte Kanäle antworten mit Fehlercode
								Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert bei Eintritt der
								Störung anhand seiner Konfigurationsliste je
								eine Nachricht pro FG des E&#47;AKonzentrators
								mit je einem DE-Block pro vorhandenem DE und
								Fehlercode Bit 1 = 1. Auf Abfrage antworten
								betriebsbereite Kanäle mit Fehlercode Bit
								0..2 = 0, defekte Kanäle antworten mit
								Fehlercode Bit 1 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Ist ein Fehler aufgetreten, der weiterhin
								einen eingeschränkten Betrieb der DE
								zulässt, so ist dieser Teilausfall nicht
								durch ein gesetztes Fehlercode-Bit 0 oder 1
								auszudrücken.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Vielmehr ist dieser Ausfall durch die
								ergänzende DE-Fehlermeldung Typ 14 der
								Zentrale mitzuteilen. Abrufe der
								Fehlermeldung reicht der SM an den
								E&#47;A-Konzentrator weiter, wenn dieser mit dem
								SM kommunizieren kann, andernfalls
								beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Eine Kopie des Passiv-Bits, welches für
								jeden Kanal mit dem Kanalsteuerbefehl
								eingestellt werden kann, wird in der
								DE-Fehlermeldung mit übertragen. Dies
								erspart eine zusätzliche Abfrage bzw.
								Antwortnachricht des Kanalsteuerbytes, um
								den vollständigen Kanalzustand zu erfahren
								(Siehe auch Kapitel 3.2.5 Kanalsteuerung).
								Dieses Bit ist jedoch nur gültig, wenn die
								Fehlernachricht vom E&#47;A-Konzentrator erzeugt
								wird, jedoch nicht, wenn das Stö&#47;SM = 1 ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
						&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								1"DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die DE-Fehlermeldung informiert die Zentrale
								über den Betriebszustand eines DE. Sie wird
								sowohl für die anwendungsbezogenen DEs als
								auch für die hardwarezugeordneten DEs (DE
								entspricht E&#47;A-Konzentrator unter FG 254)
								verwendet. Das Störungsereignis wird der
								Zentrale primär über die anwendungsbezogenen
								DE-Fehlermeldungen (FG 1..253) mitgeteilt.
								Die Nachricht wird vom E&#47;A-Konzentrator oder
								vom SM erzeugt. Es sind folgende zwei Fälle
								unterscheidbar:
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								1.) Es sind Teile des E&#47;A-Konzentrators
								defekt, die Kommunikation zum SM ist jedoch
								noch funktionsfähig. Folge: Die
								Systemsteuerung des E&#47;A-Konzentrators sendet
								eine Nachricht mit ihrer DE-Nummer und
								Fehlercode Bit 0 = 1.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								2.) Der E&#47;A-Konzentrator ist so defekt, dass
								die Kommunikation zum SM nicht mehr
								funktioniert.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Folge: Der SM generiert eine Nachricht mit
								der DE des E&#47;A-Konzentrators und Fehlercode
								Bit 1 = 1. Abrufe der Fehlermeldung reicht
								der SM an den E&#47;A-Konzentrator weiter, wenn
								dieser mit dem SM kommunizieren kann,
								andernfalls beantwortet sie der SM selbst.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitergehende Informationen siehe [TLS2002].
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloDeFehler.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler();
	
	/**
	Legt fest, ob entsprechend implementierte Umsetzungsscripte der KExTLS ausgeführt werden
						oder nicht. Wird i.d.R. dazu verwendet, dass die Umsetzungscripte auf das logische Modell (FS,
						Umfelddaten) zu Testzwecken ausgeschaltet werden können.
	<p>
	
	</p>
	@return der Datensatz TlsPassivierungUebernahmeLogischesModell.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Lkw mit Anhänger (LkwA-8).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwA();
	
	/**
	Geographische Kenndaten (FG alle &#47; Typ 36).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 254: DE-Block-Struktur im Typ
								36"Geographische Kenndaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Meldung der geographischen Kenndaten
								dient dazu, die Lage der Streckenstation
								bzw. von Funktionsgruppen im Straßennetz
								durch Fernabruf überprüfbar zu machen. Dies
								kann insbesondere nach baulicher Änderung
								der Netzstruktur oder bei Inbetriebnahme von
								Zentralen hilfreich sein.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieses Datenfeld kann ein- oder mehrfach pro
								Streckenstation vorhanden sein. Es wird
								ausfallsicher gespeichert. Ist es nur einmal
								vorhanden, wird es über FG 254, DE 0 als
								Teil der Systemsteuerung im SM abgefragt.
								Dies ist der Standardfall. Optional kann das
								Datenfeld bei räumlich auseinanderliegenden
								Funktionsgruppen auch im EAK angelegt
								werden. Die Abfrage kann dann über einen
								beliebigen DE erfolgen. Eine weitere Option
								im EAK besteht darin, jedem DE ein
								unterschiedliches Datenfeld zuzuordnen, wenn
								dies für räumlich abgesetzte DEs
								erforderlich sein sollte.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die geographischen Kenndaten werden i.d.R.
								vor Ort eingegeben und von der Zentrale nur
								gelesen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsGloGeographischeKenndaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten();
	
	/**
	Ergänzende DE-Fehlermeldung (FG 1 &#47; Typ 14).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 14"Ergänzende
								DE-Fehlermeldung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 1 (Fehler) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieser DE-Block dient zur Meldung von
								Teilstörungen und näheren Erläuterung von
								Störungen, die mit dem DEBlock Typ 1
								gemeldet werden. Bei reinen Teilstörungen
								wird nur der DE-Block 14 gesendet; bei
								Erläuterungen von spontanen
								Störungsmeldungen wird er in einem Telegramm
								mit dem DE-Block Typ 1 gesendet. Er kann
								aber mit der ID 17 in Abrufrichtung einzeln
								abgerufen werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit dem DE-Block können unterschiedliche
								Störungen&#47;Teilstörungen gleichzeitig
								gemeldet werden. Ändert sich der Status
								(weitere Störungen bzw. Behebung von
								Störungen) wird ebenfalls DE-Block-Typ 14
								gesendet.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Weitergehende Informationen siehe [TLS2002].
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveErgaenzendeDeFehlerMeldung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgaenzendeDeFehlerMeldung getOdTlsLveErgaenzendeDeFehlerMeldung();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Lkw (Lkw-4).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkw();
	
	/**
	Negative Quittung (FG 1 &#47; Typ 16).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 16"Negative
								Quittung"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Statusnachrichten)
								in Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Mit der"Negativen Quittung" antwortet ein DE
								auf eine Nachricht, die an sie korrekt
								adressiert ist, aber deren Inhalt von ihr
								nicht eindeutig ausgewertet werden kann.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Negative Quittung wird mit ID 2 und Typ
								16 gesendet, enthält also keinen Hinweis auf
								die ID und den Typ der verursachenden
								Nachricht. Diese Zuordnung wird über die
								Jobnummer hergestellt, welche identisch mit
								der der fehlerhaften Nachricht in
								Abrufrichtung ist.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveNegativeQuittung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveNegativeQuittung getOdTlsLveNegativeQuittung();
	
	/**
	Abruf Pufferinhalt (FG 1 &#47; Typ 20).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 20"Abruf
								Pufferinhalt"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 2 (Abruf
								Statusnachrichten) in Abrufrichtung
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die Nachricht dient zum Abruf des Inhalts
								aus dem Langzeitdaten-Puffer. Über die
								Zeitangabe ist ein wahlfreier Zugriff auf
								alle im Puffer enthaltenen Datensätze
								möglich. Ist kein Datensatz mit genau der
								angeforderten Zeitangabe im Puffer
								vorhanden, wird stattdessen der
								nächstjüngere Datensatz übertragen. Ist der
								Puffer leer, wird mit einer negativen
								Quittung (FG1, Typ 16, ID2, Fehlercode 12)
								geantwortet. Der Puffer wird nur über die
								Sammeladresse angesprochen. Übertragen
								werden durch diesen Abruf immer alle
								Nachrichten, die zu einem Datensatz gehören,
								unabhängig von der Zahl der
								Einzeltelegramme.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveAbrufPufferInhalt.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveAbrufPufferInhalt getOdTlsLveAbrufPufferInhalt();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Lkw mit Anhänger und
								Sattelkraftfahrzeuge (LkwK-4).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLkwK();
	
	/**
	Parameter für Geschwindigkeitsklassen bei Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 38"Parameter für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung für Leichtverkehr ohne
								Anhänger (LVo-32).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Für welche und wieviele Fahrzeugklassen das Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese Nachricht überträgt die Konfiguration der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22, und 24 benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese DE-Block-Struktur ist optional.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLVo();
	
	/**
	Lve-ErgebnisMeldung Version 0-4 (FG 1 &#47; Typ
						49-53&#47;113-117).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: TLS-DE-Block-Struktur im Typ
								49-53&#47;113-117"Lve-ErgebnisMeldung Version
								0-4"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 4 (Ergebnisse) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveErgebnisMeldungVersion0Bis4.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion0Bis4 getOdTlsLveErgebnisMeldungVersion0Bis4();
	
	/**
	Parameter für Geschwindigkeitsklassen bei Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 38"Parameter für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;Wird verwendet mit ID 3 (Parameter) in Abruf- und Antwortrichtung für Leichtverkehr ohne
								Anhänger (LVo-32).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Für welche und wieviele Fahrzeugklassen das Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese Nachricht überträgt die Konfiguration der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22, und 24 benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Diese DE-Block-Struktur ist optional.&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenSGV();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Lieferwagen (Lfw-11).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenLfw();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Lve-ErgebnisMeldung Version 10-23 (FG 1 &#47; Typ
						65-78).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ
								65-78"Lve-ErgebnisMeldung Version 10-23"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 4 (Ergebnisse) und ID
								36 (ErgebnisMeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Dieser DE-Block ist nur für Langzeitdaten
								vorgesehen. Lassen sich z.B. aufgrund von
								Schleifendefekten einzelne Werte des Blockes
								nicht ermitteln, ohne dass jedoch ein
								Totalausfall des DE vorliegt, werden die
								betroffenen Bytes auf den Wert 255 gesetzt.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveErgebnisMeldungVersion10Bis23.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion10Bis23 getOdTlsLveErgebnisMeldungVersion10Bis23();
	
	/**
	Lve-ErgebnisMeldung Version 24 (FG 1 &#47; Typ 79).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;FG 1: DE-Block-Struktur im Typ 79 "Lve-ErgebnisMeldung Version 24"&lt;&#47;titel&gt;
							&lt;absatz&gt;Wird verwendet mit ID 4 (Ergebnisse) und ID 36 (ErgebnisMeldung aus Puffer) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;Dieser DE-Block ist nur für Langzeitdaten mit BASt Geschwindigkeitsdaten vorgesehen.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveErgebnisMeldungVersion24.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsLveErgebnisMeldungVersion24 getOdTlsLveErgebnisMeldungVersion24();
	
	/**
	SVE-ErgebnisMeldung Version 0-1 (FG 1 &#47; Typ 96-97).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								TLS-DE-Block-Struktur im Typ
								96-97"SVE-ErgebnisMeldung Version 0-1"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 4 (Ergebnisse) in
								Antwortrichtung.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Lassen sich einzelne Werte des Blockes nicht
								ermitteln ohne dass ein Totalausfall des DEs
								vorliegt, so werden die betroffenen
								Messwertbytes auf den Wert 255 gesetzt (z.B.
								aufgrund von Schleifendefekten oder
								verkehrsbedingt ).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Die ErgebnisMeldungen beziehen sich
								normalerweise auf eine Richtungsfahrbahn
								(Gesamtstrom). Fahrstreifenspezifische
								Ergebnisse sind optional möglich, die
								Unterscheidung kann durch Angabe des
								DE-Kanals erfolgen.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Da die SVE-Daten sich auf den Gesamtstrom
								einer Richtungsfahrbahn beziehen, sind für
								die DE-Codierung vorzugsweise die Werte
								7,15,... , die alle Fahrstreifen einer
								Fahrbahn bezeichnen, zu verwenden (siehe
								Anhang 7, Kapitel 5).
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsSveErgebnisMeldungVersion0Bis1.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsSveErgebnisMeldungVersion0Bis1 getOdTlsSveErgebnisMeldungVersion0Bis1();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Busse (Bus-5).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenBus();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Pkw-Ähnliche und Lkw-Ähnliche
								(alle Fahrzeuge, Kfz-64).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfz();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse nicht klassifizierbare Kfz
								(KfzNk-6).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenKfzNk();
	
	/**
	Enthält die Ermittlung der Fehlerursache in der TLS
						Kommunikation, die aufgrund von Messwertausfällen
						ermittelt wurden.
	<p>
	
	</p>
	@return der Datensatz TlsFehlerAnalyse.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse();
	
	/**
	Parameter für Geschwindigkeitsklassen bei
						Langzeitdaten (FG 1 &#47; Typ 38).
	<p>
	&lt;sektion&gt;
							&lt;titel&gt;
								FG 1: DE-Block-Struktur im Typ 38"Parameter
								für Geschwindigkeitsklassen bei
								Langzeitdaten"
							&lt;&#47;titel&gt;
							&lt;absatz&gt;
								Wird verwendet mit ID 3 (Parameter) in
								Abruf- und Antwortrichtung für
								Fahrzeugklasse Pkw-Ähnliche (PkwÄ-32).
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Für welche und wieviele Fahrzeugklassen das
								Gerät auf einen Abruf mit ID 19 (Abruf
								Parameter) antwortet, ist
								herstellerspezifisch verschieden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese Nachricht überträgt die Konfiguration
								der Geschwindigkeitsklassen, welche für den
								Betrieb der Datenversion 17, 18, 22 und 23
								benötigt werden.
							&lt;&#47;absatz&gt;
							&lt;absatz&gt;
								Diese DE-Block-Struktur ist optional.
							&lt;&#47;absatz&gt;
						&lt;&#47;sektion&gt;
	</p>
	@return der Datensatz TlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe getPdTlsLveParameterFuerGeschwindigkeitsKlassenBeiLangzeitDatenPkwAe();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
