/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Verkehrsinformationszentrale.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public interface Viz extends de.bsvrz.sys.funclib.bitctrl.modell.KonfigurationsObjekt
	,de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.Geraet
	
	
	
	{

	/** Die PID des Systemobjekttyps im Datenverteiler. */
	public static final String PID = "typ.viz"; 
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	
/**
Anschlusspunkte an einem Gerät.
<p>

</p>

@return die Menge AnschlussPunkteGeraet oder <code>null</code>, wenn eine optionale Menge nicht versorgt ist.
*/
	Collection<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.AnschlussPunkt> getAnschlussPunkteGeraet();


	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	Liste mit den Standard-UmsetzungsModulen für jeweils
						einen Objekttyp bei TLS ähnlichen
						Kommunikationspartnern.
	</p>
	@return der Datensatz GeraetTlsAehnlicheKommunikationsPartnerUmsetzungsModule.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdGeraetTlsAehnlicheKommunikationsPartnerUmsetzungsModule getKdGeraetTlsAehnlicheKommunikationsPartnerUmsetzungsModule();
	
	/**
	Attributgruppe zur Speicherung von Default-Parameterdatensätzen für alle Parameter-Attributgruppen eines Typs.
	<p>
	
	</p>
	@return der Datensatz DefaultParameterdatensaetze.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	Liste mit TLS ähnlichen Kommunikationspartnern und
						den Kommunikationsparametern.
	</p>
	@return der Datensatz GeraetTlsAehnlicheKommunikationsPartner.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdGeraetTlsAehnlicheKommunikationsPartner getKdGeraetTlsAehnlicheKommunikationsPartner();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	Liste mit den Pid von weiteren Geräten, für die die
						TLS-Applikation neben dem Startgerät zuständig ist
						(UZ, VRZ oder VIZ). Wird hier kein Eintrag gemacht,
						so sucht die TLS-Applikation vom Startgerät nur über
						direkt angeschlossene KRI oder Steuermodule nach EAK
						und De, für die sie dann verantwortlich ist,
						ansonsten wird auch bei den in dieser Liste
						aufgeführten Geräten weitergesucht (nach KRI oder SM
						oder Geräten, die in der Liste aufgeführt sind)..
	</p>
	@return der Datensatz GeraetZustaendigkeit.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdGeraetZustaendigkeit getKdGeraetZustaendigkeit();
	
	/**
	Attributgruppe zur Speicherung von beschreibenden Informationen zu einem Objekt.
	<p>
	
	</p>
	@return der Datensatz Info.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo();
	
	/**
	Verwaltet bis zu zehn alternative Bezeichnungen.
	<p>
	
	</p>
	@return der Datensatz AlternativeObjektbezeichnung.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung();
	
	/**
	Konfigurierende Eigenschaften der Objekte des Typs.
	<p>
	
	</p>
	@return der Datensatz Geraet.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdGeraet getKdGeraet();
	
	/**
	Koordinaten eines Punktes in Grad entsprechend WGS84.
	<p>
	
	</p>
	@return der Datensatz PunktKoordinaten.
	*/
	de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten();
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	 
}
