/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenendgerätekanal der Funktionsgruppe 3,
					UmFeldDaten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class DeUfdImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeUfd { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public DeUfdImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public DeUfdImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein DeUfd.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungLuftTemperaturLT getOdTlsUfdErgebnisMeldungLuftTemperaturLT() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungLuftTemperaturLT.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe1TT1 getOdTlsUfdErgebnisMeldungTemperaturInTiefe1TT1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe1TT1.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungBasisPegelLA95 getOdTlsUfdErgebnisMeldungBasisPegelLA95() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungBasisPegelLA95.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungABewerteterSchallDruckPegelLA getOdTlsUfdErgebnisMeldungABewerteterSchallDruckPegelLA() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungABewerteterSchallDruckPegelLA.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeUfd getKdDeUfd() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeUfd.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsUfdBetriebsParameter getPdTlsUfdBetriebsParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsUfdBetriebsParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsMengeNM getOdTlsUfdErgebnisMeldungNiederschlagsMengeNM() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsMengeNM.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnFeuchteFBF getOdTlsUfdErgebnisMeldungFahrbahnFeuchteFBF() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnFeuchteFBF.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnOberFlaechenTemperaturFBT getOdTlsUfdErgebnisMeldungFahrbahnOberFlaechenTemperaturFBT() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnOberFlaechenTemperaturFBT.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnGlaetteFBG getOdTlsUfdErgebnisMeldungFahrbahnGlaetteFBG() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnGlaetteFBG.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2 getOdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe2TT2.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe3TT3 getOdTlsUfdErgebnisMeldungTemperaturInTiefe3TT3() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTemperaturInTiefe3TT3.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaupunktTemperaturTPT getOdTlsUfdErgebnisMeldungTaupunktTemperaturTPT() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaupunktTemperaturTPT.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGefrierTemperaturGT getOdTlsUfdErgebnisMeldungGefrierTemperaturGT() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGefrierTemperaturGT.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgaenzendeDeFehlerMeldung getOdTlsUfdErgaenzendeDeFehlerMeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgaenzendeDeFehlerMeldung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdNegativeQuittung getOdTlsUfdNegativeQuittung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdNegativeQuittung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTyp35 getOdTlsUfdErgebnisMeldungTyp35() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTyp35.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnOberFlaeche getOdTlsUfdErgebnisMeldungFahrbahnOberFlaeche() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungFahrbahnOberFlaeche.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungRestSalzRS getOdTlsUfdErgebnisMeldungRestSalzRS() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungRestSalzRS.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsIntensitaetNI getOdTlsUfdErgebnisMeldungNiederschlagsIntensitaetNI() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsIntensitaetNI.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungLuftDruckLD getOdTlsUfdErgebnisMeldungLuftDruckLD() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungLuftDruckLD.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungRelativeLuftFeuchteRLF getOdTlsUfdErgebnisMeldungRelativeLuftFeuchteRLF() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungRelativeLuftFeuchteRLF.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindRichtungWR getOdTlsUfdErgebnisMeldungWindRichtungWR() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindRichtungWR.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindGeschwindigkeitMittelWertWGM getOdTlsUfdErgebnisMeldungWindGeschwindigkeitMittelWertWGM() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindGeschwindigkeitMittelWertWGM.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSchneeHoeheSH getOdTlsUfdErgebnisMeldungSchneeHoeheSH() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSchneeHoeheSH.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSichtWeiteSW getOdTlsUfdErgebnisMeldungSichtWeiteSW() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSichtWeiteSW.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungHelligkeitHK getOdTlsUfdErgebnisMeldungHelligkeitHK() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungHelligkeitHK.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlag getOdTlsUfdErgebnisMeldungNiederschlag() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlag.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindGeschwindigkeitSpitzenWertWGS getOdTlsUfdErgebnisMeldungWindGeschwindigkeitSpitzenWertWGS() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWindGeschwindigkeitSpitzenWertWGS.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSchneeFilmDickeSFD getOdTlsUfdErgebnisMeldungSchneeFilmDickeSFD() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungSchneeFilmDickeSFD.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheFBZ getOdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheFBZ() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheFBZ.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsArtNS getOdTlsUfdErgebnisMeldungNiederschlagsArtNS() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungNiederschlagsArtNS.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWasserFilmDickeWFD getOdTlsUfdErgebnisMeldungWasserFilmDickeWFD() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungWasserFilmDickeWFD.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZeitreserveGlaetteZG getOdTlsUfdErgebnisMeldungZeitreserveGlaetteZG() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZeitreserveGlaetteZG.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGlobalstrahlungGLS getOdTlsUfdErgebnisMeldungGlobalstrahlungGLS() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGlobalstrahlungGLS.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaustoffmengeTSQ getOdTlsUfdErgebnisMeldungTaustoffmengeTSQ() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaustoffmengeTSQ.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaustoffkonzentrationTSK getOdTlsUfdErgebnisMeldungTaustoffkonzentrationTSK() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungTaustoffkonzentrationTSK.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungEisFilmDickeEFD getOdTlsUfdErgebnisMeldungEisFilmDickeEFD() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungEisFilmDickeEFD.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheWinterdienstFZW getOdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheWinterdienstFZW() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungZustandDerFahrbahnOberFlaecheWinterdienstFZW.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungEnergieAequivalenterDauerSchallPegelLAeq getOdTlsUfdErgebnisMeldungEnergieAequivalenterDauerSchallPegelLAeq() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungEnergieAequivalenterDauerSchallPegelLAeq.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungStickoxideNOx getOdTlsUfdErgebnisMeldungStickoxideNOx() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungStickoxideNOx.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungMittlererSpitzenPegelLA1 getOdTlsUfdErgebnisMeldungMittlererSpitzenPegelLA1() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungMittlererSpitzenPegelLA1.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGriffigkeitGR getOdTlsUfdErgebnisMeldungGriffigkeitGR() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsUfdErgebnisMeldungGriffigkeitGR.class); 
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
