/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.impl;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Datenendgerätekanal der Funktionsgruppe 6, Netze der
					VerkehrLeitTechnit.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class DeVltImpl extends AbstractSystemObjekt
	implements de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.objekte.DeVlt { 

	/**
	 * Der Defaultkonstruktor wird für das Erzeugen des Systemobjekts über per
	 * Reflection-API benötigt.
	 */
	public DeVltImpl() {
		// tut nix
	}
	
	/**
	 * Initialisierung.
	 * 
	 * @param objekt
	 *            ein beliebiges Systemobjekt.
	 * @param factory
	 *            die Fabrik, die das Systemobjekt angelegt hat.
	 */
	public DeVltImpl(final SystemObject objekt, final ObjektFactory factory) {
		super(objekt, factory);
		
		if (!objekt.isOfType(getTyp().getPid())) {
			throw new IllegalArgumentException(
					"Systemobjekt ist kein DeVlt.");
		}
	}
	
	@Override
	protected String doGetTypPid() {
		return PID;
	}
	
	/*
	 * Beginn Abschnitt Mengen
	 */
	

	/*
	 * Ende Abschnitt Mengen
	 */

	/*
	 * Beginn Abschnitt Attributgruppen
	 */

	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen getPdTlsBetriebsMeldungErzeugen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsBetriebsMeldungErzeugen.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo getKdInfo() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdInfo.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltHeizung getOdTlsVltHeizung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltHeizung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe getKdDe() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDe.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung getPdTlsGloKanalSteuerung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsGloKanalSteuerung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeVlt getKdDeVlt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.konfigurationsdaten.KdDeVlt.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsVltBetriebsParameter getPdTlsVltBetriebsParameter() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsVltBetriebsParameter.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf getOdTlsGloDeBlockAbruf() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockAbruf.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden getOdTlsGloDeBlockSenden() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeBlockSenden.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler getOdTlsGloDeFehler() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloDeFehler.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell getPdTlsPassivierungUebernahmeLogischesModell() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter.PdTlsPassivierungUebernahmeLogischesModell.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltFernUeberwachungLokalerEnergieversorung getOdTlsVltFernUeberwachungLokalerEnergieversorung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltFernUeberwachungLokalerEnergieversorung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten getOdTlsGloGeographischeKenndaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsGloGeographischeKenndaten.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltErgaenzendeDeFehlerMeldung getOdTlsVltErgaenzendeDeFehlerMeldung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltErgaenzendeDeFehlerMeldung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltNegativeQuittung getOdTlsVltNegativeQuittung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltNegativeQuittung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltTuerKontakt getOdTlsVltTuerKontakt() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltTuerKontakt.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltTemperaturUeberwachung getOdTlsVltTemperaturUeberwachung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltTemperaturUeberwachung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze getKdDefaultParameterdatensaetze() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdDefaultParameterdatensaetze.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltLicht getOdTlsVltLicht() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltLicht.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltStromVersorung getOdTlsVltStromVersorung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltStromVersorung.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltUeberspannungsSchutz getOdTlsVltUeberspannungsSchutz() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltUeberspannungsSchutz.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltDiebstahlVandalismusSchutz getOdTlsVltDiebstahlVandalismusSchutz() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltDiebstahlVandalismusSchutz.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung getKdAlternativeObjektbezeichnung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.konfigurationsdaten.KdAlternativeObjektbezeichnung.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltFernUeberwachungSolarAnlagen getOdTlsVltFernUeberwachungSolarAnlagen() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltFernUeberwachungSolarAnlagen.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse getOdTlsFehlerAnalyse() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsFehlerAnalyse.class); 
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten getKdPunktKoordinaten() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmgeoreferenzierungglobal.konfigurationsdaten.KdPunktKoordinaten.class);
	}
	
	public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltLueftung getOdTlsVltLueftung() {
		return getDatensatz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten.OdTlsVltLueftung.class); 
	}
	
	
	/*
	 * Ende Abschnitt Attributgruppen
	 */
	
	// Sonderfall Klasse AttributImpl
	 

}
