/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
ErgebnisMeldung Achslastdaten Version 10 (FG 2 &#47; Typ
					65).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ
							65"ErgebnisMeldung Achslastdaten Version 10"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) und ID
							36 (ErgebnisMeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Lassen sich einzelne Werte des Blockes nicht
							ermitteln, ohne dass ein Totalausfall des
							DEs vorliegt, so werden die betroffenen
							Messwertbytes auf den Wert 255 (65535)
							gesetzt (z.B. aufgrund von Schleifendefekten
							oder verkehrsbedingt o.ä.).
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Achslastdaten werden für die
							Fahrzeugklassen 3 (Lkw), 4 (Lkw mit Anhänger
							und Sattelkraftfahrzeuge) und 5 (Busse)
							übertragen. Die Einteilung der Fahrzeuge in
							Klassen entspricht der in Anhang 2, Kapitel
							2.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsAxlErgebnisMeldungAchsLastDatenVersion10 extends AbstractOnlineDatensatz<OdTlsAxlErgebnisMeldungAchsLastDatenVersion10.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzEinzelachslastKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(13, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzDoppelachslastKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(10, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzDreifachachslastKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(11, true);
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 _anzUeberladungLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 _anzUeberladungLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 _anzUeberladungBusse
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzGewichtsKlasseLkw = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(10, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzGewichtsKlasseLkwA = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(10, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> _anzGewichtsKlasseBusse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				>(10, true);
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Anzahl der Achsen in der jeweiligen
									Gewichtsklasse.
			<p>
			
			</p>
			
			@return der Wert von AnzEinzelachslastKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzEinzelachslastKlasse() {
				return _anzEinzelachslastKlasse;
			}
		
		
			/**
			Anzahl der Achsen in der jeweiligen
									Gewichtsklasse.
			<p>
			
			</p>
			
			@return der Wert von AnzDoppelachslastKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzDoppelachslastKlasse() {
				return _anzDoppelachslastKlasse;
			}
		
		
			/**
			Anzahl der A chsen in der jeweiligen
									Gewichtsklasse.
			<p>
			
			</p>
			
			@return der Wert von AnzDreifachachslastKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzDreifachachslastKlasse() {
				return _anzDreifachachslastKlasse;
			}
		
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 3
									(Lkw).
			<p>
			
			</p>
			
			@return der Wert von AnzUeberladungLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 getAnzUeberladungLkw() {
				return _anzUeberladungLkw;
			}
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 3
									(Lkw).
			<p>
			
			</p>
			
			@param _anzUeberladungLkw der neue Wert von AnzUeberladungLkw.
			*/
			public void setAnzUeberladungLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
			 _anzUeberladungLkw) {
				this._anzUeberladungLkw = _anzUeberladungLkw;
			}
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 4 (Lkw
									mit Anhänger und Sattelkraftfahrzeuge).
			<p>
			
			</p>
			
			@return der Wert von AnzUeberladungLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 getAnzUeberladungLkwA() {
				return _anzUeberladungLkwA;
			}
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 4 (Lkw
									mit Anhänger und Sattelkraftfahrzeuge).
			<p>
			
			</p>
			
			@param _anzUeberladungLkwA der neue Wert von AnzUeberladungLkwA.
			*/
			public void setAnzUeberladungLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
			 _anzUeberladungLkwA) {
				this._anzUeberladungLkwA = _anzUeberladungLkwA;
			}
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 5
									(Busse).
			<p>
			
			</p>
			
			@return der Wert von AnzUeberladungBusse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
				 getAnzUeberladungBusse() {
				return _anzUeberladungBusse;
			}
		
			/**
			Anzahl der Überladungen in Fahrzeugklasse 5
									(Busse).
			<p>
			
			</p>
			
			@param _anzUeberladungBusse der neue Wert von AnzUeberladungBusse.
			*/
			public void setAnzUeberladungBusse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
			 _anzUeberladungBusse) {
				this._anzUeberladungBusse = _anzUeberladungBusse;
			}
		
			/**
			Anzahl der Fahrzeuge in der jeweiligen
									Gewichtsklasse in Fahrzeugklasse 3 (Lkw).
			<p>
			
			</p>
			
			@return der Wert von AnzGewichtsKlasseLkw.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzGewichtsKlasseLkw() {
				return _anzGewichtsKlasseLkw;
			}
		
		
			/**
			Anzahl der Fahrzeuge in der jeweiligen
									Gewichtsklasse in Fahrzeugklasse 4 (Lkw mit
									Anhänger und Sattelkraftfahrzeuge).
			<p>
			
			</p>
			
			@return der Wert von AnzGewichtsKlasseLkwA.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzGewichtsKlasseLkwA() {
				return _anzGewichtsKlasseLkwA;
			}
		
		
			/**
			Anzahl der Fahrzeuge in der jeweiligen
									Gewichtsklassein Fahrzeugklasse 5 (Busse).
			<p>
			
			</p>
			
			@return der Wert von AnzGewichtsKlasseBusse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
				> getAnzGewichtsKlasseBusse() {
				return _anzGewichtsKlasseBusse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getAnzEinzelachslastKlasse() != null) {
						final Data.NumberArray arrayAnzEinzelachslastKlasse = datum.
							getUnscaledArray
							("AnzEinzelachslastKlasse");
						arrayAnzEinzelachslastKlasse.setLength(getAnzEinzelachslastKlasse().size());
						for (int i = 0; i < arrayAnzEinzelachslastKlasse.getLength(); ++i) {
							arrayAnzEinzelachslastKlasse.getValue(i).set(getAnzEinzelachslastKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getAnzDoppelachslastKlasse() != null) {
						final Data.NumberArray arrayAnzDoppelachslastKlasse = datum.
							getUnscaledArray
							("AnzDoppelachslastKlasse");
						arrayAnzDoppelachslastKlasse.setLength(getAnzDoppelachslastKlasse().size());
						for (int i = 0; i < arrayAnzDoppelachslastKlasse.getLength(); ++i) {
							arrayAnzDoppelachslastKlasse.getValue(i).set(getAnzDoppelachslastKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getAnzDreifachachslastKlasse() != null) {
						final Data.NumberArray arrayAnzDreifachachslastKlasse = datum.
							getUnscaledArray
							("AnzDreifachachslastKlasse");
						arrayAnzDreifachachslastKlasse.setLength(getAnzDreifachachslastKlasse().size());
						for (int i = 0; i < arrayAnzDreifachachslastKlasse.getLength(); ++i) {
							arrayAnzDreifachachslastKlasse.getValue(i).set(getAnzDreifachachslastKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getAnzUeberladungLkw() != null) {
		                if (getAnzUeberladungLkw().isZustand()) {
		                    datum.getUnscaledValue("AnzÜberladungLkw").setText(getAnzUeberladungLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzÜberladungLkw").set(getAnzUeberladungLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzUeberladungLkwA() != null) {
		                if (getAnzUeberladungLkwA().isZustand()) {
		                    datum.getUnscaledValue("AnzÜberladungLkwA").setText(getAnzUeberladungLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzÜberladungLkwA").set(getAnzUeberladungLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzUeberladungBusse() != null) {
		                if (getAnzUeberladungBusse().isZustand()) {
		                    datum.getUnscaledValue("AnzÜberladungBusse").setText(getAnzUeberladungBusse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzÜberladungBusse").set(getAnzUeberladungBusse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzGewichtsKlasseLkw() != null) {
						final Data.NumberArray arrayAnzGewichtsKlasseLkw = datum.
							getUnscaledArray
							("AnzGewichtsKlasseLkw");
						arrayAnzGewichtsKlasseLkw.setLength(getAnzGewichtsKlasseLkw().size());
						for (int i = 0; i < arrayAnzGewichtsKlasseLkw.getLength(); ++i) {
							arrayAnzGewichtsKlasseLkw.getValue(i).set(getAnzGewichtsKlasseLkw().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getAnzGewichtsKlasseLkwA() != null) {
						final Data.NumberArray arrayAnzGewichtsKlasseLkwA = datum.
							getUnscaledArray
							("AnzGewichtsKlasseLkwA");
						arrayAnzGewichtsKlasseLkwA.setLength(getAnzGewichtsKlasseLkwA().size());
						for (int i = 0; i < arrayAnzGewichtsKlasseLkwA.getLength(); ++i) {
							arrayAnzGewichtsKlasseLkwA.getValue(i).set(getAnzGewichtsKlasseLkwA().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getAnzGewichtsKlasseBusse() != null) {
						final Data.NumberArray arrayAnzGewichtsKlasseBusse = datum.
							getUnscaledArray
							("AnzGewichtsKlasseBusse");
						arrayAnzGewichtsKlasseBusse.setLength(getAnzGewichtsKlasseBusse().size());
						for (int i = 0; i < arrayAnzGewichtsKlasseBusse.getLength(); ++i) {
							arrayAnzGewichtsKlasseBusse.getValue(i).set(getAnzGewichtsKlasseBusse().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzEinzelachslastKlasse = daten.
							getUnscaledArray
						("AnzEinzelachslastKlasse");
		
						for (int i = 0; i < arrayAnzEinzelachslastKlasse.getLength(); ++i) {
		                    if (arrayAnzEinzelachslastKlasse.getValue(i).isState()) {
		                        getAnzEinzelachslastKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzEinzelachslastKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getAnzEinzelachslastKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzEinzelachslastKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzDoppelachslastKlasse = daten.
							getUnscaledArray
						("AnzDoppelachslastKlasse");
		
						for (int i = 0; i < arrayAnzDoppelachslastKlasse.getLength(); ++i) {
		                    if (arrayAnzDoppelachslastKlasse.getValue(i).isState()) {
		                        getAnzDoppelachslastKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzDoppelachslastKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getAnzDoppelachslastKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzDoppelachslastKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzDreifachachslastKlasse = daten.
							getUnscaledArray
						("AnzDreifachachslastKlasse");
		
						for (int i = 0; i < arrayAnzDreifachachslastKlasse.getLength(); ++i) {
		                    if (arrayAnzDreifachachslastKlasse.getValue(i).isState()) {
		                        getAnzDreifachachslastKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzDreifachachslastKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getAnzDreifachachslastKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzDreifachachslastKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzÜberladungLkw").isState()) {
								setAnzUeberladungLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
								.getZustand(daten.getScaledValue("AnzÜberladungLkw").getText()));
							} else {
							setAnzUeberladungLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
							(daten.
								getUnscaledValue
							("AnzÜberladungLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzÜberladungLkwA").isState()) {
								setAnzUeberladungLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
								.getZustand(daten.getScaledValue("AnzÜberladungLkwA").getText()));
							} else {
							setAnzUeberladungLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
							(daten.
								getUnscaledValue
							("AnzÜberladungLkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzÜberladungBusse").isState()) {
								setAnzUeberladungBusse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
								.getZustand(daten.getScaledValue("AnzÜberladungBusse").getText()));
							} else {
							setAnzUeberladungBusse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertKurz
							(daten.
								getUnscaledValue
							("AnzÜberladungBusse").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzGewichtsKlasseLkw = daten.
							getUnscaledArray
						("AnzGewichtsKlasseLkw");
		
						for (int i = 0; i < arrayAnzGewichtsKlasseLkw.getLength(); ++i) {
		                    if (arrayAnzGewichtsKlasseLkw.getValue(i).isState()) {
		                        getAnzGewichtsKlasseLkw().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzGewichtsKlasseLkw.getValue(i).getState().getName()));
		                    } else {
		                    getAnzGewichtsKlasseLkw().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzGewichtsKlasseLkw.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzGewichtsKlasseLkwA = daten.
							getUnscaledArray
						("AnzGewichtsKlasseLkwA");
		
						for (int i = 0; i < arrayAnzGewichtsKlasseLkwA.getLength(); ++i) {
		                    if (arrayAnzGewichtsKlasseLkwA.getValue(i).isState()) {
		                        getAnzGewichtsKlasseLkwA().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzGewichtsKlasseLkwA.getValue(i).getState().getName()));
		                    } else {
		                    getAnzGewichtsKlasseLkwA().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzGewichtsKlasseLkwA.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayAnzGewichtsKlasseBusse = daten.
							getUnscaledArray
						("AnzGewichtsKlasseBusse");
		
						for (int i = 0; i < arrayAnzGewichtsKlasseBusse.getLength(); ++i) {
		                    if (arrayAnzGewichtsKlasseBusse.getValue(i).isState()) {
		                        getAnzGewichtsKlasseBusse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                        .getZustand(arrayAnzGewichtsKlasseBusse.getValue(i).getState().getName()));
		                    } else {
		                    getAnzGewichtsKlasseBusse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWertLang
		                    (arrayAnzGewichtsKlasseBusse.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
						klon._anzEinzelachslastKlasse = getAnzEinzelachslastKlasse().clone();
						klon._anzDoppelachslastKlasse = getAnzDoppelachslastKlasse().clone();
						klon._anzDreifachachslastKlasse = getAnzDreifachachslastKlasse().clone();
							klon.setAnzUeberladungLkw(getAnzUeberladungLkw());
							klon.setAnzUeberladungLkwA(getAnzUeberladungLkwA());
							klon.setAnzUeberladungBusse(getAnzUeberladungBusse());
						klon._anzGewichtsKlasseLkw = getAnzGewichtsKlasseLkw().clone();
						klon._anzGewichtsKlasseLkwA = getAnzGewichtsKlasseLkwA().clone();
						klon._anzGewichtsKlasseBusse = getAnzGewichtsKlasseBusse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlErgebnisMeldungAchsLastDatenVersion10";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsAxlErgebnisMeldungAchsLastDatenVersion10(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
