/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Negative Quittung (FG 2 &#47; Typ 16).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ 16"Negative
							Quittung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 2 (Statusnachrichten)
							in Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit der"Negativen Quittung" antwortet ein DE
							auf eine Nachricht, die an sie korrekt
							adressiert ist, aber deren Inhalt von ihr
							nicht eindeutig ausgewertet werden kann.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Negative Quittung wird mit ID 2 und Typ
							16 gesendet, enthält also keinen Hinweis auf
							die ID und den Typ der verursachenden
							Nachricht. Diese Zuordnung wird über die
							Jobnummer hergestellt, welche identisch mit
							der der fehlerhaften Nachricht in
							Abrufrichtung ist.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsAxlNegativeQuittung extends AbstractOnlineDatensatz<OdTlsAxlNegativeQuittung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlNegativeQuittung
				 _code
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
				private String
				 _einzelTelegramm
				= new String
				()
				;
		
			/**
			Anwort auf eine nicht auswertbares Telegramm.
			<p>
			
			</p>
			
			@return der Wert von Code.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlNegativeQuittung
				 getCode() {
				return _code;
			}
		
			/**
			Anwort auf eine nicht auswertbares Telegramm.
			<p>
			
			</p>
			
			@param _code der neue Wert von Code.
			*/
			public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlNegativeQuittung
			 _code) {
				this._code = _code;
			}
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Daten des Einzeltelegramms, dass die negative
									Quittung auslöste.
			<p>
			
			</p>
			
			@return der Wert von EinzelTelegramm.
			*/
				public String
				 getEinzelTelegramm() {
				return _einzelTelegramm;
			}
		
			/**
			Daten des Einzeltelegramms, dass die negative
									Quittung auslöste.
			<p>
			
			</p>
			
			@param _einzelTelegramm der neue Wert von EinzelTelegramm.
			*/
			public void setEinzelTelegramm(String
			 _einzelTelegramm) {
				if (_einzelTelegramm.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._einzelTelegramm = _einzelTelegramm;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getCode() != null) {
		                if (getCode().isZustand()) {
		                    datum.getUnscaledValue("Code").setText(getCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Code").set(getCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getEinzelTelegramm() != null) {
						datum.getTextValue("EinzelTelegramm").setText(getEinzelTelegramm());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Code").isState()) {
								setCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlNegativeQuittung
								.getZustand(daten.getScaledValue("Code").getText()));
							} else {
							setCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlNegativeQuittung
							(daten.
								getUnscaledValue
							("Code").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
					// ZeichenkettenAttributTyp
						setEinzelTelegramm(daten.getTextValue("EinzelTelegramm").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setCode(getCode());
							klon.setHersteller(getHersteller());
							klon.setEinzelTelegramm(getEinzelTelegramm());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlNegativeQuittung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsAxlNegativeQuittung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
