/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Geographische Kenndaten (FG alle &#47; Typ 36).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 254: DE-Block-Struktur im Typ
							36"Geographische Kenndaten"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Meldung der geographischen Kenndaten
							dient dazu, die Lage der Streckenstation
							bzw. von Funktionsgruppen im Straßennetz
							durch Fernabruf überprüfbar zu machen. Dies
							kann insbesondere nach baulicher Änderung
							der Netzstruktur oder bei Inbetriebnahme von
							Zentralen hilfreich sein.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Dieses Datenfeld kann ein- oder mehrfach pro
							Streckenstation vorhanden sein. Es wird
							ausfallsicher gespeichert. Ist es nur einmal
							vorhanden, wird es über FG 254, DE 0 als
							Teil der Systemsteuerung im SM abgefragt.
							Dies ist der Standardfall. Optional kann das
							Datenfeld bei räumlich auseinanderliegenden
							Funktionsgruppen auch im EAK angelegt
							werden. Die Abfrage kann dann über einen
							beliebigen DE erfolgen. Eine weitere Option
							im EAK besteht darin, jedem DE ein
							unterschiedliches Datenfeld zuzuordnen, wenn
							dies für räumlich abgesetzte DEs
							erforderlich sein sollte.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die geographischen Kenndaten werden i.d.R.
							vor Ort eingegeben und von der Zentrale nur
							gelesen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsGloGeographischeKenndaten extends AbstractOnlineDatensatz<OdTlsGloGeographischeKenndaten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabeArchiv,
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.tlsVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsVorgabeArchiv");
			
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLandeskennung
				 _landesKennung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassenart
				 _strassenArt
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassennummer
				 _strassenNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsKilometrierung
				 _kilometrierung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrtrichtung
				 _fahrtrichtung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 _reserveByte
				;
		
			/**
			Straßenart (BAB, Landstraße, ...).
			<p>
			
			</p>
			
			@return der Wert von LandesKennung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLandeskennung
				 getLandesKennung() {
				return _landesKennung;
			}
		
			/**
			Straßenart (BAB, Landstraße, ...).
			<p>
			
			</p>
			
			@param _landesKennung der neue Wert von LandesKennung.
			*/
			public void setLandesKennung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLandeskennung
			 _landesKennung) {
				this._landesKennung = _landesKennung;
			}
		
			/**
			Kennung des Bundeslandes.
			<p>
			
			</p>
			
			@return der Wert von StrassenArt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassenart
				 getStrassenArt() {
				return _strassenArt;
			}
		
			/**
			Kennung des Bundeslandes.
			<p>
			
			</p>
			
			@param _strassenArt der neue Wert von StrassenArt.
			*/
			public void setStrassenArt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassenart
			 _strassenArt) {
				this._strassenArt = _strassenArt;
			}
		
			/**
			Straßennummer (0...9999).
			<p>
			
			</p>
			
			@return der Wert von StrassenNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassennummer
				 getStrassenNummer() {
				return _strassenNummer;
			}
		
			/**
			Straßennummer (0...9999).
			<p>
			
			</p>
			
			@param _strassenNummer der neue Wert von StrassenNummer.
			*/
			public void setStrassenNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassennummer
			 _strassenNummer) {
				this._strassenNummer = _strassenNummer;
			}
		
			/**
			Kilometrierung des Querschnittes 0,00 bis 9999,99
								km.
			<p>
			
			</p>
			
			@return der Wert von Kilometrierung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsKilometrierung
				 getKilometrierung() {
				return _kilometrierung;
			}
		
			/**
			Kilometrierung des Querschnittes 0,00 bis 9999,99
								km.
			<p>
			
			</p>
			
			@param _kilometrierung der neue Wert von Kilometrierung.
			*/
			public void setKilometrierung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsKilometrierung
			 _kilometrierung) {
				this._kilometrierung = _kilometrierung;
			}
		
			/**
			Fahrtrichtung (Nord&#47;Ost und&#47;oder Süd&#47;West.
			<p>
			In Streckenstationen, bzw. FGs, die beide
								Fahrtrichtungen betreffen, sind beide Richungen
								gleichzeitig gesetzt. Streckenstationen, bzw. FGs,
								die keine fahrbahnbezogenen Geräte enthalten, setzen
								keine Richtung. Für die Fahrtrichtung ist die
								Ausrichtung der gesamten Straße zwischen ihren
								Endpunkten entscheidend, nicht die Lage der Fahrbahn
								am betrachteten Querschnitt.
			</p>
			
			@return der Wert von Fahrtrichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrtrichtung
				 getFahrtrichtung() {
				return _fahrtrichtung;
			}
		
			/**
			Fahrtrichtung (Nord&#47;Ost und&#47;oder Süd&#47;West.
			<p>
			In Streckenstationen, bzw. FGs, die beide
								Fahrtrichtungen betreffen, sind beide Richungen
								gleichzeitig gesetzt. Streckenstationen, bzw. FGs,
								die keine fahrbahnbezogenen Geräte enthalten, setzen
								keine Richtung. Für die Fahrtrichtung ist die
								Ausrichtung der gesamten Straße zwischen ihren
								Endpunkten entscheidend, nicht die Lage der Fahrbahn
								am betrachteten Querschnitt.
			</p>
			
			@param _fahrtrichtung der neue Wert von Fahrtrichtung.
			*/
			public void setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrtrichtung
			 _fahrtrichtung) {
				this._fahrtrichtung = _fahrtrichtung;
			}
		
			/**
			Diese Bytes, die man sich besser gespart
									hätte...
			<p>
			
			</p>
			
			@return der Wert von ReserveByte.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
				 getReserveByte() {
				return _reserveByte;
			}
		
			/**
			Diese Bytes, die man sich besser gespart
									hätte...
			<p>
			
			</p>
			
			@param _reserveByte der neue Wert von ReserveByte.
			*/
			public void setReserveByte(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
			 _reserveByte) {
				this._reserveByte = _reserveByte;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getLandesKennung() != null) {
		                if (getLandesKennung().isZustand()) {
		                    datum.getUnscaledValue("LandesKennung").setText(getLandesKennung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LandesKennung").set(getLandesKennung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStrassenArt() != null) {
		                if (getStrassenArt().isZustand()) {
		                    datum.getUnscaledValue("StraßenArt").setText(getStrassenArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StraßenArt").set(getStrassenArt().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStrassenNummer() != null) {
		                if (getStrassenNummer().isZustand()) {
		                    datum.getUnscaledValue("StraßenNummer").setText(getStrassenNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StraßenNummer").set(getStrassenNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKilometrierung() != null) {
		                if (getKilometrierung().isZustand()) {
		                    datum.getUnscaledValue("Kilometrierung").setText(getKilometrierung().toString());
		                } else {
							datum.
							getScaledValue
		                	("Kilometrierung").set(getKilometrierung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getFahrtrichtung() != null) {
		                if (getFahrtrichtung().isZustand()) {
		                    datum.getUnscaledValue("Fahrtrichtung").setText(getFahrtrichtung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Fahrtrichtung").set(getFahrtrichtung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getReserveByte() != null) {
		                if (getReserveByte().isZustand()) {
		                    datum.getUnscaledValue("ReserveByte").setText(getReserveByte().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ReserveByte").set(getReserveByte().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LandesKennung").isState()) {
								setLandesKennung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLandeskennung
								.getZustand(daten.getScaledValue("LandesKennung").getText()));
							} else {
							setLandesKennung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLandeskennung
							(daten.
								getUnscaledValue
							("LandesKennung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StraßenArt").isState()) {
								setStrassenArt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassenart
								.getZustand(daten.getScaledValue("StraßenArt").getText()));
							} else {
							setStrassenArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassenart
							(daten.
								getUnscaledValue
							("StraßenArt").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setStrassenNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsStrassennummer
							(daten.
								getUnscaledValue
							("StraßenNummer").
									shortValue
							()));
					// GanzzahlAttributTyp
							setKilometrierung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsKilometrierung
							(daten.
								getScaledValue
							("Kilometrierung").
								doubleValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Fahrtrichtung").isState()) {
								setFahrtrichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrtrichtung
								.getZustand(daten.getScaledValue("Fahrtrichtung").getText()));
							} else {
							setFahrtrichtung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsFahrtrichtung
							(daten.
								getUnscaledValue
							("Fahrtrichtung").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setReserveByte(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsByte
							(daten.
								getUnscaledValue
							("ReserveByte").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setLandesKennung(getLandesKennung());
							klon.setStrassenArt(getStrassenArt());
							klon.setStrassenNummer(getStrassenNummer());
							klon.setKilometrierung(getKilometrierung());
							klon.setFahrtrichtung(getFahrtrichtung());
							klon.setReserveByte(getReserveByte());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsGloGeographischeKenndaten";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsGloGeographischeKenndaten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
