/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lve-ErgebnisMeldung Version 10-23 (FG 1 &#47; Typ
					65-78).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 1: DE-Block-Struktur im Typ
							65-78"Lve-ErgebnisMeldung Version 10-23"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) und ID
							36 (ErgebnisMeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Dieser DE-Block ist nur für Langzeitdaten
							vorgesehen. Lassen sich z.B. aufgrund von
							Schleifendefekten einzelne Werte des Blockes
							nicht ermitteln, ohne dass jedoch ein
							Totalausfall des DE vorliegt, werden die
							betroffenen Bytes auf den Wert 255 gesetzt.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsLveErgebnisMeldungVersion10Bis23 extends AbstractOnlineDatensatz<OdTlsLveErgebnisMeldungVersion10Bis23.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private 	RelativerZeitstempel
				 _t
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwG
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qKrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qPkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qBus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 _qSattelKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwG
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vBus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vSattelKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sPkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sKfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sPkwG
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sKrad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sLfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sLkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sPkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sLkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sBus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sLkwK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sLkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _sSattelKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Kfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85PkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85KfzNk
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85PkwG
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Pkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Krad
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Lfw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85LkwAe
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85PkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Lkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85Bus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85LkwK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85LkwA
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _v85SattelKfz
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qKfzGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qPkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qKfzNkGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qPkwGGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qPkwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qKradGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLfwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLkwAeGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qPkwAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLkwGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qBusGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLkwKGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qLkwAGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> _qSattelKfzGeschwKlasse = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				>(16, true);
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@return der Wert von T.
			*/
				public 	RelativerZeitstempel
				 getT() {
				return _t;
			}
		
			/**
			Intervalldauer.
			<p>
			
			</p>
			
			@param _t der neue Wert von T.
			*/
			public void setT(	RelativerZeitstempel
			 _t) {
				this._t = _t;
			}
		
			/**
			Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfz() {
				return _qKfz;
			}
		
			/**
			Fahrzeugmenge Kfz.
			<p>
			
			</p>
			
			@param _qKfz der neue Wert von QKfz.
			*/
			public void setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfz) {
				this._qKfz = _qKfz;
			}
		
			/**
			Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwAe() {
				return _qPkwAe;
			}
		
			/**
			Fahrzeugmenge Pkw ähnliche.
			<p>
			
			</p>
			
			@param _qPkwAe der neue Wert von QPkwAe.
			*/
			public void setQPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwAe) {
				this._qPkwAe = _qPkwAe;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKfzNk() {
				return _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _qKfzNk der neue Wert von QKfzNk.
			*/
			public void setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKfzNk) {
				this._qKfzNk = _qKfzNk;
			}
		
			/**
			Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwG() {
				return _qPkwG;
			}
		
			/**
			Fahrzeugmenge Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@param _qPkwG der neue Wert von QPkwG.
			*/
			public void setQPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwG) {
				this._qPkwG = _qPkwG;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkw() {
				return _qPkw;
			}
		
			/**
			Fahrzeugmenge Pkw.
			<p>
			
			</p>
			
			@param _qPkw der neue Wert von QPkw.
			*/
			public void setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkw) {
				this._qPkw = _qPkw;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@return der Wert von QKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQKrad() {
				return _qKrad;
			}
		
			/**
			Fahrzeugmenge Krad.
			<p>
			
			</p>
			
			@param _qKrad der neue Wert von QKrad.
			*/
			public void setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qKrad) {
				this._qKrad = _qKrad;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLfw() {
				return _qLfw;
			}
		
			/**
			Fahrzeugmenge Lieferwagen.
			<p>
			
			</p>
			
			@param _qLfw der neue Wert von QLfw.
			*/
			public void setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLfw) {
				this._qLfw = _qLfw;
			}
		
			/**
			Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwAe() {
				return _qLkwAe;
			}
		
			/**
			Fahrzeugmenge Lkw ähnliche.
			<p>
			
			</p>
			
			@param _qLkwAe der neue Wert von QLkwAe.
			*/
			public void setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwAe) {
				this._qLkwAe = _qLkwAe;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQPkwA() {
				return _qPkwA;
			}
		
			/**
			Fahrzeugmenge Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qPkwA der neue Wert von QPkwA.
			*/
			public void setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qPkwA) {
				this._qPkwA = _qPkwA;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkw() {
				return _qLkw;
			}
		
			/**
			Fahrzeugmenge Lkw.
			<p>
			
			</p>
			
			@param _qLkw der neue Wert von QLkw.
			*/
			public void setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkw) {
				this._qLkw = _qLkw;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@return der Wert von QBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQBus() {
				return _qBus;
			}
		
			/**
			Fahrzeugmenge Busse.
			<p>
			
			</p>
			
			@param _qBus der neue Wert von QBus.
			*/
			public void setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qBus) {
				this._qBus = _qBus;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwK() {
				return _qLkwK;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qLkwK der neue Wert von QLkwK.
			*/
			public void setQLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwK) {
				this._qLkwK = _qLkwK;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQLkwA() {
				return _qLkwA;
			}
		
			/**
			Fahrzeugmenge Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _qLkwA der neue Wert von QLkwA.
			*/
			public void setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qLkwA) {
				this._qLkwA = _qLkwA;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				 getQSattelKfz() {
				return _qSattelKfz;
			}
		
			/**
			Fahrzeugmenge Sattel-Kfz.
			<p>
			
			</p>
			
			@param _qSattelKfz der neue Wert von QSattelKfz.
			*/
			public void setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
			 _qSattelKfz) {
				this._qSattelKfz = _qSattelKfz;
			}
		
			/**
			Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfz() {
				return _vKfz;
			}
		
			/**
			Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _vKfz der neue Wert von VKfz.
			*/
			public void setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfz) {
				this._vKfz = _vKfz;
			}
		
			/**
			Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwAe() {
				return _vPkwAe;
			}
		
			/**
			Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _vPkwAe der neue Wert von VPkwAe.
			*/
			public void setVPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwAe) {
				this._vPkwAe = _vPkwAe;
			}
		
			/**
			Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von VKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzNk() {
				return _vKfzNk;
			}
		
			/**
			Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _vKfzNk der neue Wert von VKfzNk.
			*/
			public void setVKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzNk) {
				this._vKfzNk = _vKfzNk;
			}
		
			/**
			Geschwindigkeit Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von VPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwG() {
				return _vPkwG;
			}
		
			/**
			Geschwindigkeit Pkw Gruppe (Motorräder, Pkw ,
									Lieferwagen).
			<p>
			
			</p>
			
			@param _vPkwG der neue Wert von VPkwG.
			*/
			public void setVPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwG) {
				this._vPkwG = _vPkwG;
			}
		
			/**
			Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkw() {
				return _vPkw;
			}
		
			/**
			Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _vPkw der neue Wert von VPkw.
			*/
			public void setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkw) {
				this._vPkw = _vPkw;
			}
		
			/**
			Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von VKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKrad() {
				return _vKrad;
			}
		
			/**
			Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _vKrad der neue Wert von VKrad.
			*/
			public void setVKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKrad) {
				this._vKrad = _vKrad;
			}
		
			/**
			Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von VLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLfw() {
				return _vLfw;
			}
		
			/**
			Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _vLfw der neue Wert von VLfw.
			*/
			public void setVLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLfw) {
				this._vLfw = _vLfw;
			}
		
			/**
			Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von VLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwAe() {
				return _vLkwAe;
			}
		
			/**
			Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _vLkwAe der neue Wert von VLkwAe.
			*/
			public void setVLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwAe) {
				this._vLkwAe = _vLkwAe;
			}
		
			/**
			Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwA() {
				return _vPkwA;
			}
		
			/**
			Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vPkwA der neue Wert von VPkwA.
			*/
			public void setVPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwA) {
				this._vPkwA = _vPkwA;
			}
		
			/**
			Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkw() {
				return _vLkw;
			}
		
			/**
			Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _vLkw der neue Wert von VLkw.
			*/
			public void setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkw) {
				this._vLkw = _vLkw;
			}
		
			/**
			Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von VBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVBus() {
				return _vBus;
			}
		
			/**
			Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _vBus der neue Wert von VBus.
			*/
			public void setVBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vBus) {
				this._vBus = _vBus;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwK() {
				return _vLkwK;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vLkwK der neue Wert von VLkwK.
			*/
			public void setVLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwK) {
				this._vLkwK = _vLkwK;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von VLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwA() {
				return _vLkwA;
			}
		
			/**
			Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _vLkwA der neue Wert von VLkwA.
			*/
			public void setVLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwA) {
				this._vLkwA = _vLkwA;
			}
		
			/**
			Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von VSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVSattelKfz() {
				return _vSattelKfz;
			}
		
			/**
			Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _vSattelKfz der neue Wert von VSattelKfz.
			*/
			public void setVSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vSattelKfz) {
				this._vSattelKfz = _vSattelKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von SKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSKfz() {
				return _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _sKfz der neue Wert von SKfz.
			*/
			public void setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sKfz) {
				this._sKfz = _sKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SPkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSPkwAe() {
				return _sPkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									ähnliche.
			<p>
			
			</p>
			
			@param _sPkwAe der neue Wert von SPkwAe.
			*/
			public void setSPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sPkwAe) {
				this._sPkwAe = _sPkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz nicht
									klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von SKfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSKfzNk() {
				return _sKfzNk;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Kfz nicht
									klassifiziert.
			<p>
			
			</p>
			
			@param _sKfzNk der neue Wert von SKfzNk.
			*/
			public void setSKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sKfzNk) {
				this._sKfzNk = _sKfzNk;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von SPkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSPkwG() {
				return _sPkwG;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@param _sPkwG der neue Wert von SPkwG.
			*/
			public void setSPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sPkwG) {
				this._sPkwG = _sPkwG;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von SPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSPkw() {
				return _sPkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _sPkw der neue Wert von SPkw.
			*/
			public void setSPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sPkw) {
				this._sPkw = _sPkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von SKrad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSKrad() {
				return _sKrad;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _sKrad der neue Wert von SKrad.
			*/
			public void setSKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sKrad) {
				this._sKrad = _sKrad;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von SLfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSLfw() {
				return _sLfw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Lieferwagen.
			<p>
			
			</p>
			
			@param _sLfw der neue Wert von SLfw.
			*/
			public void setSLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sLfw) {
				this._sLfw = _sLfw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von SLkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSLkwAe() {
				return _sLkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw
									ähnliche.
			<p>
			
			</p>
			
			@param _sLkwAe der neue Wert von SLkwAe.
			*/
			public void setSLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sLkwAe) {
				this._sLkwAe = _sLkwAe;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw mit
									Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SPkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSPkwA() {
				return _sPkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Pkw mit
									Anhänger.
			<p>
			
			</p>
			
			@param _sPkwA der neue Wert von SPkwA.
			*/
			public void setSPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sPkwA) {
				this._sPkwA = _sPkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von SLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSLkw() {
				return _sLkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _sLkw der neue Wert von SLkw.
			*/
			public void setSLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sLkw) {
				this._sLkw = _sLkw;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von SBus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSBus() {
				return _sBus;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _sBus der neue Wert von SBus.
			*/
			public void setSBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sBus) {
				this._sBus = _sBus;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SLkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSLkwK() {
				return _sLkwK;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sLkwK der neue Wert von SLkwK.
			*/
			public void setSLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sLkwK) {
				this._sLkwK = _sLkwK;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger.
			<p>
			
			</p>
			
			@return der Wert von SLkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSLkwA() {
				return _sLkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit Lkw mit
									Anhänger.
			<p>
			
			</p>
			
			@param _sLkwA der neue Wert von SLkwA.
			*/
			public void setSLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sLkwA) {
				this._sLkwA = _sLkwA;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von SSattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getSSattelKfz() {
				return _sSattelKfz;
			}
		
			/**
			Standardabweichung der Geschwindigkeit
									Sattel-Kfz.
			<p>
			
			</p>
			
			@param _sSattelKfz der neue Wert von SSattelKfz.
			*/
			public void setSSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _sSattelKfz) {
				this._sSattelKfz = _sSattelKfz;
			}
		
			/**
			v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85Kfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Kfz() {
				return _v85Kfz;
			}
		
			/**
			v85-Geschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _v85Kfz der neue Wert von V85Kfz.
			*/
			public void setV85Kfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Kfz) {
				this._v85Kfz = _v85Kfz;
			}
		
			/**
			v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85PkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85PkwAe() {
				return _v85PkwAe;
			}
		
			/**
			v85-Geschwindigkeit Pkw ähnliche.
			<p>
			
			</p>
			
			@param _v85PkwAe der neue Wert von V85PkwAe.
			*/
			public void setV85PkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85PkwAe) {
				this._v85PkwAe = _v85PkwAe;
			}
		
			/**
			v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von V85KfzNk.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85KfzNk() {
				return _v85KfzNk;
			}
		
			/**
			v85-Geschwindigkeit Kfz nicht klassifiziert.
			<p>
			
			</p>
			
			@param _v85KfzNk der neue Wert von V85KfzNk.
			*/
			public void setV85KfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85KfzNk) {
				this._v85KfzNk = _v85KfzNk;
			}
		
			/**
			v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw
									, Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von V85PkwG.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85PkwG() {
				return _v85PkwG;
			}
		
			/**
			v85-Geschwindigkeit Pkw Gruppe (Motorräder, Pkw
									, Lieferwagen).
			<p>
			
			</p>
			
			@param _v85PkwG der neue Wert von V85PkwG.
			*/
			public void setV85PkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85PkwG) {
				this._v85PkwG = _v85PkwG;
			}
		
			/**
			v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von V85Pkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Pkw() {
				return _v85Pkw;
			}
		
			/**
			v85-Geschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _v85Pkw der neue Wert von V85Pkw.
			*/
			public void setV85Pkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Pkw) {
				this._v85Pkw = _v85Pkw;
			}
		
			/**
			v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@return der Wert von V85Krad.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Krad() {
				return _v85Krad;
			}
		
			/**
			v85-Geschwindigkeit Krad.
			<p>
			
			</p>
			
			@param _v85Krad der neue Wert von V85Krad.
			*/
			public void setV85Krad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Krad) {
				this._v85Krad = _v85Krad;
			}
		
			/**
			v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von V85Lfw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Lfw() {
				return _v85Lfw;
			}
		
			/**
			v85-Geschwindigkeit Lieferwagen.
			<p>
			
			</p>
			
			@param _v85Lfw der neue Wert von V85Lfw.
			*/
			public void setV85Lfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Lfw) {
				this._v85Lfw = _v85Lfw;
			}
		
			/**
			v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@return der Wert von V85LkwAe.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85LkwAe() {
				return _v85LkwAe;
			}
		
			/**
			v85-Geschwindigkeit Lkw ähnliche.
			<p>
			
			</p>
			
			@param _v85LkwAe der neue Wert von V85LkwAe.
			*/
			public void setV85LkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85LkwAe) {
				this._v85LkwAe = _v85LkwAe;
			}
		
			/**
			v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85PkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85PkwA() {
				return _v85PkwA;
			}
		
			/**
			v85-Geschwindigkeit Pkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85PkwA der neue Wert von V85PkwA.
			*/
			public void setV85PkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85PkwA) {
				this._v85PkwA = _v85PkwA;
			}
		
			/**
			v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von V85Lkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Lkw() {
				return _v85Lkw;
			}
		
			/**
			v85-Geschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _v85Lkw der neue Wert von V85Lkw.
			*/
			public void setV85Lkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Lkw) {
				this._v85Lkw = _v85Lkw;
			}
		
			/**
			v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@return der Wert von V85Bus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85Bus() {
				return _v85Bus;
			}
		
			/**
			v85-Geschwindigkeit Busse.
			<p>
			
			</p>
			
			@param _v85Bus der neue Wert von V85Bus.
			*/
			public void setV85Bus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85Bus) {
				this._v85Bus = _v85Bus;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger und
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85LkwK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85LkwK() {
				return _v85LkwK;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger und
									Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85LkwK der neue Wert von V85LkwK.
			*/
			public void setV85LkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85LkwK) {
				this._v85LkwK = _v85LkwK;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von V85LkwA.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85LkwA() {
				return _v85LkwA;
			}
		
			/**
			v85-Geschwindigkeit Lkw mit Anhänger.
			<p>
			
			</p>
			
			@param _v85LkwA der neue Wert von V85LkwA.
			*/
			public void setV85LkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85LkwA) {
				this._v85LkwA = _v85LkwA;
			}
		
			/**
			v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von V85SattelKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getV85SattelKfz() {
				return _v85SattelKfz;
			}
		
			/**
			v85-Geschwindigkeit Sattel-Kfz.
			<p>
			
			</p>
			
			@param _v85SattelKfz der neue Wert von V85SattelKfz.
			*/
			public void setV85SattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _v85SattelKfz) {
				this._v85SattelKfz = _v85SattelKfz;
			}
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz.
			<p>
			
			</p>
			
			@return der Wert von QKfzGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQKfzGeschwKlasse() {
				return _qKfzGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QPkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQPkwAeGeschwKlasse() {
				return _qPkwAeGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Kfz
									nicht klassifiziert.
			<p>
			
			</p>
			
			@return der Wert von QKfzNkGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQKfzNkGeschwKlasse() {
				return _qKfzNkGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									Gruppe (Motorräder, Pkw , Lieferwagen).
			<p>
			
			</p>
			
			@return der Wert von QPkwGGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQPkwGGeschwKlasse() {
				return _qPkwGGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw.
			<p>
			
			</p>
			
			@return der Wert von QPkwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQPkwGeschwKlasse() {
				return _qPkwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Krad.
			<p>
			
			</p>
			
			@return der Wert von QKradGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQKradGeschwKlasse() {
				return _qKradGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Lieferwagen.
			<p>
			
			</p>
			
			@return der Wert von QLfwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLfwGeschwKlasse() {
				return _qLfwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									ähnliche.
			<p>
			
			</p>
			
			@return der Wert von QLkwAeGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLkwAeGeschwKlasse() {
				return _qLkwAeGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Pkw
									mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QPkwAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQPkwAGeschwKlasse() {
				return _qPkwAGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw.
			<p>
			
			</p>
			
			@return der Wert von QLkwGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLkwGeschwKlasse() {
				return _qLkwGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Busse.
			<p>
			
			</p>
			
			@return der Wert von QBusGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQBusGeschwKlasse() {
				return _qBusGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									mit Anhänger und Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QLkwKGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLkwKGeschwKlasse() {
				return _qLkwKGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse Lkw
									mit Anhänger.
			<p>
			
			</p>
			
			@return der Wert von QLkwAGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQLkwAGeschwKlasse() {
				return _qLkwAGeschwKlasse;
			}
		
		
			/**
			Anzahl Fahrzeuge in Geschwindigkeitsklasse
									Sattel-Kfz.
			<p>
			
			</p>
			
			@return der Wert von QSattelKfzGeschwKlasse.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
				> getQSattelKfzGeschwKlasse() {
				return _qSattelKfzGeschwKlasse;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						datum.getTimeValue("T").setMillis(getT().getTime());
					// GanzzahlAttributTyp
					if (getQKfz() != null) {
		                if (getQKfz().isZustand()) {
		                    datum.getUnscaledValue("qKfz").setText(getQKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfz").set(getQKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwAe() != null) {
		                if (getQPkwAe().isZustand()) {
		                    datum.getUnscaledValue("qPkwÄ").setText(getQPkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkwÄ").set(getQPkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzNk() != null) {
		                if (getQKfzNk().isZustand()) {
		                    datum.getUnscaledValue("qKfzNk").setText(getQKfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKfzNk").set(getQKfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwG() != null) {
		                if (getQPkwG().isZustand()) {
		                    datum.getUnscaledValue("qPkwG").setText(getQPkwG().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkwG").set(getQPkwG().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkw() != null) {
		                if (getQPkw().isZustand()) {
		                    datum.getUnscaledValue("qPkw").setText(getQPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkw").set(getQPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKrad() != null) {
		                if (getQKrad().isZustand()) {
		                    datum.getUnscaledValue("qKrad").setText(getQKrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qKrad").set(getQKrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLfw() != null) {
		                if (getQLfw().isZustand()) {
		                    datum.getUnscaledValue("qLfw").setText(getQLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLfw").set(getQLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwAe() != null) {
		                if (getQLkwAe().isZustand()) {
		                    datum.getUnscaledValue("qLkwÄ").setText(getQLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwÄ").set(getQLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQPkwA() != null) {
		                if (getQPkwA().isZustand()) {
		                    datum.getUnscaledValue("qPkwA").setText(getQPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qPkwA").set(getQPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkw() != null) {
		                if (getQLkw().isZustand()) {
		                    datum.getUnscaledValue("qLkw").setText(getQLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkw").set(getQLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQBus() != null) {
		                if (getQBus().isZustand()) {
		                    datum.getUnscaledValue("qBus").setText(getQBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qBus").set(getQBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwK() != null) {
		                if (getQLkwK().isZustand()) {
		                    datum.getUnscaledValue("qLkwK").setText(getQLkwK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwK").set(getQLkwK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQLkwA() != null) {
		                if (getQLkwA().isZustand()) {
		                    datum.getUnscaledValue("qLkwA").setText(getQLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qLkwA").set(getQLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQSattelKfz() != null) {
		                if (getQSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("qSattelKfz").setText(getQSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("qSattelKfz").set(getQSattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfz() != null) {
		                if (getVKfz().isZustand()) {
		                    datum.getUnscaledValue("vKfz").setText(getVKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfz").set(getVKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwAe() != null) {
		                if (getVPkwAe().isZustand()) {
		                    datum.getUnscaledValue("vPkwÄ").setText(getVPkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwÄ").set(getVPkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKfzNk() != null) {
		                if (getVKfzNk().isZustand()) {
		                    datum.getUnscaledValue("vKfzNk").setText(getVKfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfzNk").set(getVKfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwG() != null) {
		                if (getVPkwG().isZustand()) {
		                    datum.getUnscaledValue("vPkwG").setText(getVPkwG().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwG").set(getVPkwG().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkw() != null) {
		                if (getVPkw().isZustand()) {
		                    datum.getUnscaledValue("vPkw").setText(getVPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkw").set(getVPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVKrad() != null) {
		                if (getVKrad().isZustand()) {
		                    datum.getUnscaledValue("vKrad").setText(getVKrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKrad").set(getVKrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLfw() != null) {
		                if (getVLfw().isZustand()) {
		                    datum.getUnscaledValue("vLfw").setText(getVLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLfw").set(getVLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwAe() != null) {
		                if (getVLkwAe().isZustand()) {
		                    datum.getUnscaledValue("vLkwÄ").setText(getVLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwÄ").set(getVLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwA() != null) {
		                if (getVPkwA().isZustand()) {
		                    datum.getUnscaledValue("vPkwA").setText(getVPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwA").set(getVPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkw() != null) {
		                if (getVLkw().isZustand()) {
		                    datum.getUnscaledValue("vLkw").setText(getVLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkw").set(getVLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVBus() != null) {
		                if (getVBus().isZustand()) {
		                    datum.getUnscaledValue("vBus").setText(getVBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vBus").set(getVBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwK() != null) {
		                if (getVLkwK().isZustand()) {
		                    datum.getUnscaledValue("vLkwK").setText(getVLkwK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwK").set(getVLkwK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwA() != null) {
		                if (getVLkwA().isZustand()) {
		                    datum.getUnscaledValue("vLkwA").setText(getVLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwA").set(getVLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVSattelKfz() != null) {
		                if (getVSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("vSattelKfz").setText(getVSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vSattelKfz").set(getVSattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSKfz() != null) {
		                if (getSKfz().isZustand()) {
		                    datum.getUnscaledValue("sKfz").setText(getSKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sKfz").set(getSKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSPkwAe() != null) {
		                if (getSPkwAe().isZustand()) {
		                    datum.getUnscaledValue("sPkwÄ").setText(getSPkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sPkwÄ").set(getSPkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSKfzNk() != null) {
		                if (getSKfzNk().isZustand()) {
		                    datum.getUnscaledValue("sKfzNk").setText(getSKfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sKfzNk").set(getSKfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSPkwG() != null) {
		                if (getSPkwG().isZustand()) {
		                    datum.getUnscaledValue("sPkwG").setText(getSPkwG().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sPkwG").set(getSPkwG().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSPkw() != null) {
		                if (getSPkw().isZustand()) {
		                    datum.getUnscaledValue("sPkw").setText(getSPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sPkw").set(getSPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSKrad() != null) {
		                if (getSKrad().isZustand()) {
		                    datum.getUnscaledValue("sKrad").setText(getSKrad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sKrad").set(getSKrad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLfw() != null) {
		                if (getSLfw().isZustand()) {
		                    datum.getUnscaledValue("sLfw").setText(getSLfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLfw").set(getSLfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLkwAe() != null) {
		                if (getSLkwAe().isZustand()) {
		                    datum.getUnscaledValue("sLkwÄ").setText(getSLkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLkwÄ").set(getSLkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSPkwA() != null) {
		                if (getSPkwA().isZustand()) {
		                    datum.getUnscaledValue("sPkwA").setText(getSPkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sPkwA").set(getSPkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLkw() != null) {
		                if (getSLkw().isZustand()) {
		                    datum.getUnscaledValue("sLkw").setText(getSLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLkw").set(getSLkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSBus() != null) {
		                if (getSBus().isZustand()) {
		                    datum.getUnscaledValue("sBus").setText(getSBus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sBus").set(getSBus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLkwK() != null) {
		                if (getSLkwK().isZustand()) {
		                    datum.getUnscaledValue("sLkwK").setText(getSLkwK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLkwK").set(getSLkwK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSLkwA() != null) {
		                if (getSLkwA().isZustand()) {
		                    datum.getUnscaledValue("sLkwA").setText(getSLkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sLkwA").set(getSLkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSSattelKfz() != null) {
		                if (getSSattelKfz().isZustand()) {
		                    datum.getUnscaledValue("sSattelKfz").setText(getSSattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("sSattelKfz").set(getSSattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Kfz() != null) {
		                if (getV85Kfz().isZustand()) {
		                    datum.getUnscaledValue("v85Kfz").setText(getV85Kfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Kfz").set(getV85Kfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85PkwAe() != null) {
		                if (getV85PkwAe().isZustand()) {
		                    datum.getUnscaledValue("v85PkwÄ").setText(getV85PkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85PkwÄ").set(getV85PkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85KfzNk() != null) {
		                if (getV85KfzNk().isZustand()) {
		                    datum.getUnscaledValue("v85KfzNk").setText(getV85KfzNk().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85KfzNk").set(getV85KfzNk().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85PkwG() != null) {
		                if (getV85PkwG().isZustand()) {
		                    datum.getUnscaledValue("v85PkwG").setText(getV85PkwG().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85PkwG").set(getV85PkwG().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Pkw() != null) {
		                if (getV85Pkw().isZustand()) {
		                    datum.getUnscaledValue("v85Pkw").setText(getV85Pkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Pkw").set(getV85Pkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Krad() != null) {
		                if (getV85Krad().isZustand()) {
		                    datum.getUnscaledValue("v85Krad").setText(getV85Krad().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Krad").set(getV85Krad().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Lfw() != null) {
		                if (getV85Lfw().isZustand()) {
		                    datum.getUnscaledValue("v85Lfw").setText(getV85Lfw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Lfw").set(getV85Lfw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85LkwAe() != null) {
		                if (getV85LkwAe().isZustand()) {
		                    datum.getUnscaledValue("v85LkwÄ").setText(getV85LkwAe().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85LkwÄ").set(getV85LkwAe().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85PkwA() != null) {
		                if (getV85PkwA().isZustand()) {
		                    datum.getUnscaledValue("v85PkwA").setText(getV85PkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85PkwA").set(getV85PkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Lkw() != null) {
		                if (getV85Lkw().isZustand()) {
		                    datum.getUnscaledValue("v85Lkw").setText(getV85Lkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Lkw").set(getV85Lkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85Bus() != null) {
		                if (getV85Bus().isZustand()) {
		                    datum.getUnscaledValue("v85Bus").setText(getV85Bus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85Bus").set(getV85Bus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85LkwK() != null) {
		                if (getV85LkwK().isZustand()) {
		                    datum.getUnscaledValue("v85LkwK").setText(getV85LkwK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85LkwK").set(getV85LkwK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85LkwA() != null) {
		                if (getV85LkwA().isZustand()) {
		                    datum.getUnscaledValue("v85LkwA").setText(getV85LkwA().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85LkwA").set(getV85LkwA().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getV85SattelKfz() != null) {
		                if (getV85SattelKfz().isZustand()) {
		                    datum.getUnscaledValue("v85SattelKfz").setText(getV85SattelKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("v85SattelKfz").set(getV85SattelKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getQKfzGeschwKlasse() != null) {
						final Data.NumberArray arrayQKfzGeschwKlasse = datum.
							getUnscaledArray
							("qKfzGeschwKlasse");
						arrayQKfzGeschwKlasse.setLength(getQKfzGeschwKlasse().size());
						for (int i = 0; i < arrayQKfzGeschwKlasse.getLength(); ++i) {
							arrayQKfzGeschwKlasse.getValue(i).set(getQKfzGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQPkwAeGeschwKlasse() != null) {
						final Data.NumberArray arrayQPkwAeGeschwKlasse = datum.
							getUnscaledArray
							("qPkwÄGeschwKlasse");
						arrayQPkwAeGeschwKlasse.setLength(getQPkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
							arrayQPkwAeGeschwKlasse.getValue(i).set(getQPkwAeGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQKfzNkGeschwKlasse() != null) {
						final Data.NumberArray arrayQKfzNkGeschwKlasse = datum.
							getUnscaledArray
							("qKfzNkGeschwKlasse");
						arrayQKfzNkGeschwKlasse.setLength(getQKfzNkGeschwKlasse().size());
						for (int i = 0; i < arrayQKfzNkGeschwKlasse.getLength(); ++i) {
							arrayQKfzNkGeschwKlasse.getValue(i).set(getQKfzNkGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQPkwGGeschwKlasse() != null) {
						final Data.NumberArray arrayQPkwGGeschwKlasse = datum.
							getUnscaledArray
							("qPkwGGeschwKlasse");
						arrayQPkwGGeschwKlasse.setLength(getQPkwGGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwGGeschwKlasse.getLength(); ++i) {
							arrayQPkwGGeschwKlasse.getValue(i).set(getQPkwGGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQPkwGeschwKlasse() != null) {
						final Data.NumberArray arrayQPkwGeschwKlasse = datum.
							getUnscaledArray
							("qPkwGeschwKlasse");
						arrayQPkwGeschwKlasse.setLength(getQPkwGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwGeschwKlasse.getLength(); ++i) {
							arrayQPkwGeschwKlasse.getValue(i).set(getQPkwGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQKradGeschwKlasse() != null) {
						final Data.NumberArray arrayQKradGeschwKlasse = datum.
							getUnscaledArray
							("qKradGeschwKlasse");
						arrayQKradGeschwKlasse.setLength(getQKradGeschwKlasse().size());
						for (int i = 0; i < arrayQKradGeschwKlasse.getLength(); ++i) {
							arrayQKradGeschwKlasse.getValue(i).set(getQKradGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLfwGeschwKlasse() != null) {
						final Data.NumberArray arrayQLfwGeschwKlasse = datum.
							getUnscaledArray
							("qLfwGeschwKlasse");
						arrayQLfwGeschwKlasse.setLength(getQLfwGeschwKlasse().size());
						for (int i = 0; i < arrayQLfwGeschwKlasse.getLength(); ++i) {
							arrayQLfwGeschwKlasse.getValue(i).set(getQLfwGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLkwAeGeschwKlasse() != null) {
						final Data.NumberArray arrayQLkwAeGeschwKlasse = datum.
							getUnscaledArray
							("qLkwÄGeschwKlasse");
						arrayQLkwAeGeschwKlasse.setLength(getQLkwAeGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
							arrayQLkwAeGeschwKlasse.getValue(i).set(getQLkwAeGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQPkwAGeschwKlasse() != null) {
						final Data.NumberArray arrayQPkwAGeschwKlasse = datum.
							getUnscaledArray
							("qPkwAGeschwKlasse");
						arrayQPkwAGeschwKlasse.setLength(getQPkwAGeschwKlasse().size());
						for (int i = 0; i < arrayQPkwAGeschwKlasse.getLength(); ++i) {
							arrayQPkwAGeschwKlasse.getValue(i).set(getQPkwAGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLkwGeschwKlasse() != null) {
						final Data.NumberArray arrayQLkwGeschwKlasse = datum.
							getUnscaledArray
							("qLkwGeschwKlasse");
						arrayQLkwGeschwKlasse.setLength(getQLkwGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwGeschwKlasse.getLength(); ++i) {
							arrayQLkwGeschwKlasse.getValue(i).set(getQLkwGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQBusGeschwKlasse() != null) {
						final Data.NumberArray arrayQBusGeschwKlasse = datum.
							getUnscaledArray
							("qBusGeschwKlasse");
						arrayQBusGeschwKlasse.setLength(getQBusGeschwKlasse().size());
						for (int i = 0; i < arrayQBusGeschwKlasse.getLength(); ++i) {
							arrayQBusGeschwKlasse.getValue(i).set(getQBusGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLkwKGeschwKlasse() != null) {
						final Data.NumberArray arrayQLkwKGeschwKlasse = datum.
							getUnscaledArray
							("qLkwKGeschwKlasse");
						arrayQLkwKGeschwKlasse.setLength(getQLkwKGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwKGeschwKlasse.getLength(); ++i) {
							arrayQLkwKGeschwKlasse.getValue(i).set(getQLkwKGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQLkwAGeschwKlasse() != null) {
						final Data.NumberArray arrayQLkwAGeschwKlasse = datum.
							getUnscaledArray
							("qLkwAGeschwKlasse");
						arrayQLkwAGeschwKlasse.setLength(getQLkwAGeschwKlasse().size());
						for (int i = 0; i < arrayQLkwAGeschwKlasse.getLength(); ++i) {
							arrayQLkwAGeschwKlasse.getValue(i).set(getQLkwAGeschwKlasse().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getQSattelKfzGeschwKlasse() != null) {
						final Data.NumberArray arrayQSattelKfzGeschwKlasse = datum.
							getUnscaledArray
							("qSattelKfzGeschwKlasse");
						arrayQSattelKfzGeschwKlasse.setLength(getQSattelKfzGeschwKlasse().size());
						for (int i = 0; i < arrayQSattelKfzGeschwKlasse.getLength(); ++i) {
							arrayQSattelKfzGeschwKlasse.getValue(i).set(getQSattelKfzGeschwKlasse().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeitstempelAttributTyp
						setT(new
							RelativerZeitstempel
							(daten.getTimeValue("T").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfz").isState()) {
								setQKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKfz").getText()));
							} else {
							setQKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkwÄ").isState()) {
								setQPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkwÄ").getText()));
							} else {
							setQPkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkwÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKfzNk").isState()) {
								setQKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKfzNk").getText()));
							} else {
							setQKfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKfzNk").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkwG").isState()) {
								setQPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkwG").getText()));
							} else {
							setQPkwG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkwG").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkw").isState()) {
								setQPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkw").getText()));
							} else {
							setQPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qKrad").isState()) {
								setQKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qKrad").getText()));
							} else {
							setQKrad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qKrad").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLfw").isState()) {
								setQLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLfw").getText()));
							} else {
							setQLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLfw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwÄ").isState()) {
								setQLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkwÄ").getText()));
							} else {
							setQLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkwÄ").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qPkwA").isState()) {
								setQPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qPkwA").getText()));
							} else {
							setQPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qPkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkw").isState()) {
								setQLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkw").getText()));
							} else {
							setQLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qBus").isState()) {
								setQBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qBus").getText()));
							} else {
							setQBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qBus").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwK").isState()) {
								setQLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkwK").getText()));
							} else {
							setQLkwK(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkwK").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qLkwA").isState()) {
								setQLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qLkwA").getText()));
							} else {
							setQLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qLkwA").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("qSattelKfz").isState()) {
								setQSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
								.getZustand(daten.getScaledValue("qSattelKfz").getText()));
							} else {
							setQSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
							(daten.
								getUnscaledValue
							("qSattelKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfz").isState()) {
								setVKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfz").getText()));
							} else {
							setVKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwÄ").isState()) {
								setVPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwÄ").getText()));
							} else {
							setVPkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfzNk").isState()) {
								setVKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfzNk").getText()));
							} else {
							setVKfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfzNk").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwG").isState()) {
								setVPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwG").getText()));
							} else {
							setVPkwG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwG").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkw").isState()) {
								setVPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkw").getText()));
							} else {
							setVPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKrad").isState()) {
								setVKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vKrad").getText()));
							} else {
							setVKrad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKrad").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLfw").isState()) {
								setVLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLfw").getText()));
							} else {
							setVLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLfw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwÄ").isState()) {
								setVLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwÄ").getText()));
							} else {
							setVLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwA").isState()) {
								setVPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwA").getText()));
							} else {
							setVPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkw").isState()) {
								setVLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkw").getText()));
							} else {
							setVLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vBus").isState()) {
								setVBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vBus").getText()));
							} else {
							setVBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vBus").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwK").isState()) {
								setVLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwK").getText()));
							} else {
							setVLkwK(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwK").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwA").isState()) {
								setVLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwA").getText()));
							} else {
							setVLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vSattelKfz").isState()) {
								setVSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vSattelKfz").getText()));
							} else {
							setVSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vSattelKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sKfz").isState()) {
								setSKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sKfz").getText()));
							} else {
							setSKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sPkwÄ").isState()) {
								setSPkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sPkwÄ").getText()));
							} else {
							setSPkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sPkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sKfzNk").isState()) {
								setSKfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sKfzNk").getText()));
							} else {
							setSKfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sKfzNk").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sPkwG").isState()) {
								setSPkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sPkwG").getText()));
							} else {
							setSPkwG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sPkwG").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sPkw").isState()) {
								setSPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sPkw").getText()));
							} else {
							setSPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sPkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sKrad").isState()) {
								setSKrad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sKrad").getText()));
							} else {
							setSKrad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sKrad").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLfw").isState()) {
								setSLfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sLfw").getText()));
							} else {
							setSLfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLfw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLkwÄ").isState()) {
								setSLkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sLkwÄ").getText()));
							} else {
							setSLkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sPkwA").isState()) {
								setSPkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sPkwA").getText()));
							} else {
							setSPkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sPkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLkw").isState()) {
								setSLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sLkw").getText()));
							} else {
							setSLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sBus").isState()) {
								setSBus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sBus").getText()));
							} else {
							setSBus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sBus").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLkwK").isState()) {
								setSLkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sLkwK").getText()));
							} else {
							setSLkwK(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLkwK").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sLkwA").isState()) {
								setSLkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sLkwA").getText()));
							} else {
							setSLkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sLkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("sSattelKfz").isState()) {
								setSSattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("sSattelKfz").getText()));
							} else {
							setSSattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("sSattelKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Kfz").isState()) {
								setV85Kfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Kfz").getText()));
							} else {
							setV85Kfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Kfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85PkwÄ").isState()) {
								setV85PkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85PkwÄ").getText()));
							} else {
							setV85PkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85PkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85KfzNk").isState()) {
								setV85KfzNk(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85KfzNk").getText()));
							} else {
							setV85KfzNk(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85KfzNk").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85PkwG").isState()) {
								setV85PkwG(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85PkwG").getText()));
							} else {
							setV85PkwG(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85PkwG").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Pkw").isState()) {
								setV85Pkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Pkw").getText()));
							} else {
							setV85Pkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Pkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Krad").isState()) {
								setV85Krad(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Krad").getText()));
							} else {
							setV85Krad(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Krad").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Lfw").isState()) {
								setV85Lfw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Lfw").getText()));
							} else {
							setV85Lfw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Lfw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85LkwÄ").isState()) {
								setV85LkwAe(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85LkwÄ").getText()));
							} else {
							setV85LkwAe(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85LkwÄ").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85PkwA").isState()) {
								setV85PkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85PkwA").getText()));
							} else {
							setV85PkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85PkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Lkw").isState()) {
								setV85Lkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Lkw").getText()));
							} else {
							setV85Lkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Lkw").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85Bus").isState()) {
								setV85Bus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85Bus").getText()));
							} else {
							setV85Bus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85Bus").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85LkwK").isState()) {
								setV85LkwK(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85LkwK").getText()));
							} else {
							setV85LkwK(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85LkwK").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85LkwA").isState()) {
								setV85LkwA(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85LkwA").getText()));
							} else {
							setV85LkwA(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85LkwA").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("v85SattelKfz").isState()) {
								setV85SattelKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("v85SattelKfz").getText()));
							} else {
							setV85SattelKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("v85SattelKfz").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQKfzGeschwKlasse = daten.
							getUnscaledArray
						("qKfzGeschwKlasse");
		
						for (int i = 0; i < arrayQKfzGeschwKlasse.getLength(); ++i) {
		                    if (arrayQKfzGeschwKlasse.getValue(i).isState()) {
		                        getQKfzGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQKfzGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQKfzGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQKfzGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQPkwAeGeschwKlasse = daten.
							getUnscaledArray
						("qPkwÄGeschwKlasse");
		
						for (int i = 0; i < arrayQPkwAeGeschwKlasse.getLength(); ++i) {
		                    if (arrayQPkwAeGeschwKlasse.getValue(i).isState()) {
		                        getQPkwAeGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQPkwAeGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQPkwAeGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQPkwAeGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQKfzNkGeschwKlasse = daten.
							getUnscaledArray
						("qKfzNkGeschwKlasse");
		
						for (int i = 0; i < arrayQKfzNkGeschwKlasse.getLength(); ++i) {
		                    if (arrayQKfzNkGeschwKlasse.getValue(i).isState()) {
		                        getQKfzNkGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQKfzNkGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQKfzNkGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQKfzNkGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQPkwGGeschwKlasse = daten.
							getUnscaledArray
						("qPkwGGeschwKlasse");
		
						for (int i = 0; i < arrayQPkwGGeschwKlasse.getLength(); ++i) {
		                    if (arrayQPkwGGeschwKlasse.getValue(i).isState()) {
		                        getQPkwGGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQPkwGGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQPkwGGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQPkwGGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQPkwGeschwKlasse = daten.
							getUnscaledArray
						("qPkwGeschwKlasse");
		
						for (int i = 0; i < arrayQPkwGeschwKlasse.getLength(); ++i) {
		                    if (arrayQPkwGeschwKlasse.getValue(i).isState()) {
		                        getQPkwGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQPkwGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQPkwGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQPkwGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQKradGeschwKlasse = daten.
							getUnscaledArray
						("qKradGeschwKlasse");
		
						for (int i = 0; i < arrayQKradGeschwKlasse.getLength(); ++i) {
		                    if (arrayQKradGeschwKlasse.getValue(i).isState()) {
		                        getQKradGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQKradGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQKradGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQKradGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLfwGeschwKlasse = daten.
							getUnscaledArray
						("qLfwGeschwKlasse");
		
						for (int i = 0; i < arrayQLfwGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLfwGeschwKlasse.getValue(i).isState()) {
		                        getQLfwGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLfwGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLfwGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLfwGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLkwAeGeschwKlasse = daten.
							getUnscaledArray
						("qLkwÄGeschwKlasse");
		
						for (int i = 0; i < arrayQLkwAeGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLkwAeGeschwKlasse.getValue(i).isState()) {
		                        getQLkwAeGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLkwAeGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLkwAeGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLkwAeGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQPkwAGeschwKlasse = daten.
							getUnscaledArray
						("qPkwAGeschwKlasse");
		
						for (int i = 0; i < arrayQPkwAGeschwKlasse.getLength(); ++i) {
		                    if (arrayQPkwAGeschwKlasse.getValue(i).isState()) {
		                        getQPkwAGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQPkwAGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQPkwAGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQPkwAGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLkwGeschwKlasse = daten.
							getUnscaledArray
						("qLkwGeschwKlasse");
		
						for (int i = 0; i < arrayQLkwGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLkwGeschwKlasse.getValue(i).isState()) {
		                        getQLkwGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLkwGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLkwGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLkwGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQBusGeschwKlasse = daten.
							getUnscaledArray
						("qBusGeschwKlasse");
		
						for (int i = 0; i < arrayQBusGeschwKlasse.getLength(); ++i) {
		                    if (arrayQBusGeschwKlasse.getValue(i).isState()) {
		                        getQBusGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQBusGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQBusGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQBusGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLkwKGeschwKlasse = daten.
							getUnscaledArray
						("qLkwKGeschwKlasse");
		
						for (int i = 0; i < arrayQLkwKGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLkwKGeschwKlasse.getValue(i).isState()) {
		                        getQLkwKGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLkwKGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLkwKGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLkwKGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQLkwAGeschwKlasse = daten.
							getUnscaledArray
						("qLkwAGeschwKlasse");
		
						for (int i = 0; i < arrayQLkwAGeschwKlasse.getLength(); ++i) {
		                    if (arrayQLkwAGeschwKlasse.getValue(i).isState()) {
		                        getQLkwAGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQLkwAGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQLkwAGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQLkwAGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayQSattelKfzGeschwKlasse = daten.
							getUnscaledArray
						("qSattelKfzGeschwKlasse");
		
						for (int i = 0; i < arrayQSattelKfzGeschwKlasse.getLength(); ++i) {
		                    if (arrayQSattelKfzGeschwKlasse.getValue(i).isState()) {
		                        getQSattelKfzGeschwKlasse().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                        .getZustand(arrayQSattelKfzGeschwKlasse.getValue(i).getState().getName()));
		                    } else {
		                    getQSattelKfzGeschwKlasse().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveVerkehrsstaerke
		                    (arrayQSattelKfzGeschwKlasse.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setT(getT());
							klon.setQKfz(getQKfz());
							klon.setQPkwAe(getQPkwAe());
							klon.setQKfzNk(getQKfzNk());
							klon.setQPkwG(getQPkwG());
							klon.setQPkw(getQPkw());
							klon.setQKrad(getQKrad());
							klon.setQLfw(getQLfw());
							klon.setQLkwAe(getQLkwAe());
							klon.setQPkwA(getQPkwA());
							klon.setQLkw(getQLkw());
							klon.setQBus(getQBus());
							klon.setQLkwK(getQLkwK());
							klon.setQLkwA(getQLkwA());
							klon.setQSattelKfz(getQSattelKfz());
							klon.setVKfz(getVKfz());
							klon.setVPkwAe(getVPkwAe());
							klon.setVKfzNk(getVKfzNk());
							klon.setVPkwG(getVPkwG());
							klon.setVPkw(getVPkw());
							klon.setVKrad(getVKrad());
							klon.setVLfw(getVLfw());
							klon.setVLkwAe(getVLkwAe());
							klon.setVPkwA(getVPkwA());
							klon.setVLkw(getVLkw());
							klon.setVBus(getVBus());
							klon.setVLkwK(getVLkwK());
							klon.setVLkwA(getVLkwA());
							klon.setVSattelKfz(getVSattelKfz());
							klon.setSKfz(getSKfz());
							klon.setSPkwAe(getSPkwAe());
							klon.setSKfzNk(getSKfzNk());
							klon.setSPkwG(getSPkwG());
							klon.setSPkw(getSPkw());
							klon.setSKrad(getSKrad());
							klon.setSLfw(getSLfw());
							klon.setSLkwAe(getSLkwAe());
							klon.setSPkwA(getSPkwA());
							klon.setSLkw(getSLkw());
							klon.setSBus(getSBus());
							klon.setSLkwK(getSLkwK());
							klon.setSLkwA(getSLkwA());
							klon.setSSattelKfz(getSSattelKfz());
							klon.setV85Kfz(getV85Kfz());
							klon.setV85PkwAe(getV85PkwAe());
							klon.setV85KfzNk(getV85KfzNk());
							klon.setV85PkwG(getV85PkwG());
							klon.setV85Pkw(getV85Pkw());
							klon.setV85Krad(getV85Krad());
							klon.setV85Lfw(getV85Lfw());
							klon.setV85LkwAe(getV85LkwAe());
							klon.setV85PkwA(getV85PkwA());
							klon.setV85Lkw(getV85Lkw());
							klon.setV85Bus(getV85Bus());
							klon.setV85LkwK(getV85LkwK());
							klon.setV85LkwA(getV85LkwA());
							klon.setV85SattelKfz(getV85SattelKfz());
						klon._qKfzGeschwKlasse = getQKfzGeschwKlasse().clone();
						klon._qPkwAeGeschwKlasse = getQPkwAeGeschwKlasse().clone();
						klon._qKfzNkGeschwKlasse = getQKfzNkGeschwKlasse().clone();
						klon._qPkwGGeschwKlasse = getQPkwGGeschwKlasse().clone();
						klon._qPkwGeschwKlasse = getQPkwGeschwKlasse().clone();
						klon._qKradGeschwKlasse = getQKradGeschwKlasse().clone();
						klon._qLfwGeschwKlasse = getQLfwGeschwKlasse().clone();
						klon._qLkwAeGeschwKlasse = getQLkwAeGeschwKlasse().clone();
						klon._qPkwAGeschwKlasse = getQPkwAGeschwKlasse().clone();
						klon._qLkwGeschwKlasse = getQLkwGeschwKlasse().clone();
						klon._qBusGeschwKlasse = getQBusGeschwKlasse().clone();
						klon._qLkwKGeschwKlasse = getQLkwKGeschwKlasse().clone();
						klon._qLkwAGeschwKlasse = getQLkwAGeschwKlasse().clone();
						klon._qSattelKfzGeschwKlasse = getQSattelKfzGeschwKlasse().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveErgebnisMeldungVersion10Bis23";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsLveErgebnisMeldungVersion10Bis23(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
