/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
SVE-ErgebnisMeldung Version 0-1 (FG 1 &#47; Typ 96-97).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							TLS-DE-Block-Struktur im Typ
							96-97"SVE-ErgebnisMeldung Version 0-1"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Lassen sich einzelne Werte des Blockes nicht
							ermitteln ohne dass ein Totalausfall des DEs
							vorliegt, so werden die betroffenen
							Messwertbytes auf den Wert 255 gesetzt (z.B.
							aufgrund von Schleifendefekten oder
							verkehrsbedingt ).
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die ErgebnisMeldungen beziehen sich
							normalerweise auf eine Richtungsfahrbahn
							(Gesamtstrom). Fahrstreifenspezifische
							Ergebnisse sind optional möglich, die
							Unterscheidung kann durch Angabe des
							DE-Kanals erfolgen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Da die SVE-Daten sich auf den Gesamtstrom
							einer Richtungsfahrbahn beziehen, sind für
							die DE-Codierung vorzugsweise die Werte
							7,15,... , die alle Fahrstreifen einer
							Fahrbahn bezeichnen, zu verwenden (siehe
							Anhang 7, Kapitel 5).
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsSveErgebnisMeldungVersion0Bis1 extends AbstractOnlineDatensatz<OdTlsSveErgebnisMeldungVersion0Bis1.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vKfzReise
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vPkwReise
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 _vLkwReise
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _kKfz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _kPkw
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 _kLkw
				;
		
			/**
			Mittlere Reisegeschwindigkeit Kfz.
			<p>
			
			</p>
			
			@return der Wert von VKfzReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVKfzReise() {
				return _vKfzReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Kfz.
			<p>
			
			</p>
			
			@param _vKfzReise der neue Wert von VKfzReise.
			*/
			public void setVKfzReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vKfzReise) {
				this._vKfzReise = _vKfzReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Pkw.
			<p>
			
			</p>
			
			@return der Wert von VPkwReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVPkwReise() {
				return _vPkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Pkw.
			<p>
			
			</p>
			
			@param _vPkwReise der neue Wert von VPkwReise.
			*/
			public void setVPkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vPkwReise) {
				this._vPkwReise = _vPkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Lkw.
			<p>
			
			</p>
			
			@return der Wert von VLkwReise.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
				 getVLkwReise() {
				return _vLkwReise;
			}
		
			/**
			Mittlere Reisegeschwindigkeit Lkw.
			<p>
			
			</p>
			
			@param _vLkwReise der neue Wert von VLkwReise.
			*/
			public void setVLkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
			 _vLkwReise) {
				this._vLkwReise = _vLkwReise;
			}
		
			/**
			Dichte der KFZ.
			<p>
			
			</p>
			
			@return der Wert von KKfz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getKKfz() {
				return _kKfz;
			}
		
			/**
			Dichte der KFZ.
			<p>
			
			</p>
			
			@param _kKfz der neue Wert von KKfz.
			*/
			public void setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _kKfz) {
				this._kKfz = _kKfz;
			}
		
			/**
			Dichte der Pkw.
			<p>
			
			</p>
			
			@return der Wert von KPkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getKPkw() {
				return _kPkw;
			}
		
			/**
			Dichte der Pkw.
			<p>
			
			</p>
			
			@param _kPkw der neue Wert von KPkw.
			*/
			public void setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _kPkw) {
				this._kPkw = _kPkw;
			}
		
			/**
			Dichte der Lkw.
			<p>
			
			</p>
			
			@return der Wert von KLkw.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
				 getKLkw() {
				return _kLkw;
			}
		
			/**
			Dichte der Lkw.
			<p>
			
			</p>
			
			@param _kLkw der neue Wert von KLkw.
			*/
			public void setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
			 _kLkw) {
				this._kLkw = _kLkw;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getVKfzReise() != null) {
		                if (getVKfzReise().isZustand()) {
		                    datum.getUnscaledValue("vKfzReise").setText(getVKfzReise().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vKfzReise").set(getVKfzReise().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVPkwReise() != null) {
		                if (getVPkwReise().isZustand()) {
		                    datum.getUnscaledValue("vPkwReise").setText(getVPkwReise().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vPkwReise").set(getVPkwReise().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getVLkwReise() != null) {
		                if (getVLkwReise().isZustand()) {
		                    datum.getUnscaledValue("vLkwReise").setText(getVLkwReise().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vLkwReise").set(getVLkwReise().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKKfz() != null) {
		                if (getKKfz().isZustand()) {
		                    datum.getUnscaledValue("kKfz").setText(getKKfz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kKfz").set(getKKfz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKPkw() != null) {
		                if (getKPkw().isZustand()) {
		                    datum.getUnscaledValue("kPkw").setText(getKPkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kPkw").set(getKPkw().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getKLkw() != null) {
		                if (getKLkw().isZustand()) {
		                    datum.getUnscaledValue("kLkw").setText(getKLkw().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("kLkw").set(getKLkw().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vKfzReise").isState()) {
								setVKfzReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vKfzReise").getText()));
							} else {
							setVKfzReise(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vKfzReise").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vPkwReise").isState()) {
								setVPkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vPkwReise").getText()));
							} else {
							setVPkwReise(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vPkwReise").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("vLkwReise").isState()) {
								setVLkwReise(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
								.getZustand(daten.getScaledValue("vLkwReise").getText()));
							} else {
							setVLkwReise(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGeschwindigkeit
							(daten.
								getUnscaledValue
							("vLkwReise").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("kKfz").isState()) {
								setKKfz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("kKfz").getText()));
							} else {
							setKKfz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("kKfz").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("kPkw").isState()) {
								setKPkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("kPkw").getText()));
							} else {
							setKPkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("kPkw").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("kLkw").isState()) {
								setKLkw(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
								.getZustand(daten.getScaledValue("kLkw").getText()));
							} else {
							setKLkw(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveDichte
							(daten.
								getUnscaledValue
							("kLkw").
									intValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setVKfzReise(getVKfzReise());
							klon.setVPkwReise(getVPkwReise());
							klon.setVLkwReise(getVLkwReise());
							klon.setKKfz(getKKfz());
							klon.setKPkw(getKPkw());
							klon.setKLkw(getKLkw());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsSveErgebnisMeldungVersion0Bis1";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsSveErgebnisMeldungVersion0Bis1(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
