/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Transfer einer Datei zu einem SM bzw. EAK.
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 254: Dateitransfer zu einem SM bzw. EAK.
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet auf dem Lokal-, Insel- und KRI-Bus mit ID 3 (Parameter) in Antwort- und
							Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit Hilfe des DE-Blocks kann die Zentrale größere gekapselte Datenobjekte,
							z.B. Dateien bzw. dateiähnliche Datenströme an das SM bzw. den EAK senden.
							Ein Datenobjekt wird durch einen eindeutigen Bezeichner gekennzeichnet.
							Ein Bezeichner kann bei Dateien z.B. ein Dateiname einschließlich einer
							Pfadangabe sein. Bezeichner und Datenobjekt bilden zusammen ein Schlüssel-Wert-Paar.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Nachdem das SM bzw. der EAK das Datenobjekt vollständig empfangen hat,
							wird eine positive Quittung an die Zentrale gesendet. Sollte der Datentransfer
							fehlschlagen, wird eine negative Quittung (Code=23) gesendet. Ein Senden mit
							DE-Adresse = 255 ist nicht zugelassen!
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 7
 */
public class OdTlsSysDateiTransfer extends AbstractOnlineDatensatz<OdTlsSysDateiTransfer.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
				 _laengeBezeichner
				;
				private String
				 _bezeichner
				= new String
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> _daten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				>(0, true);
		
			/**
			Länge des folgenden Bezeichners (z.B. Dateiname).
			<p>
			
			</p>
			
			@return der Wert von LaengeBezeichner.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
				 getLaengeBezeichner() {
				return _laengeBezeichner;
			}
		
			/**
			Länge des folgenden Bezeichners (z.B. Dateiname).
			<p>
			
			</p>
			
			@param _laengeBezeichner der neue Wert von LaengeBezeichner.
			*/
			public void setLaengeBezeichner(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
			 _laengeBezeichner) {
				this._laengeBezeichner = _laengeBezeichner;
			}
		
			/**
			Eindeutige Bezeichnung des Datenobjekts.
			<p>
			Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@return der Wert von Bezeichner.
			*/
				public String
				 getBezeichner() {
				return _bezeichner;
			}
		
			/**
			Eindeutige Bezeichnung des Datenobjekts.
			<p>
			Die Syntax der Bezeichner für die Datenobjekte werden vom Hersteller
									des Ausgabegerätes bzw. Hersteller des EAK projekt- bzw. gerätespezifisch festlegt.
			</p>
			
			@param _bezeichner der neue Wert von Bezeichner.
			*/
			public void setBezeichner(String
			 _bezeichner) {
				if (_bezeichner.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._bezeichner = _bezeichner;
			}
		
			/**
			Binäre Daten des Datenobjekts.
			<p>
			
			</p>
			
			@return der Wert von Daten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
				> getDaten() {
				return _daten;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getLaengeBezeichner() != null) {
		                if (getLaengeBezeichner().isZustand()) {
		                    datum.getUnscaledValue("LängeBezeichner").setText(getLaengeBezeichner().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LängeBezeichner").set(getLaengeBezeichner().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getBezeichner() != null) {
						datum.getTextValue("Bezeichner").setText(getBezeichner());
					}
					// GanzzahlAttributTyp
					if (getDaten() != null) {
						final Data.NumberArray arrayDaten = datum.
							getUnscaledArray
							("Daten");
						arrayDaten.setLength(getDaten().size());
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
							arrayDaten.getValue(i).set(getDaten().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LängeBezeichner").isState()) {
								setLaengeBezeichner(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
								.getZustand(daten.getScaledValue("LängeBezeichner").getText()));
							} else {
							setLaengeBezeichner(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaengeBezeichner
							(daten.
								getUnscaledValue
							("LängeBezeichner").
									shortValue
							()));
							}
					// ZeichenkettenAttributTyp
						setBezeichner(daten.getTextValue("Bezeichner").getText());
					// GanzzahlAttributTyp
						final Data.NumberArray arrayDaten = daten.
							getUnscaledArray
						("Daten");
		
						for (int i = 0; i < arrayDaten.getLength(); ++i) {
		                    getDaten().add(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttByte_JavaKeyword
		                    (arrayDaten.
		                    		byteValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setLaengeBezeichner(getLaengeBezeichner());
							klon.setBezeichner(getBezeichner());
						klon._daten = getDaten().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsSysDateiTransfer";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsSysDateiTransfer(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
