/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kommunikationsstatus (FG 254 &#47; Typ 19).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 254: DE-Block-Struktur im Typ
							19"Kommunikationsstatus"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 2 (Statusnachrichten)
							in Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht wird auf OSI-7 nicht
							quittiert.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit der Nachricht Kommunikationsstatus
							informiert das Steuermodul seine
							nachgeordneten EAK über den Ausfall bzw. die
							Wiederkehr der Kommunikation zur
							Unterzentrale.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Reaktion eines EAK auf den
							Kommunikationsstatus"unbestimmt"
							oder"gestört" hängt von der FG des EAK ab.
							So kann z.B. eine WVZ-Steuerung bei
							Kommunikationsstatus"gestört" (Verbindung
							zur UZ gestört) die definierte
							Grundeinstellung einnehmen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsSysKommunikationsStatus extends AbstractOnlineDatensatz<OdTlsSysKommunikationsStatus.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysStatusKommunikation
				 _statusKommunikation
				;
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@return der Wert von StatusKommunikation.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysStatusKommunikation
				 getStatusKommunikation() {
				return _statusKommunikation;
			}
		
			/**
			Komunikationsstatus zwischen SM und UZ.
			<p>
			
			</p>
			
			@param _statusKommunikation der neue Wert von StatusKommunikation.
			*/
			public void setStatusKommunikation(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysStatusKommunikation
			 _statusKommunikation) {
				this._statusKommunikation = _statusKommunikation;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStatusKommunikation() != null) {
		                if (getStatusKommunikation().isZustand()) {
		                    datum.getUnscaledValue("StatusKommunikation").setText(getStatusKommunikation().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StatusKommunikation").set(getStatusKommunikation().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StatusKommunikation").isState()) {
								setStatusKommunikation(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysStatusKommunikation
								.getZustand(daten.getScaledValue("StatusKommunikation").getText()));
							} else {
							setStatusKommunikation(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsSysStatusKommunikation
							(daten.
								getUnscaledValue
							("StatusKommunikation").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStatusKommunikation(getStatusKommunikation());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsSysKommunikationsStatus";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsSysKommunikationsStatus(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
