/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
FG 3: ErgebnisMeldung Wasserfilmdicke WFD (FG 3 &#47;
					Typ 72).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							TLS-DE-Block-Struktur im Typ
							72"ErgebnisMeldung Wasserfilmdicke WFD"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsUfdErgebnisMeldungWasserFilmDickeWFD extends AbstractOnlineDatensatz<OdTlsUfdErgebnisMeldungWasserFilmDickeWFD.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdWasserfilmdicke
				 _wasserfilmdicke
				;
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine
								Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD
								oberhalb 2 mm liegt die Messgenauigkeit in der Regel
								im mm Bereich. Die rechnerische Wasserfilmdicke gibt
								die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser
								oder wässriger Lösung (Salzgemisch) an, welche sich
								am Messort bzw. auf der in der Fahrbahn
								eingelassenen Sonde befindet. Die Wasserfilmdicke
								ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@return der Wert von Wasserfilmdicke.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdWasserfilmdicke
				 getWasserfilmdicke() {
				return _wasserfilmdicke;
			}
		
			/**
			Wasserfilmdicke.
			<p>
			Bei WFD oberhalb 0,1 mm wird nur eine
								Messgenauigkeit im 1&#47;10 mm Bereich erreicht. Bei WFD
								oberhalb 2 mm liegt die Messgenauigkeit in der Regel
								im mm Bereich. Die rechnerische Wasserfilmdicke gibt
								die Fahrbahnbenetzung in mm (= Liter&#47;m2 ) mit Wasser
								oder wässriger Lösung (Salzgemisch) an, welche sich
								am Messort bzw. auf der in der Fahrbahn
								eingelassenen Sonde befindet. Die Wasserfilmdicke
								ist immer bezogen auf eine glatte ebene Fläche.
			</p>
			
			@param _wasserfilmdicke der neue Wert von Wasserfilmdicke.
			*/
			public void setWasserfilmdicke(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdWasserfilmdicke
			 _wasserfilmdicke) {
				this._wasserfilmdicke = _wasserfilmdicke;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getWasserfilmdicke() != null) {
		                if (getWasserfilmdicke().isZustand()) {
		                    datum.getUnscaledValue("Wasserfilmdicke").setText(getWasserfilmdicke().toString());
		                } else {
							datum.
							getScaledValue
		                	("Wasserfilmdicke").set(getWasserfilmdicke().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Wasserfilmdicke").isState()) {
								setWasserfilmdicke(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdWasserfilmdicke
								.getZustand(daten.getScaledValue("Wasserfilmdicke").getText()));
							} else {
							setWasserfilmdicke(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdWasserfilmdicke
							(daten.
								getScaledValue
							("Wasserfilmdicke").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setWasserfilmdicke(getWasserfilmdicke());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsUfdErgebnisMeldungWasserFilmDickeWFD";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsUfdErgebnisMeldungWasserFilmDickeWFD(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
