/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
FG 3: ErgebnisMeldung Zeitreserve Glätte ZG (FG 3 &#47;
					Typ 187 ANT-BOSCH-TELEKOM).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							TLS-DE-Block-Struktur im Typ
							72"ErgebnisMeldung Wasserfilmdicke WFD"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsUfdErgebnisMeldungZeitreserveGlaetteZG extends AbstractOnlineDatensatz<OdTlsUfdErgebnisMeldungZeitreserveGlaetteZG.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveReifGlaette
				 _zeitreserveReifGlaette
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveEisGlaette
				 _zeitreserveEisGlaette
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdAlarmGlattEis
				 _alarmGlattEis
				;
		
			/**
			Gibt die Zeit bis zu einer möglichen Reifglätte an.
			<p>
			
			</p>
			
			@return der Wert von ZeitreserveReifGlaette.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveReifGlaette
				 getZeitreserveReifGlaette() {
				return _zeitreserveReifGlaette;
			}
		
			/**
			Gibt die Zeit bis zu einer möglichen Reifglätte an.
			<p>
			
			</p>
			
			@param _zeitreserveReifGlaette der neue Wert von ZeitreserveReifGlaette.
			*/
			public void setZeitreserveReifGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveReifGlaette
			 _zeitreserveReifGlaette) {
				this._zeitreserveReifGlaette = _zeitreserveReifGlaette;
			}
		
			/**
			Gibt die Zeit bis zu einer möglichen Eisglätte an.
			<p>
			
			</p>
			
			@return der Wert von ZeitreserveEisGlaette.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveEisGlaette
				 getZeitreserveEisGlaette() {
				return _zeitreserveEisGlaette;
			}
		
			/**
			Gibt die Zeit bis zu einer möglichen Eisglätte an.
			<p>
			
			</p>
			
			@param _zeitreserveEisGlaette der neue Wert von ZeitreserveEisGlaette.
			*/
			public void setZeitreserveEisGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveEisGlaette
			 _zeitreserveEisGlaette) {
				this._zeitreserveEisGlaette = _zeitreserveEisGlaette;
			}
		
			/**
			Gibt an, ob Glatteisalarm anliegt.
			<p>
			
			</p>
			
			@return der Wert von AlarmGlattEis.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdAlarmGlattEis
				 getAlarmGlattEis() {
				return _alarmGlattEis;
			}
		
			/**
			Gibt an, ob Glatteisalarm anliegt.
			<p>
			
			</p>
			
			@param _alarmGlattEis der neue Wert von AlarmGlattEis.
			*/
			public void setAlarmGlattEis(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdAlarmGlattEis
			 _alarmGlattEis) {
				this._alarmGlattEis = _alarmGlattEis;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getZeitreserveReifGlaette() != null) {
		                if (getZeitreserveReifGlaette().isZustand()) {
		                    datum.getUnscaledValue("ZeitreserveReifGlätte").setText(getZeitreserveReifGlaette().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZeitreserveReifGlätte").set(getZeitreserveReifGlaette().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZeitreserveEisGlaette() != null) {
		                if (getZeitreserveEisGlaette().isZustand()) {
		                    datum.getUnscaledValue("ZeitreserveEisGlätte").setText(getZeitreserveEisGlaette().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZeitreserveEisGlätte").set(getZeitreserveEisGlaette().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAlarmGlattEis() != null) {
		                if (getAlarmGlattEis().isZustand()) {
		                    datum.getUnscaledValue("AlarmGlattEis").setText(getAlarmGlattEis().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AlarmGlattEis").set(getAlarmGlattEis().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZeitreserveReifGlätte").isState()) {
								setZeitreserveReifGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveReifGlaette
								.getZustand(daten.getScaledValue("ZeitreserveReifGlätte").getText()));
							} else {
							setZeitreserveReifGlaette(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveReifGlaette
							(daten.
								getUnscaledValue
							("ZeitreserveReifGlätte").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZeitreserveEisGlätte").isState()) {
								setZeitreserveEisGlaette(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveEisGlaette
								.getZustand(daten.getScaledValue("ZeitreserveEisGlätte").getText()));
							} else {
							setZeitreserveEisGlaette(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdZeitreserveEisGlaette
							(daten.
								getUnscaledValue
							("ZeitreserveEisGlätte").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AlarmGlattEis").isState()) {
								setAlarmGlattEis(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdAlarmGlattEis
								.getZustand(daten.getScaledValue("AlarmGlattEis").getText()));
							} else {
							setAlarmGlattEis(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsUfdAlarmGlattEis
							(daten.
								getUnscaledValue
							("AlarmGlattEis").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZeitreserveReifGlaette(getZeitreserveReifGlaette());
							klon.setZeitreserveEisGlaette(getZeitreserveEisGlaette());
							klon.setAlarmGlattEis(getAlarmGlattEis());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsUfdErgebnisMeldungZeitreserveGlätteZG";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsUfdErgebnisMeldungZeitreserveGlaetteZG(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
