/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Fernüberwachung lokaler Energieversorgung (FG 6 &#47; Typ 57).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 6: DE-Block-Struktur im Typ
							57 "Fernüberwachung lokaler Energieversorgung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Eine spontane Übertragung erfolgt nur nach Änderung der Zustände Überladeschutz,
							Tiefentladungsschutz. In diesen Fällen wird der aktuelle Wert der Ladespannung und des
							Ladestromes übertragen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 24
 */
public class OdTlsVltFernUeberwachungLokalerEnergieversorung extends AbstractOnlineDatensatz<OdTlsVltFernUeberwachungLokalerEnergieversorung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandUeberladeSchutz
				 _energieversorgungZustandUeberladeSchutz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandTiefentladeSchutz
				 _energieversorgungZustandTiefentladeSchutz
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeSpannung
				 _energieversorgungLadeSpannung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeStrom
				 _energieversorgungLadeStrom
				;
		
			/**
			Zustand der Energieversorgung, Überladeschutz.
			<p>
			
			</p>
			
			@return der Wert von EnergieversorgungZustandUeberladeSchutz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandUeberladeSchutz
				 getEnergieversorgungZustandUeberladeSchutz() {
				return _energieversorgungZustandUeberladeSchutz;
			}
		
			/**
			Zustand der Energieversorgung, Überladeschutz.
			<p>
			
			</p>
			
			@param _energieversorgungZustandUeberladeSchutz der neue Wert von EnergieversorgungZustandUeberladeSchutz.
			*/
			public void setEnergieversorgungZustandUeberladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandUeberladeSchutz
			 _energieversorgungZustandUeberladeSchutz) {
				this._energieversorgungZustandUeberladeSchutz = _energieversorgungZustandUeberladeSchutz;
			}
		
			/**
			Zustand der Energieversorgung, Tiefentladeschutz.
			<p>
			
			</p>
			
			@return der Wert von EnergieversorgungZustandTiefentladeSchutz.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandTiefentladeSchutz
				 getEnergieversorgungZustandTiefentladeSchutz() {
				return _energieversorgungZustandTiefentladeSchutz;
			}
		
			/**
			Zustand der Energieversorgung, Tiefentladeschutz.
			<p>
			
			</p>
			
			@param _energieversorgungZustandTiefentladeSchutz der neue Wert von EnergieversorgungZustandTiefentladeSchutz.
			*/
			public void setEnergieversorgungZustandTiefentladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandTiefentladeSchutz
			 _energieversorgungZustandTiefentladeSchutz) {
				this._energieversorgungZustandTiefentladeSchutz = _energieversorgungZustandTiefentladeSchutz;
			}
		
			/**
			Ladespannung der Energieversorgung.
			<p>
			
			</p>
			
			@return der Wert von EnergieversorgungLadeSpannung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeSpannung
				 getEnergieversorgungLadeSpannung() {
				return _energieversorgungLadeSpannung;
			}
		
			/**
			Ladespannung der Energieversorgung.
			<p>
			
			</p>
			
			@param _energieversorgungLadeSpannung der neue Wert von EnergieversorgungLadeSpannung.
			*/
			public void setEnergieversorgungLadeSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeSpannung
			 _energieversorgungLadeSpannung) {
				this._energieversorgungLadeSpannung = _energieversorgungLadeSpannung;
			}
		
			/**
			Ladestrom der Energieversorgung.
			<p>
			
			</p>
			
			@return der Wert von EnergieversorgungLadeStrom.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeStrom
				 getEnergieversorgungLadeStrom() {
				return _energieversorgungLadeStrom;
			}
		
			/**
			Ladestrom der Energieversorgung.
			<p>
			
			</p>
			
			@param _energieversorgungLadeStrom der neue Wert von EnergieversorgungLadeStrom.
			*/
			public void setEnergieversorgungLadeStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeStrom
			 _energieversorgungLadeStrom) {
				this._energieversorgungLadeStrom = _energieversorgungLadeStrom;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getEnergieversorgungZustandUeberladeSchutz() != null) {
		                if (getEnergieversorgungZustandUeberladeSchutz().isZustand()) {
		                    datum.getUnscaledValue("EnergieversorgungZustandÜberladeSchutz").setText(getEnergieversorgungZustandUeberladeSchutz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EnergieversorgungZustandÜberladeSchutz").set(getEnergieversorgungZustandUeberladeSchutz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnergieversorgungZustandTiefentladeSchutz() != null) {
		                if (getEnergieversorgungZustandTiefentladeSchutz().isZustand()) {
		                    datum.getUnscaledValue("EnergieversorgungZustandTiefentladeSchutz").setText(getEnergieversorgungZustandTiefentladeSchutz().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("EnergieversorgungZustandTiefentladeSchutz").set(getEnergieversorgungZustandTiefentladeSchutz().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnergieversorgungLadeSpannung() != null) {
		                if (getEnergieversorgungLadeSpannung().isZustand()) {
		                    datum.getUnscaledValue("EnergieversorgungLadeSpannung").setText(getEnergieversorgungLadeSpannung().toString());
		                } else {
							datum.
							getScaledValue
		                	("EnergieversorgungLadeSpannung").set(getEnergieversorgungLadeSpannung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getEnergieversorgungLadeStrom() != null) {
		                if (getEnergieversorgungLadeStrom().isZustand()) {
		                    datum.getUnscaledValue("EnergieversorgungLadeStrom").setText(getEnergieversorgungLadeStrom().toString());
		                } else {
							datum.
							getScaledValue
		                	("EnergieversorgungLadeStrom").set(getEnergieversorgungLadeStrom().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnergieversorgungZustandÜberladeSchutz").isState()) {
								setEnergieversorgungZustandUeberladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandUeberladeSchutz
								.getZustand(daten.getScaledValue("EnergieversorgungZustandÜberladeSchutz").getText()));
							} else {
							setEnergieversorgungZustandUeberladeSchutz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandUeberladeSchutz
							(daten.
								getUnscaledValue
							("EnergieversorgungZustandÜberladeSchutz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnergieversorgungZustandTiefentladeSchutz").isState()) {
								setEnergieversorgungZustandTiefentladeSchutz(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandTiefentladeSchutz
								.getZustand(daten.getScaledValue("EnergieversorgungZustandTiefentladeSchutz").getText()));
							} else {
							setEnergieversorgungZustandTiefentladeSchutz(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungZustandTiefentladeSchutz
							(daten.
								getUnscaledValue
							("EnergieversorgungZustandTiefentladeSchutz").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnergieversorgungLadeSpannung").isState()) {
								setEnergieversorgungLadeSpannung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeSpannung
								.getZustand(daten.getScaledValue("EnergieversorgungLadeSpannung").getText()));
							} else {
							setEnergieversorgungLadeSpannung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeSpannung
							(daten.
								getScaledValue
							("EnergieversorgungLadeSpannung").
								doubleValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("EnergieversorgungLadeStrom").isState()) {
								setEnergieversorgungLadeStrom(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeStrom
								.getZustand(daten.getScaledValue("EnergieversorgungLadeStrom").getText()));
							} else {
							setEnergieversorgungLadeStrom(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltEnergieversorgungLadeStrom
							(daten.
								getScaledValue
							("EnergieversorgungLadeStrom").
								doubleValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setEnergieversorgungZustandUeberladeSchutz(getEnergieversorgungZustandUeberladeSchutz());
							klon.setEnergieversorgungZustandTiefentladeSchutz(getEnergieversorgungZustandTiefentladeSchutz());
							klon.setEnergieversorgungLadeSpannung(getEnergieversorgungLadeSpannung());
							klon.setEnergieversorgungLadeStrom(getEnergieversorgungLadeStrom());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsVltFernÜberwachungLokalerEnergieversorung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsVltFernUeberwachungLokalerEnergieversorung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
