/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Lüftung (FG 6 &#47; Typ 53).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 6: TLS-DE-Block-Struktur im Typ
							53"Lüftung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 4 (Ergebnisse) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class OdTlsVltLueftung extends AbstractOnlineDatensatz<OdTlsVltLueftung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungStatus
				 _lueftungStatus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungBetriebszustand
				 _lueftungBetriebszustand
				;
		
			/**
			Status der Lüftung.
			<p>
			
			</p>
			
			@return der Wert von LueftungStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungStatus
				 getLueftungStatus() {
				return _lueftungStatus;
			}
		
			/**
			Status der Lüftung.
			<p>
			
			</p>
			
			@param _lueftungStatus der neue Wert von LueftungStatus.
			*/
			public void setLueftungStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungStatus
			 _lueftungStatus) {
				this._lueftungStatus = _lueftungStatus;
			}
		
			/**
			Betriebszustand der Lüftung.
			<p>
			
			</p>
			
			@return der Wert von LueftungBetriebszustand.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungBetriebszustand
				 getLueftungBetriebszustand() {
				return _lueftungBetriebszustand;
			}
		
			/**
			Betriebszustand der Lüftung.
			<p>
			
			</p>
			
			@param _lueftungBetriebszustand der neue Wert von LueftungBetriebszustand.
			*/
			public void setLueftungBetriebszustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungBetriebszustand
			 _lueftungBetriebszustand) {
				this._lueftungBetriebszustand = _lueftungBetriebszustand;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getLueftungStatus() != null) {
		                if (getLueftungStatus().isZustand()) {
		                    datum.getUnscaledValue("LüftungStatus").setText(getLueftungStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LüftungStatus").set(getLueftungStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLueftungBetriebszustand() != null) {
		                if (getLueftungBetriebszustand().isZustand()) {
		                    datum.getUnscaledValue("LüftungBetriebszustand").setText(getLueftungBetriebszustand().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LüftungBetriebszustand").set(getLueftungBetriebszustand().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LüftungStatus").isState()) {
								setLueftungStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungStatus
								.getZustand(daten.getScaledValue("LüftungStatus").getText()));
							} else {
							setLueftungStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungStatus
							(daten.
								getUnscaledValue
							("LüftungStatus").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LüftungBetriebszustand").isState()) {
								setLueftungBetriebszustand(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungBetriebszustand
								.getZustand(daten.getScaledValue("LüftungBetriebszustand").getText()));
							} else {
							setLueftungBetriebszustand(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsVltLueftungBetriebszustand
							(daten.
								getUnscaledValue
							("LüftungBetriebszustand").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setLueftungStatus(getLueftungStatus());
							klon.setLueftungBetriebszustand(getLueftungBetriebszustand());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsVltLüftung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsVltLueftung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
