/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Abruf Pufferinhalt (FG 4 &#47; Typ 20).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 20"Abruf
							Pufferinhalt"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Die Nachricht wird verwendet mit ID 2
							(Statusnachrichten) in Abrufrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht ist nur für den Fehlerfall
							notwendig, dass spontane Nachrichten oder
							Rückmeldungen der WVZSteuerung nicht in der
							archivierenden Zentrale angekommen sind.
							Anhand der Folgenummer im Zeitstempel (Typ
							31) kann die Zentrale eine Lücke in der
							Übertragung erkennen. Mit dieser
							Nachricht"Abruf Pufferinhalt" kann die
							Zentrale die fehlenden Nachrichten aus dem
							Puffer des Quell-EAKs nachfordern,
							vorausgesetzt sie sind noch nicht durch
							neuere Nachrichten überschrieben worden. Das
							Abrufen des Pufferinhaltes bewirkt kein
							Löschen des Puffers und kann wahlfrei (evtl.
							auch mehrmals) anhand der Folgenummer
							geschehen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Wenn mindestens eine der angeforderten
							Nachrichten gesendet werden kann, geschieht
							dies. Erst wenn keine der angeforderten
							Nachrichten im Puffer vorhanden ist, muss
							eine negative Quittung (Typ 16) gesendet
							werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Antworten auf diesen Abruf sind
							Nachrichten aus dem Puffer mit FG 4, ID
							33..37 und tragen die Jobnummer des Abrufs.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgAbrufPufferInhalt extends AbstractOnlineDatensatz<OdTlsWzgAbrufPufferInhalt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAbruf,
				};
			}
	
			/**
			 * Aspekt zum Abruf von TLS-Daten eines DE-Blocks.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAbruf = new Aspekte("TlsAbruf", "asp.tlsAbruf");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl2
				 _startFolgeNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl1
				 _anzahl1
				;
		
			/**
			Anzahl (1-65535).
			<p>
			
			</p>
			
			@return der Wert von StartFolgeNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl2
				 getStartFolgeNummer() {
				return _startFolgeNummer;
			}
		
			/**
			Anzahl (1-65535).
			<p>
			
			</p>
			
			@param _startFolgeNummer der neue Wert von StartFolgeNummer.
			*/
			public void setStartFolgeNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl2
			 _startFolgeNummer) {
				this._startFolgeNummer = _startFolgeNummer;
			}
		
			/**
			Anzahl (1-255).
			<p>
			
			</p>
			
			@return der Wert von Anzahl1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl1
				 getAnzahl1() {
				return _anzahl1;
			}
		
			/**
			Anzahl (1-255).
			<p>
			
			</p>
			
			@param _anzahl1 der neue Wert von Anzahl1.
			*/
			public void setAnzahl1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl1
			 _anzahl1) {
				this._anzahl1 = _anzahl1;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getStartFolgeNummer() != null) {
		                if (getStartFolgeNummer().isZustand()) {
		                    datum.getUnscaledValue("StartFolgeNummer").setText(getStartFolgeNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StartFolgeNummer").set(getStartFolgeNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahl1() != null) {
		                if (getAnzahl1().isZustand()) {
		                    datum.getUnscaledValue("Anzahl1").setText(getAnzahl1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Anzahl1").set(getAnzahl1().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setStartFolgeNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl2
							(daten.
								getUnscaledValue
							("StartFolgeNummer").
									intValue
							()));
					// GanzzahlAttributTyp
							setAnzahl1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAnzahl1
							(daten.
								getUnscaledValue
							("Anzahl1").
									shortValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setStartFolgeNummer(getStartFolgeNummer());
							klon.setAnzahl1(getAnzahl1());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgAbrufPufferInhalt";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgAbrufPufferInhalt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
