/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Defekte LED-Ketten (FG 4 &#47; Typ 5).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 5 "Defekte LED-Ketten"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 1 (Fehler) in Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht meldet den Status von LED-Ketten
							in Wechselzeichengebern bzw. Wechselwegweisern
							und Wechseltextanzeigen nach Anzeigeprinzip b).
							Sie informiert die Unterzentrale über den Defekt
							und nach der Behebung über die Funktionsfähigkeit
							einzelner LED-Ketten. Die interne Zählweise der
							Ketten ist nicht genormt, sie ist den Herstellern
							überlassen. Um Übertragungskapazität zu sparen
							werden nicht immer alle Ketten übertragen sondern
							immer nur alle Ketten von der ersten Kette bis zur
							letzten defekten Kette. Wenn keine defekte Kette
							vorliegt werden auch keine Ketten übertragen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Zusätzlich wird noch eine Information zur Schwere
							des Ausfalls geliefert, um die Notwendigkeit und
							den Zeitrahmen für einen Serviceeinsatz abschätzen
							zu können.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Diese Fehlermeldung informiert über den Ausfall bzw.
							die Wiedereinsatzfähigkeit einzelner Ketten und die
							Schwere des Ausfalls, sie trifft dabei keine direkte
							Aussage über "Nicht darstellbare WVZ" (ID 1, Typ 2).
							Diese werden, falls möglich und projektiert, bei
							Änderung zusätzlich spontan übertragen. Ein sich
							evtl. aus dem Ausfall ergebender geänderter
							Stellzustand &#47; Wechseltext wird ebenfalls getrennt
							als eine eigene Nachricht (mit ID 5, Typ 55) übertragen.
							Die Meldung wird nicht gepuffert und wird daher mit
							Zeitstempel Typ 30 verwendet.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							In der Unterzentrale kann über die Nummer der LED-Kette
							die Zuordnung zum gestörten Anzeigeelement (Ronde, Dreieck,
							Ziffer, Symbol etc.) erfolgen.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 18
 */
public class OdTlsWzgDefekteLEDKetten extends AbstractOnlineDatensatz<OdTlsWzgDefekteLEDKetten.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 _anzeigePrinzip
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLedKettenSchwereDesAusfalls
				 _schwereDesAusfalls
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzahlLedKetten
				 _anzahlVorhandeneLEDKetten
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNummerLedKette
				> _defekteLEDKetten = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNummerLedKette
				>(65536, true);
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von AnzeigePrinzip.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 getAnzeigePrinzip() {
				return _anzeigePrinzip;
			}
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
			*/
			public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip) {
				this._anzeigePrinzip = _anzeigePrinzip;
			}
		
			/**
			Schwere des Ausfalls bei defekten LED-Ketten.
			<p>
			
			</p>
			
			@return der Wert von SchwereDesAusfalls.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLedKettenSchwereDesAusfalls
				 getSchwereDesAusfalls() {
				return _schwereDesAusfalls;
			}
		
			/**
			Schwere des Ausfalls bei defekten LED-Ketten.
			<p>
			
			</p>
			
			@param _schwereDesAusfalls der neue Wert von SchwereDesAusfalls.
			*/
			public void setSchwereDesAusfalls(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLedKettenSchwereDesAusfalls
			 _schwereDesAusfalls) {
				this._schwereDesAusfalls = _schwereDesAusfalls;
			}
		
			/**
			Nummer der LED-Kette (0-65536).
			<p>
			
			</p>
			
			@return der Wert von AnzahlVorhandeneLEDKetten.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzahlLedKetten
				 getAnzahlVorhandeneLEDKetten() {
				return _anzahlVorhandeneLEDKetten;
			}
		
			/**
			Nummer der LED-Kette (0-65536).
			<p>
			
			</p>
			
			@param _anzahlVorhandeneLEDKetten der neue Wert von AnzahlVorhandeneLEDKetten.
			*/
			public void setAnzahlVorhandeneLEDKetten(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzahlLedKetten
			 _anzahlVorhandeneLEDKetten) {
				this._anzahlVorhandeneLEDKetten = _anzahlVorhandeneLEDKetten;
			}
		
			/**
			Array mit Nummern der defekten LED-Ketten (Wertebereich 1-65536).
			<p>
			
			</p>
			
			@return der Wert von DefekteLEDKetten.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNummerLedKette
				> getDefekteLEDKetten() {
				return _defekteLEDKetten;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnzeigePrinzip() != null) {
		                if (getAnzeigePrinzip().isZustand()) {
		                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSchwereDesAusfalls() != null) {
		                if (getSchwereDesAusfalls().isZustand()) {
		                    datum.getUnscaledValue("SchwereDesAusfalls").setText(getSchwereDesAusfalls().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SchwereDesAusfalls").set(getSchwereDesAusfalls().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAnzahlVorhandeneLEDKetten() != null) {
		                if (getAnzahlVorhandeneLEDKetten().isZustand()) {
		                    datum.getUnscaledValue("AnzahlVorhandeneLEDKetten").setText(getAnzahlVorhandeneLEDKetten().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzahlVorhandeneLEDKetten").set(getAnzahlVorhandeneLEDKetten().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDefekteLEDKetten() != null) {
						final Data.NumberArray arrayDefekteLEDKetten = datum.
							getUnscaledArray
							("DefekteLEDKetten");
						arrayDefekteLEDKetten.setLength(getDefekteLEDKetten().size());
						for (int i = 0; i < arrayDefekteLEDKetten.getLength(); ++i) {
							arrayDefekteLEDKetten.getValue(i).set(getDefekteLEDKetten().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
								setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
								.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
							} else {
							setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							(daten.
								getUnscaledValue
							("AnzeigePrinzip").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SchwereDesAusfalls").isState()) {
								setSchwereDesAusfalls(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLedKettenSchwereDesAusfalls
								.getZustand(daten.getScaledValue("SchwereDesAusfalls").getText()));
							} else {
							setSchwereDesAusfalls(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgLedKettenSchwereDesAusfalls
							(daten.
								getUnscaledValue
							("SchwereDesAusfalls").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setAnzahlVorhandeneLEDKetten(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzahlLedKetten
							(daten.
								getUnscaledValue
							("AnzahlVorhandeneLEDKetten").
									intValue
							()));
					// GanzzahlAttributTyp
						final Data.NumberArray arrayDefekteLEDKetten = daten.
							getUnscaledArray
						("DefekteLEDKetten");
		
						for (int i = 0; i < arrayDefekteLEDKetten.getLength(); ++i) {
		                    getDefekteLEDKetten().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgNummerLedKette
		                    (arrayDefekteLEDKetten.
		                    		intValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigePrinzip(getAnzeigePrinzip());
							klon.setSchwereDesAusfalls(getSchwereDesAusfalls());
							klon.setAnzahlVorhandeneLEDKetten(getAnzahlVorhandeneLEDKetten());
						klon._defekteLEDKetten = getDefekteLEDKetten().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgDefekteLEDKetten";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgDefekteLEDKetten(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
