/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Ergänzende DE-Fehlermeldung (FG 4 &#47; Typ 14).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 14"Ergänzende
							DE-Fehlermeldung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 1 (Fehler) oder mit ID
							33 (Fehlermeldungen aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Dieser DE-Block dient zur Meldung von
							Teilstörungen und näheren Erläuterung von
							Störungen, die mit dem DEBlock Typ 1
							gemeldet werden. Bei reinen Teilstörungen
							wird nur der DE-Block 14 gesendet; bei
							Erläuterungen von spontanen
							Störungsmeldungen wird er in einem Telegramm
							mit dem DE-Block Typ 1 gesendet. Er kann
							aber mit der ID 17 in Abrufrichtung einzeln
							abgerufen werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Mit dem DE-Block können unterschiedliche
							Störungen&#47;Teilstörungen gleichzeitig
							gemeldet werden. Ändert sich der Status
							(weitere Störungen&#47;Teilstörung bzw. Behebung
							von Störungen&#47;Teilstörungen) wird ebenfalls
							DE-Block-Typ 14 gesendet. Die spontane
							Meldung wird gepuffert und erfolgt zusammen
							mit dem Zeitstempel (Typ 31).
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgErgaenzendeDeFehlerMeldung extends AbstractOnlineDatensatz<OdTlsWzgErgaenzendeDeFehlerMeldung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 _hersteller
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerTLS
				 _fehlercodesTLS
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerTLS
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerHersteller
				 _fehlercodesHersteller
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerHersteller
				()
				;
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@return der Wert von Hersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
				 getHersteller() {
				return _hersteller;
			}
		
			/**
			Hersteller gemäss TLS.
			<p>
			In der Regel wird bei Fehlermeldungen der Hersteller
								angegeben, der den Fehler erkannt hat, nicht
								derjenige, der für den Fehler verantwortlich ist
			</p>
			
			@param _hersteller der neue Wert von Hersteller.
			*/
			public void setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
			 _hersteller) {
				this._hersteller = _hersteller;
			}
		
			/**
			Ergänzende Fehlerinformationen (TLS-Teil).
			<p>
			Die Information ist bitweise kodiert. Die Bedeutung
								ist in der TLS definiert. Es stehen zur Kodierung
								4x8 Bit = 160 Bit zur Verfügung.
			</p>
			
			@return der Wert von FehlercodesTLS.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerTLS
				 getFehlercodesTLS() {
				return _fehlercodesTLS;
			}
		
			/**
			Ergänzende Fehlerinformationen (TLS-Teil).
			<p>
			Die Information ist bitweise kodiert. Die Bedeutung
								ist in der TLS definiert. Es stehen zur Kodierung
								4x8 Bit = 160 Bit zur Verfügung.
			</p>
			
			@param _fehlercodesTLS der neue Wert von FehlercodesTLS.
			*/
			public void setFehlercodesTLS(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerTLS
			 _fehlercodesTLS) {
				this._fehlercodesTLS = _fehlercodesTLS;
			}
		
			/**
			Ergänzende Fehlerinformationen
								(herstellerspezifisch).
			<p>
			Die Information ist herstellerspezifisch bitweise
								kodiert. Die Bedeutung ist nur dem jeweiligen
								Hersteller bekannt. Es stehen zur Kodierung 20x8 Bit
								= 160 Bit zur Verfügung.
			</p>
			
			@return der Wert von FehlercodesHersteller.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerHersteller
				 getFehlercodesHersteller() {
				return _fehlercodesHersteller;
			}
		
			/**
			Ergänzende Fehlerinformationen
								(herstellerspezifisch).
			<p>
			Die Information ist herstellerspezifisch bitweise
								kodiert. Die Bedeutung ist nur dem jeweiligen
								Hersteller bekannt. Es stehen zur Kodierung 20x8 Bit
								= 160 Bit zur Verfügung.
			</p>
			
			@param _fehlercodesHersteller der neue Wert von FehlercodesHersteller.
			*/
			public void setFehlercodesHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsGloErgaenzendeFehlerHersteller
			 _fehlercodesHersteller) {
				this._fehlercodesHersteller = _fehlercodesHersteller;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getHersteller() != null) {
		                if (getHersteller().isZustand()) {
		                    datum.getUnscaledValue("Hersteller").setText(getHersteller().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Hersteller").set(getHersteller().getValue());
		                }
					}
					// AttributListenDefinition
						getFehlercodesTLS().bean2Atl(datum.getItem("FehlercodesTLS"), factory);
					// AttributListenDefinition
						getFehlercodesHersteller().bean2Atl(datum.getItem("FehlercodesHersteller"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Hersteller").isState()) {
								setHersteller(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
								.getZustand(daten.getScaledValue("Hersteller").getText()));
							} else {
							setHersteller(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHersteller
							(daten.
								getUnscaledValue
							("Hersteller").
									shortValue
							()));
							}
					// AttributListenDefinition
						getFehlercodesTLS().atl2Bean(daten.getItem("FehlercodesTLS"), factory);
					// AttributListenDefinition
						getFehlercodesHersteller().atl2Bean(daten.getItem("FehlercodesHersteller"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setHersteller(getHersteller());
							klon._fehlercodesTLS = getFehlercodesTLS().clone();
							klon._fehlercodesHersteller = getFehlercodesHersteller().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgErgänzendeDeFehlerMeldung";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgErgaenzendeDeFehlerMeldung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
