/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Nicht darstellbare WVZ (FG 4 &#47; Typ 2).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ 2"Nicht
							darstellbare WVZ"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 1 (Fehler) oder mit ID
							33 (Fehlermeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht meldet den Status von nicht
							darstellbaren WVZ-Codes eines
							Wechselzeichengebers nach Anzeigeprinzip b).
							Die Nachricht enthält eine Liste der
							WVZ-Codes, welche nun nicht mehr darstellbar
							sind.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Im Gegensatz zur Meldung"Defekte Lampen" (ID
							1, Typ 3), welche für den Einsatz von
							Servicepersonal notwendig ist, informiert
							diese Fehlermeldung den steuernden Prozess
							in der Zentrale, damit dieser den
							augenblicklichen Funktionsumfang seiner
							Betriebsmittel kennt.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Ein sich evt. aus dem Ausfall ergebender
							geänderter Stellzustand wird getrennt als
							eine eigene Nachricht übertragen (mit ID 5,
							Typ 55 (bei Altanlagen evtl. Typ 48)). Bei
							allen Änderungen (Behebung, Ausfall weiterer
							Zeichen) erfolgt eine erneute Meldung. Nach
							Behebung aller Störungen erfolgt eine
							Gutmeldung mit Anzahl Code-Bytes = 0. Die
							spontane Meldung wird gepuffert und erfolgt
							zusammen mit dem Zeitstempel mit Folgenummer
							(Typ 31).
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgNichtDarstellbareWVZ extends AbstractOnlineDatensatz<OdTlsWzgNichtDarstellbareWVZ.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsAntwort,
				};
			}
	
			/**
			 * Aspekt für Antworten von TLS-Daten eines DE-Blocks
						nach Abruf, nach Pufferabfrage oder spontan.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsAntwort = new Aspekte("TlsAntwort", "asp.tlsAntwort");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
				> _nichtDarstellbareWVZ = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
				>(213, true);
		
			/**
			Gültige WVZ-Code entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von NichtDarstellbareWVZ.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
				> getNichtDarstellbareWVZ() {
				return _nichtDarstellbareWVZ;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getNichtDarstellbareWVZ() != null) {
						final Data.NumberArray arrayNichtDarstellbareWVZ = datum.
							getUnscaledArray
							("NichtDarstellbareWVZ");
						arrayNichtDarstellbareWVZ.setLength(getNichtDarstellbareWVZ().size());
						for (int i = 0; i < arrayNichtDarstellbareWVZ.getLength(); ++i) {
							arrayNichtDarstellbareWVZ.getValue(i).set(getNichtDarstellbareWVZ().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
						final Data.NumberArray arrayNichtDarstellbareWVZ = daten.
							getUnscaledArray
						("NichtDarstellbareWVZ");
		
						for (int i = 0; i < arrayNichtDarstellbareWVZ.getLength(); ++i) {
		                    if (arrayNichtDarstellbareWVZ.getValue(i).isState()) {
		                        getNichtDarstellbareWVZ().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
		                        .getZustand(arrayNichtDarstellbareWVZ.getValue(i).getState().getName()));
		                    } else {
		                    getNichtDarstellbareWVZ().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgWvzCode
		                    (arrayNichtDarstellbareWVZ.
		                    		shortValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
						klon._nichtDarstellbareWVZ = getNichtDarstellbareWVZ().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgNichtDarstellbareWVZ";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgNichtDarstellbareWVZ(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
