/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Stellzustand (FG 4 &#47; Typ 55).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ
							55"Stellzustand"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 5 (Befehl) in Abruf-
							und Antwortrichtung oder mit ID 37
							(Befehlsrückmeldung aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Bei spontaner Meldung des Stellzustands
							(z.B. bei Ausfall oder Abschaltung wegen
							Verstümmelung des WVZs) wird ebenfalls die
							ID 5 in Antwortrichtung verwendet.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt in der Kurzversion
							den Stellcode, welcher auf dem Wzg
							dargestellt wird, bzw. werden soll.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							In der Langversion werden für Wzg nach
							Anzeigeprinzip c) ? e) die Einstellungen
							aller Komponenten (Textzeichen oder
							Anzeigen&#47;Prismen) individuell übertragen.
							Nach erfolgter Zuweisung oder spontan wird
							die Meldung des Stellzustandes in
							Antwortrichtung zusammen mit dem
							DE-Block"Zeitstempel mit Folgenummer" (Typ
							31) gesendet, um in der Zentrale die
							dargestellten Zeichen&#47;Programme mit genauen
							Wechselzeitpunkten dokumentieren zu können.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Das verallgemeinerte Telegramm existiert in
							zwei Versionen, einer Kurzversion der Länge
							5 und einer Langversion mit einer Länge
							größer 6, abhängig vom Anzeigeprinzip des
							adressierten DEs. Die Kurzversion wird
							verwendet, wenn das adressierte DE im
							Programmmodus gesteuert wird, ansonsten wird
							die Langversion verwendet. Felder der
							Langversion sind kursiv beschriftet.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdTlsWzgStellZustand extends AbstractOnlineDatensatz<OdTlsWzgStellZustand.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabeArchiv,
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.tlsVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsVorgabeArchiv");
			
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 _anzeigePrinzip
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				> _wVZAnzeige = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
				> _stellCode = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
				>(1, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
				> _textDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
				>(213, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				> _gruppenDefinition = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				>(106, true);
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@return der Wert von AnzeigePrinzip.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
				 getAnzeigePrinzip() {
				return _anzeigePrinzip;
			}
		
			/**
			Anzeigeprinzip des WZG entsprechend TLS.
			<p>
			
			</p>
			
			@param _anzeigePrinzip der neue Wert von AnzeigePrinzip.
			*/
			public void setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
			 _anzeigePrinzip) {
				this._anzeigePrinzip = _anzeigePrinzip;
			}
		
			/**
			Grundeinstellung für einzelne WZG nach
									Anzeigeprinzip A und B.
			<p>
			
			</p>
			
			@return der Wert von WVZAnzeige.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				> getWVZAnzeige() {
				return _wVZAnzeige;
			}
		
		
			/**
			Grundeinstellung für einzelne Textzeilen,
									Gruppendefinitionen oder bei Clustern nach
									Anzeigeprinzip C, D und E.
			<p>
			
			</p>
			
			@return der Wert von StellCode.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
				> getStellCode() {
				return _stellCode;
			}
		
		
			/**
			Grundeinstellung für Gruppe von WZG bei
									Anzeigeprinzig C und D.
			<p>
			
			</p>
			
			@return der Wert von TextDefinition.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
				> getTextDefinition() {
				return _textDefinition;
			}
		
		
			/**
			Grundeinstellung bei mehreren Gruppen nach
									Anzeigeprinzig E.
			<p>
			
			</p>
			
			@return der Wert von GruppenDefinition.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
				> getGruppenDefinition() {
				return _gruppenDefinition;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getAnzeigePrinzip() != null) {
		                if (getAnzeigePrinzip().isZustand()) {
		                    datum.getUnscaledValue("AnzeigePrinzip").setText(getAnzeigePrinzip().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AnzeigePrinzip").set(getAnzeigePrinzip().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayWVZAnzeige = datum.getArray("WVZAnzeige");
						arrayWVZAnzeige.setLength(getWVZAnzeige().size());
						for (int i = 0; i < arrayWVZAnzeige.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 atl = getWVZAnzeige().get(i);
							atl.bean2Atl(arrayWVZAnzeige.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayStellCode = datum.getArray("StellCode");
						arrayStellCode.setLength(getStellCode().size());
						for (int i = 0; i < arrayStellCode.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
							 atl = getStellCode().get(i);
							atl.bean2Atl(arrayStellCode.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayTextDefinition = datum.getArray("TextDefinition");
						arrayTextDefinition.setLength(getTextDefinition().size());
						for (int i = 0; i < arrayTextDefinition.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
							 atl = getTextDefinition().get(i);
							atl.bean2Atl(arrayTextDefinition.getItem(i), factory);
		
						}
					// AttributListenDefinition
						final Data.Array arrayGruppenDefinition = datum.getArray("GruppenDefinition");
						arrayGruppenDefinition.setLength(getGruppenDefinition().size());
						for (int i = 0; i < arrayGruppenDefinition.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 atl = getGruppenDefinition().get(i);
							atl.bean2Atl(arrayGruppenDefinition.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AnzeigePrinzip").isState()) {
								setAnzeigePrinzip(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
								.getZustand(daten.getScaledValue("AnzeigePrinzip").getText()));
							} else {
							setAnzeigePrinzip(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgAnzeigePrinzip
							(daten.
								getUnscaledValue
							("AnzeigePrinzip").
									byteValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayWVZAnzeige = daten.getArray("WVZAnzeige");
						for (int i = 0; i < arrayWVZAnzeige.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 ();
							atl.atl2Bean(arrayWVZAnzeige.getItem(i), factory);
							getWVZAnzeige().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayStellCode = daten.getArray("StellCode");
						for (int i = 0; i < arrayStellCode.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzStellCode
							 ();
							atl.atl2Bean(arrayStellCode.getItem(i), factory);
							getStellCode().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayTextDefinition = daten.getArray("TextDefinition");
						for (int i = 0; i < arrayTextDefinition.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzTextDefinition
							 ();
							atl.atl2Bean(arrayTextDefinition.getItem(i), factory);
							getTextDefinition().add(atl);
						}
					// AttributListenDefinition
						final Data.Array arrayGruppenDefinition = daten.getArray("GruppenDefinition");
						for (int i = 0; i < arrayGruppenDefinition.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsWzgWvzAnzeige
							 ();
							atl.atl2Bean(arrayGruppenDefinition.getItem(i), factory);
							getGruppenDefinition().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setAnzeigePrinzip(getAnzeigePrinzip());
						klon._wVZAnzeige = getWVZAnzeige().clone();
						klon._stellCode = getStellCode().clone();
						klon._textDefinition = getTextDefinition().clone();
						klon._gruppenDefinition = getGruppenDefinition().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgStellZustand";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdTlsWzgStellZustand(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
