/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsparameter(FG 2 &#47; Typ 32).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ
							32"Betriebsparameter"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt Parameter, welche
							für den Betrieb der
							Achslastdaten-Erfassungsgeräte benötigt
							werden. Die Betriebsparameter werden i.d.R.
							für alle Kanäle einer Richtungsfahrbahn
							gemeinsam verändert.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 10
 */
public class PdTlsAxlBetriebsParameter extends AbstractParameterDatensatz<PdTlsAxlBetriebsParameter.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionErgebnisMeldung
				 _datenversionErgebnisMeldung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlErfassungsintervalldauer
				 _erfassungsintervalldauer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionEinzelErgebnisMeldung
				 _datenversionEinzelErgebnisMeldung
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlSpeicherungImGeraet
				 _speicherungImGeraet
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Der Inhalt des Bytes bestimmt die Version der
								ErgebnisMeldung, die übertragen werden soll. Mit dem
								Wert 255 lässt sich die Übertragung der
								ErgebnisMeldungen abschalten.
			<p>
			
			</p>
			
			@return der Wert von DatenversionErgebnisMeldung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionErgebnisMeldung
				 getDatenversionErgebnisMeldung() {
				return _datenversionErgebnisMeldung;
			}
		
			/**
			Der Inhalt des Bytes bestimmt die Version der
								ErgebnisMeldung, die übertragen werden soll. Mit dem
								Wert 255 lässt sich die Übertragung der
								ErgebnisMeldungen abschalten.
			<p>
			
			</p>
			
			@param _datenversionErgebnisMeldung der neue Wert von DatenversionErgebnisMeldung.
			*/
			public void setDatenversionErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionErgebnisMeldung
			 _datenversionErgebnisMeldung) {
				this._datenversionErgebnisMeldung = _datenversionErgebnisMeldung;
			}
		
			/**
			Erfassungsintervalldauer.
			<p>
			&lt;absatz&gt;
									Byte enthält den Wert der
									Erfassungsintervalldauer in folgenden
									Zeiteinheiten:
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;Bit7 = 1: Einheit = Stunde&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Bit0..6: Zeitwert in Stunden [1..120]
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Es sind nur Stundenwerte zugelassen, die
									ganzzahlige Teiler oder ganzzahlige Mehrfache
									von 24 Stunden sind (1, 2, 3, 4, 6, 8, 12, 24,
									48, 72, 96, 120 Stunden).
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;Bit7 = 0: Einheit = ¼ - Stunde&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Bit0..6: Zeitwert in ¼ -Stunden [1..120]
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Es sind nur ¼ -Stundenwerte zugelassen, die
									ganzzahlige Teiler von 24 Stunden sind (1, 2, 3,
									4, 6, 8, 12, 16, 24, 32,48, 96 ¼ - Stunden)
								&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von Erfassungsintervalldauer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlErfassungsintervalldauer
				 getErfassungsintervalldauer() {
				return _erfassungsintervalldauer;
			}
		
			/**
			Erfassungsintervalldauer.
			<p>
			&lt;absatz&gt;
									Byte enthält den Wert der
									Erfassungsintervalldauer in folgenden
									Zeiteinheiten:
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;Bit7 = 1: Einheit = Stunde&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Bit0..6: Zeitwert in Stunden [1..120]
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Es sind nur Stundenwerte zugelassen, die
									ganzzahlige Teiler oder ganzzahlige Mehrfache
									von 24 Stunden sind (1, 2, 3, 4, 6, 8, 12, 24,
									48, 72, 96, 120 Stunden).
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;Bit7 = 0: Einheit = ¼ - Stunde&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Bit0..6: Zeitwert in ¼ -Stunden [1..120]
								&lt;&#47;absatz&gt;
								&lt;absatz&gt;
									Es sind nur ¼ -Stundenwerte zugelassen, die
									ganzzahlige Teiler von 24 Stunden sind (1, 2, 3,
									4, 6, 8, 12, 16, 24, 32,48, 96 ¼ - Stunden)
								&lt;&#47;absatz&gt;
			</p>
			
			@param _erfassungsintervalldauer der neue Wert von Erfassungsintervalldauer.
			*/
			public void setErfassungsintervalldauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlErfassungsintervalldauer
			 _erfassungsintervalldauer) {
				this._erfassungsintervalldauer = _erfassungsintervalldauer;
			}
		
			/**
			Der Inhalt des Bytes bestimmt die Version der
								Einzelergebnismeldung, die übertragen werden soll.
			<p>
			
			</p>
			
			@return der Wert von DatenversionEinzelErgebnisMeldung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionEinzelErgebnisMeldung
				 getDatenversionEinzelErgebnisMeldung() {
				return _datenversionEinzelErgebnisMeldung;
			}
		
			/**
			Der Inhalt des Bytes bestimmt die Version der
								Einzelergebnismeldung, die übertragen werden soll.
			<p>
			
			</p>
			
			@param _datenversionEinzelErgebnisMeldung der neue Wert von DatenversionEinzelErgebnisMeldung.
			*/
			public void setDatenversionEinzelErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionEinzelErgebnisMeldung
			 _datenversionEinzelErgebnisMeldung) {
				this._datenversionEinzelErgebnisMeldung = _datenversionEinzelErgebnisMeldung;
			}
		
			/**
			Für Sonderuntersuchungen lassen sich im Gerät
								verschiedene Daten speichern, die nicht on-line
								übertragen werden.
			<p>
			
			</p>
			
			@return der Wert von SpeicherungImGeraet.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlSpeicherungImGeraet
				 getSpeicherungImGeraet() {
				return _speicherungImGeraet;
			}
		
			/**
			Für Sonderuntersuchungen lassen sich im Gerät
								verschiedene Daten speichern, die nicht on-line
								übertragen werden.
			<p>
			
			</p>
			
			@param _speicherungImGeraet der neue Wert von SpeicherungImGeraet.
			*/
			public void setSpeicherungImGeraet(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlSpeicherungImGeraet
			 _speicherungImGeraet) {
				this._speicherungImGeraet = _speicherungImGeraet;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getDatenversionErgebnisMeldung() != null) {
		                if (getDatenversionErgebnisMeldung().isZustand()) {
		                    datum.getUnscaledValue("DatenversionErgebnisMeldung").setText(getDatenversionErgebnisMeldung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DatenversionErgebnisMeldung").set(getDatenversionErgebnisMeldung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getErfassungsintervalldauer() != null) {
		                if (getErfassungsintervalldauer().isZustand()) {
		                    datum.getUnscaledValue("Erfassungsintervalldauer").setText(getErfassungsintervalldauer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Erfassungsintervalldauer").set(getErfassungsintervalldauer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getDatenversionEinzelErgebnisMeldung() != null) {
		                if (getDatenversionEinzelErgebnisMeldung().isZustand()) {
		                    datum.getUnscaledValue("DatenversionEinzelErgebnisMeldung").setText(getDatenversionEinzelErgebnisMeldung().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DatenversionEinzelErgebnisMeldung").set(getDatenversionEinzelErgebnisMeldung().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getSpeicherungImGeraet() != null) {
		                if (getSpeicherungImGeraet().isZustand()) {
		                    datum.getUnscaledValue("SpeicherungImGerät").setText(getSpeicherungImGeraet().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("SpeicherungImGerät").set(getSpeicherungImGeraet().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DatenversionErgebnisMeldung").isState()) {
								setDatenversionErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionErgebnisMeldung
								.getZustand(daten.getScaledValue("DatenversionErgebnisMeldung").getText()));
							} else {
							setDatenversionErgebnisMeldung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionErgebnisMeldung
							(daten.
								getUnscaledValue
							("DatenversionErgebnisMeldung").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("Erfassungsintervalldauer").isState()) {
								setErfassungsintervalldauer(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlErfassungsintervalldauer
								.getZustand(daten.getScaledValue("Erfassungsintervalldauer").getText()));
							} else {
							setErfassungsintervalldauer(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlErfassungsintervalldauer
							(daten.
								getUnscaledValue
							("Erfassungsintervalldauer").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DatenversionEinzelErgebnisMeldung").isState()) {
								setDatenversionEinzelErgebnisMeldung(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionEinzelErgebnisMeldung
								.getZustand(daten.getScaledValue("DatenversionEinzelErgebnisMeldung").getText()));
							} else {
							setDatenversionEinzelErgebnisMeldung(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlDatenversionEinzelErgebnisMeldung
							(daten.
								getUnscaledValue
							("DatenversionEinzelErgebnisMeldung").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("SpeicherungImGerät").isState()) {
								setSpeicherungImGeraet(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlSpeicherungImGeraet
								.getZustand(daten.getScaledValue("SpeicherungImGerät").getText()));
							} else {
							setSpeicherungImGeraet(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsAxlSpeicherungImGeraet
							(daten.
								getUnscaledValue
							("SpeicherungImGerät").
									byteValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setDatenversionErgebnisMeldung(getDatenversionErgebnisMeldung());
							klon.setErfassungsintervalldauer(getErfassungsintervalldauer());
							klon.setDatenversionEinzelErgebnisMeldung(getDatenversionEinzelErgebnisMeldung());
							klon.setSpeicherungImGeraet(getSpeicherungImGeraet());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlBetriebsParameter";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsAxlBetriebsParameter(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
