/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Grenzwerte für Achslasten und Gesamtgewichte
					(Überladung) (FG 2 &#47; Typ 37).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ 37"Grenzwerte
							für Achslasten und Gesamtgewichte
							(Überladung)"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt Parameter, welche
							für die Ermittlung von Achsüberlastungen und
							von Überschreitung von Gesamtgewichten
							benötigt werden. Die Grenzen werden gemäß
							der gültigen StVZO festgelegt.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 14
 */
public class PdTlsAxlGrenzWerteFuerAchsLastenUndGesamtGewichteUeberladung extends AbstractParameterDatensatz<PdTlsAxlGrenzWerteFuerAchsLastenUndGesamtGewichteUeberladung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxEinzelachlastErsteAchse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxEinzelachlast
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 _maxAchsabstandDoppelAchse1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxDoppelachlastAchsabstand1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 _maxAchsabstandDoppelAchse2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxDoppelachlastAchsabstand2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 _maxAchsabstandDoppelAchse3
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxDoppelachlastAchsabstand3
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 _maxAchsabstandDreifachAchse1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxDreifachachlastAchsabstand1
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 _maxAchsabstandDreifachAchse2
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 _maxDreifachachlastAchsabstand2
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
				> _gesamtgewichtFahrzeugtypen = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
				>(65, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxEinzelachlastErsteAchse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxEinzelachlastErsteAchse() {
				return _maxEinzelachlastErsteAchse;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxEinzelachlastErsteAchse der neue Wert von MaxEinzelachlastErsteAchse.
			*/
			public void setMaxEinzelachlastErsteAchse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxEinzelachlastErsteAchse) {
				this._maxEinzelachlastErsteAchse = _maxEinzelachlastErsteAchse;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxEinzelachlast.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxEinzelachlast() {
				return _maxEinzelachlast;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxEinzelachlast der neue Wert von MaxEinzelachlast.
			*/
			public void setMaxEinzelachlast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxEinzelachlast) {
				this._maxEinzelachlast = _maxEinzelachlast;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@return der Wert von MaxAchsabstandDoppelAchse1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 getMaxAchsabstandDoppelAchse1() {
				return _maxAchsabstandDoppelAchse1;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@param _maxAchsabstandDoppelAchse1 der neue Wert von MaxAchsabstandDoppelAchse1.
			*/
			public void setMaxAchsabstandDoppelAchse1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
			 _maxAchsabstandDoppelAchse1) {
				this._maxAchsabstandDoppelAchse1 = _maxAchsabstandDoppelAchse1;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxDoppelachlastAchsabstand1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxDoppelachlastAchsabstand1() {
				return _maxDoppelachlastAchsabstand1;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxDoppelachlastAchsabstand1 der neue Wert von MaxDoppelachlastAchsabstand1.
			*/
			public void setMaxDoppelachlastAchsabstand1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxDoppelachlastAchsabstand1) {
				this._maxDoppelachlastAchsabstand1 = _maxDoppelachlastAchsabstand1;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@return der Wert von MaxAchsabstandDoppelAchse2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 getMaxAchsabstandDoppelAchse2() {
				return _maxAchsabstandDoppelAchse2;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@param _maxAchsabstandDoppelAchse2 der neue Wert von MaxAchsabstandDoppelAchse2.
			*/
			public void setMaxAchsabstandDoppelAchse2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
			 _maxAchsabstandDoppelAchse2) {
				this._maxAchsabstandDoppelAchse2 = _maxAchsabstandDoppelAchse2;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxDoppelachlastAchsabstand2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxDoppelachlastAchsabstand2() {
				return _maxDoppelachlastAchsabstand2;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxDoppelachlastAchsabstand2 der neue Wert von MaxDoppelachlastAchsabstand2.
			*/
			public void setMaxDoppelachlastAchsabstand2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxDoppelachlastAchsabstand2) {
				this._maxDoppelachlastAchsabstand2 = _maxDoppelachlastAchsabstand2;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@return der Wert von MaxAchsabstandDoppelAchse3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 getMaxAchsabstandDoppelAchse3() {
				return _maxAchsabstandDoppelAchse3;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@param _maxAchsabstandDoppelAchse3 der neue Wert von MaxAchsabstandDoppelAchse3.
			*/
			public void setMaxAchsabstandDoppelAchse3(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
			 _maxAchsabstandDoppelAchse3) {
				this._maxAchsabstandDoppelAchse3 = _maxAchsabstandDoppelAchse3;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxDoppelachlastAchsabstand3.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxDoppelachlastAchsabstand3() {
				return _maxDoppelachlastAchsabstand3;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxDoppelachlastAchsabstand3 der neue Wert von MaxDoppelachlastAchsabstand3.
			*/
			public void setMaxDoppelachlastAchsabstand3(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxDoppelachlastAchsabstand3) {
				this._maxDoppelachlastAchsabstand3 = _maxDoppelachlastAchsabstand3;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@return der Wert von MaxAchsabstandDreifachAchse1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 getMaxAchsabstandDreifachAchse1() {
				return _maxAchsabstandDreifachAchse1;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@param _maxAchsabstandDreifachAchse1 der neue Wert von MaxAchsabstandDreifachAchse1.
			*/
			public void setMaxAchsabstandDreifachAchse1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
			 _maxAchsabstandDreifachAchse1) {
				this._maxAchsabstandDreifachAchse1 = _maxAchsabstandDreifachAchse1;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxDreifachachlastAchsabstand1.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxDreifachachlastAchsabstand1() {
				return _maxDreifachachlastAchsabstand1;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxDreifachachlastAchsabstand1 der neue Wert von MaxDreifachachlastAchsabstand1.
			*/
			public void setMaxDreifachachlastAchsabstand1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxDreifachachlastAchsabstand1) {
				this._maxDreifachachlastAchsabstand1 = _maxDreifachachlastAchsabstand1;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@return der Wert von MaxAchsabstandDreifachAchse2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
				 getMaxAchsabstandDreifachAchse2() {
				return _maxAchsabstandDreifachAchse2;
			}
		
			/**
			Längenangaben gemäß TLS 0..254 cm.
			<p>
			
			</p>
			
			@param _maxAchsabstandDreifachAchse2 der neue Wert von MaxAchsabstandDreifachAchse2.
			*/
			public void setMaxAchsabstandDreifachAchse2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
			 _maxAchsabstandDreifachAchse2) {
				this._maxAchsabstandDreifachAchse2 = _maxAchsabstandDreifachAchse2;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von MaxDreifachachlastAchsabstand2.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				 getMaxDreifachachlastAchsabstand2() {
				return _maxDreifachachlastAchsabstand2;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@param _maxDreifachachlastAchsabstand2 der neue Wert von MaxDreifachachlastAchsabstand2.
			*/
			public void setMaxDreifachachlastAchsabstand2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
			 _maxDreifachachlastAchsabstand2) {
				this._maxDreifachachlastAchsabstand2 = _maxDreifachachlastAchsabstand2;
			}
		
			/**
			Höchstzullässiges Gesamtgewicht für Fahrzeugtypen
								bei der Achslasterfassung.
			<p>
			
			</p>
			
			@return der Wert von GesamtgewichtFahrzeugtypen.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
				> getGesamtgewichtFahrzeugtypen() {
				return _gesamtgewichtFahrzeugtypen;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getMaxEinzelachlastErsteAchse() != null) {
		                if (getMaxEinzelachlastErsteAchse().isZustand()) {
		                    datum.getUnscaledValue("MaxEinzelachlastErsteAchse").setText(getMaxEinzelachlastErsteAchse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxEinzelachlastErsteAchse").set(getMaxEinzelachlastErsteAchse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxEinzelachlast() != null) {
		                if (getMaxEinzelachlast().isZustand()) {
		                    datum.getUnscaledValue("MaxEinzelachlast").setText(getMaxEinzelachlast().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxEinzelachlast").set(getMaxEinzelachlast().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAchsabstandDoppelAchse1() != null) {
		                if (getMaxAchsabstandDoppelAchse1().isZustand()) {
		                    datum.getUnscaledValue("MaxAchsabstandDoppelAchse1").setText(getMaxAchsabstandDoppelAchse1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAchsabstandDoppelAchse1").set(getMaxAchsabstandDoppelAchse1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxDoppelachlastAchsabstand1() != null) {
		                if (getMaxDoppelachlastAchsabstand1().isZustand()) {
		                    datum.getUnscaledValue("MaxDoppelachlastAchsabstand1").setText(getMaxDoppelachlastAchsabstand1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxDoppelachlastAchsabstand1").set(getMaxDoppelachlastAchsabstand1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAchsabstandDoppelAchse2() != null) {
		                if (getMaxAchsabstandDoppelAchse2().isZustand()) {
		                    datum.getUnscaledValue("MaxAchsabstandDoppelAchse2").setText(getMaxAchsabstandDoppelAchse2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAchsabstandDoppelAchse2").set(getMaxAchsabstandDoppelAchse2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxDoppelachlastAchsabstand2() != null) {
		                if (getMaxDoppelachlastAchsabstand2().isZustand()) {
		                    datum.getUnscaledValue("MaxDoppelachlastAchsabstand2").setText(getMaxDoppelachlastAchsabstand2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxDoppelachlastAchsabstand2").set(getMaxDoppelachlastAchsabstand2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAchsabstandDoppelAchse3() != null) {
		                if (getMaxAchsabstandDoppelAchse3().isZustand()) {
		                    datum.getUnscaledValue("MaxAchsabstandDoppelAchse3").setText(getMaxAchsabstandDoppelAchse3().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAchsabstandDoppelAchse3").set(getMaxAchsabstandDoppelAchse3().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxDoppelachlastAchsabstand3() != null) {
		                if (getMaxDoppelachlastAchsabstand3().isZustand()) {
		                    datum.getUnscaledValue("MaxDoppelachlastAchsabstand3").setText(getMaxDoppelachlastAchsabstand3().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxDoppelachlastAchsabstand3").set(getMaxDoppelachlastAchsabstand3().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAchsabstandDreifachAchse1() != null) {
		                if (getMaxAchsabstandDreifachAchse1().isZustand()) {
		                    datum.getUnscaledValue("MaxAchsabstandDreifachAchse1").setText(getMaxAchsabstandDreifachAchse1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAchsabstandDreifachAchse1").set(getMaxAchsabstandDreifachAchse1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxDreifachachlastAchsabstand1() != null) {
		                if (getMaxDreifachachlastAchsabstand1().isZustand()) {
		                    datum.getUnscaledValue("MaxDreifachachlastAchsabstand1").setText(getMaxDreifachachlastAchsabstand1().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxDreifachachlastAchsabstand1").set(getMaxDreifachachlastAchsabstand1().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxAchsabstandDreifachAchse2() != null) {
		                if (getMaxAchsabstandDreifachAchse2().isZustand()) {
		                    datum.getUnscaledValue("MaxAchsabstandDreifachAchse2").setText(getMaxAchsabstandDreifachAchse2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxAchsabstandDreifachAchse2").set(getMaxAchsabstandDreifachAchse2().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getMaxDreifachachlastAchsabstand2() != null) {
		                if (getMaxDreifachachlastAchsabstand2().isZustand()) {
		                    datum.getUnscaledValue("MaxDreifachachlastAchsabstand2").setText(getMaxDreifachachlastAchsabstand2().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("MaxDreifachachlastAchsabstand2").set(getMaxDreifachachlastAchsabstand2().getValue());
		                }
					}
					// AttributListenDefinition
						final Data.Array arrayGesamtgewichtFahrzeugtypen = datum.getArray("GesamtgewichtFahrzeugtypen");
						arrayGesamtgewichtFahrzeugtypen.setLength(getGesamtgewichtFahrzeugtypen().size());
						for (int i = 0; i < arrayGesamtgewichtFahrzeugtypen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
							 atl = getGesamtgewichtFahrzeugtypen().get(i);
							atl.bean2Atl(arrayGesamtgewichtFahrzeugtypen.getItem(i), factory);
		
						}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxEinzelachlastErsteAchse").isState()) {
								setMaxEinzelachlastErsteAchse(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxEinzelachlastErsteAchse").getText()));
							} else {
							setMaxEinzelachlastErsteAchse(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxEinzelachlastErsteAchse").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxEinzelachlast").isState()) {
								setMaxEinzelachlast(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxEinzelachlast").getText()));
							} else {
							setMaxEinzelachlast(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxEinzelachlast").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAchsabstandDoppelAchse1").isState()) {
								setMaxAchsabstandDoppelAchse1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
								.getZustand(daten.getScaledValue("MaxAchsabstandDoppelAchse1").getText()));
							} else {
							setMaxAchsabstandDoppelAchse1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
							(daten.
								getUnscaledValue
							("MaxAchsabstandDoppelAchse1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxDoppelachlastAchsabstand1").isState()) {
								setMaxDoppelachlastAchsabstand1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxDoppelachlastAchsabstand1").getText()));
							} else {
							setMaxDoppelachlastAchsabstand1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxDoppelachlastAchsabstand1").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAchsabstandDoppelAchse2").isState()) {
								setMaxAchsabstandDoppelAchse2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
								.getZustand(daten.getScaledValue("MaxAchsabstandDoppelAchse2").getText()));
							} else {
							setMaxAchsabstandDoppelAchse2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
							(daten.
								getUnscaledValue
							("MaxAchsabstandDoppelAchse2").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxDoppelachlastAchsabstand2").isState()) {
								setMaxDoppelachlastAchsabstand2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxDoppelachlastAchsabstand2").getText()));
							} else {
							setMaxDoppelachlastAchsabstand2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxDoppelachlastAchsabstand2").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAchsabstandDoppelAchse3").isState()) {
								setMaxAchsabstandDoppelAchse3(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
								.getZustand(daten.getScaledValue("MaxAchsabstandDoppelAchse3").getText()));
							} else {
							setMaxAchsabstandDoppelAchse3(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
							(daten.
								getUnscaledValue
							("MaxAchsabstandDoppelAchse3").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxDoppelachlastAchsabstand3").isState()) {
								setMaxDoppelachlastAchsabstand3(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxDoppelachlastAchsabstand3").getText()));
							} else {
							setMaxDoppelachlastAchsabstand3(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxDoppelachlastAchsabstand3").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAchsabstandDreifachAchse1").isState()) {
								setMaxAchsabstandDreifachAchse1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
								.getZustand(daten.getScaledValue("MaxAchsabstandDreifachAchse1").getText()));
							} else {
							setMaxAchsabstandDreifachAchse1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
							(daten.
								getUnscaledValue
							("MaxAchsabstandDreifachAchse1").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxDreifachachlastAchsabstand1").isState()) {
								setMaxDreifachachlastAchsabstand1(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxDreifachachlastAchsabstand1").getText()));
							} else {
							setMaxDreifachachlastAchsabstand1(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxDreifachachlastAchsabstand1").
									intValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxAchsabstandDreifachAchse2").isState()) {
								setMaxAchsabstandDreifachAchse2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
								.getZustand(daten.getScaledValue("MaxAchsabstandDreifachAchse2").getText()));
							} else {
							setMaxAchsabstandDreifachAchse2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLaenge1
							(daten.
								getUnscaledValue
							("MaxAchsabstandDreifachAchse2").
									shortValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("MaxDreifachachlastAchsabstand2").isState()) {
								setMaxDreifachachlastAchsabstand2(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
								.getZustand(daten.getScaledValue("MaxDreifachachlastAchsabstand2").getText()));
							} else {
							setMaxDreifachachlastAchsabstand2(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
							(daten.
								getUnscaledValue
							("MaxDreifachachlastAchsabstand2").
									intValue
							()));
							}
					// AttributListenDefinition
						final Data.Array arrayGesamtgewichtFahrzeugtypen = daten.getArray("GesamtgewichtFahrzeugtypen");
						for (int i = 0; i < arrayGesamtgewichtFahrzeugtypen.getLength(); ++i) {
							de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
							 atl = new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AtlTlsAxlGesamtgewichtFahrzeugtypen
							 ();
							atl.atl2Bean(arrayGesamtgewichtFahrzeugtypen.getItem(i), factory);
							getGesamtgewichtFahrzeugtypen().add(atl);
						}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setMaxEinzelachlastErsteAchse(getMaxEinzelachlastErsteAchse());
							klon.setMaxEinzelachlast(getMaxEinzelachlast());
							klon.setMaxAchsabstandDoppelAchse1(getMaxAchsabstandDoppelAchse1());
							klon.setMaxDoppelachlastAchsabstand1(getMaxDoppelachlastAchsabstand1());
							klon.setMaxAchsabstandDoppelAchse2(getMaxAchsabstandDoppelAchse2());
							klon.setMaxDoppelachlastAchsabstand2(getMaxDoppelachlastAchsabstand2());
							klon.setMaxAchsabstandDoppelAchse3(getMaxAchsabstandDoppelAchse3());
							klon.setMaxDoppelachlastAchsabstand3(getMaxDoppelachlastAchsabstand3());
							klon.setMaxAchsabstandDreifachAchse1(getMaxAchsabstandDreifachAchse1());
							klon.setMaxDreifachachlastAchsabstand1(getMaxDreifachachlastAchsabstand1());
							klon.setMaxAchsabstandDreifachAchse2(getMaxAchsabstandDreifachAchse2());
							klon.setMaxDreifachachlastAchsabstand2(getMaxDreifachachlastAchsabstand2());
						klon._gesamtgewichtFahrzeugtypen = getGesamtgewichtFahrzeugtypen().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlGrenzWerteFürAchsLastenUndGesamtGewichteÜberladung";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsAxlGrenzWerteFuerAchsLastenUndGesamtGewichteUeberladung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
