/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Achs-&#47;Gewichtsklassen (FG 2 &#47; Typ 38).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 2: DE-Block-Struktur im Typ 38"Parameter
							für Achslast- und Gewichtsklassen bei
							Langzeitdaten"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Diese Nachricht überträgt die Konfiguration
							der Gewichtsklassen, welche für die
							Datenversion 10 benötigt werden.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdTlsAxlParameterFuerAchsUndGewichtsKlassen extends AbstractParameterDatensatz<PdTlsAxlParameterFuerAchsUndGewichtsKlassen.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtEinzelachslast = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(12, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtDoppelachslast = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(9, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtDreifachachslast = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(10, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtGesamtFahrzeugKlasse3 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(9, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtGesamtFahrzeugKlasse4 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(9, true);
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> _grenzgewichtGesamtFahrzeugKlasse5 = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				>(9, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtEinzelachslast.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtEinzelachslast() {
				return _grenzgewichtEinzelachslast;
			}
		
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtDoppelachslast.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtDoppelachslast() {
				return _grenzgewichtDoppelachslast;
			}
		
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtDreifachachslast.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtDreifachachslast() {
				return _grenzgewichtDreifachachslast;
			}
		
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtGesamtFahrzeugKlasse3.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtGesamtFahrzeugKlasse3() {
				return _grenzgewichtGesamtFahrzeugKlasse3;
			}
		
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtGesamtFahrzeugKlasse4.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtGesamtFahrzeugKlasse4() {
				return _grenzgewichtGesamtFahrzeugKlasse4;
			}
		
		
			/**
			Gewichtsangabe gemäß TLS 0..65534 kg.
			<p>
			
			</p>
			
			@return der Wert von GrenzgewichtGesamtFahrzeugKlasse5.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
				> getGrenzgewichtGesamtFahrzeugKlasse5() {
				return _grenzgewichtGesamtFahrzeugKlasse5;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getGrenzgewichtEinzelachslast() != null) {
						final Data.NumberArray arrayGrenzgewichtEinzelachslast = datum.
							getUnscaledArray
							("GrenzgewichtEinzelachslast");
						arrayGrenzgewichtEinzelachslast.setLength(getGrenzgewichtEinzelachslast().size());
						for (int i = 0; i < arrayGrenzgewichtEinzelachslast.getLength(); ++i) {
							arrayGrenzgewichtEinzelachslast.getValue(i).set(getGrenzgewichtEinzelachslast().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getGrenzgewichtDoppelachslast() != null) {
						final Data.NumberArray arrayGrenzgewichtDoppelachslast = datum.
							getUnscaledArray
							("GrenzgewichtDoppelachslast");
						arrayGrenzgewichtDoppelachslast.setLength(getGrenzgewichtDoppelachslast().size());
						for (int i = 0; i < arrayGrenzgewichtDoppelachslast.getLength(); ++i) {
							arrayGrenzgewichtDoppelachslast.getValue(i).set(getGrenzgewichtDoppelachslast().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getGrenzgewichtDreifachachslast() != null) {
						final Data.NumberArray arrayGrenzgewichtDreifachachslast = datum.
							getUnscaledArray
							("GrenzgewichtDreifachachslast");
						arrayGrenzgewichtDreifachachslast.setLength(getGrenzgewichtDreifachachslast().size());
						for (int i = 0; i < arrayGrenzgewichtDreifachachslast.getLength(); ++i) {
							arrayGrenzgewichtDreifachachslast.getValue(i).set(getGrenzgewichtDreifachachslast().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getGrenzgewichtGesamtFahrzeugKlasse3() != null) {
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse3 = datum.
							getUnscaledArray
							("GrenzgewichtGesamtFahrzeugKlasse3");
						arrayGrenzgewichtGesamtFahrzeugKlasse3.setLength(getGrenzgewichtGesamtFahrzeugKlasse3().size());
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse3.getLength(); ++i) {
							arrayGrenzgewichtGesamtFahrzeugKlasse3.getValue(i).set(getGrenzgewichtGesamtFahrzeugKlasse3().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getGrenzgewichtGesamtFahrzeugKlasse4() != null) {
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse4 = datum.
							getUnscaledArray
							("GrenzgewichtGesamtFahrzeugKlasse4");
						arrayGrenzgewichtGesamtFahrzeugKlasse4.setLength(getGrenzgewichtGesamtFahrzeugKlasse4().size());
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse4.getLength(); ++i) {
							arrayGrenzgewichtGesamtFahrzeugKlasse4.getValue(i).set(getGrenzgewichtGesamtFahrzeugKlasse4().get(i).getValue());
						}
					}
					// GanzzahlAttributTyp
					if (getGrenzgewichtGesamtFahrzeugKlasse5() != null) {
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse5 = datum.
							getUnscaledArray
							("GrenzgewichtGesamtFahrzeugKlasse5");
						arrayGrenzgewichtGesamtFahrzeugKlasse5.setLength(getGrenzgewichtGesamtFahrzeugKlasse5().size());
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse5.getLength(); ++i) {
							arrayGrenzgewichtGesamtFahrzeugKlasse5.getValue(i).set(getGrenzgewichtGesamtFahrzeugKlasse5().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtEinzelachslast = daten.
							getUnscaledArray
						("GrenzgewichtEinzelachslast");
		
						for (int i = 0; i < arrayGrenzgewichtEinzelachslast.getLength(); ++i) {
		                    if (arrayGrenzgewichtEinzelachslast.getValue(i).isState()) {
		                        getGrenzgewichtEinzelachslast().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtEinzelachslast.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtEinzelachslast().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtEinzelachslast.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtDoppelachslast = daten.
							getUnscaledArray
						("GrenzgewichtDoppelachslast");
		
						for (int i = 0; i < arrayGrenzgewichtDoppelachslast.getLength(); ++i) {
		                    if (arrayGrenzgewichtDoppelachslast.getValue(i).isState()) {
		                        getGrenzgewichtDoppelachslast().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtDoppelachslast.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtDoppelachslast().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtDoppelachslast.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtDreifachachslast = daten.
							getUnscaledArray
						("GrenzgewichtDreifachachslast");
		
						for (int i = 0; i < arrayGrenzgewichtDreifachachslast.getLength(); ++i) {
		                    if (arrayGrenzgewichtDreifachachslast.getValue(i).isState()) {
		                        getGrenzgewichtDreifachachslast().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtDreifachachslast.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtDreifachachslast().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtDreifachachslast.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse3 = daten.
							getUnscaledArray
						("GrenzgewichtGesamtFahrzeugKlasse3");
		
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse3.getLength(); ++i) {
		                    if (arrayGrenzgewichtGesamtFahrzeugKlasse3.getValue(i).isState()) {
		                        getGrenzgewichtGesamtFahrzeugKlasse3().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtGesamtFahrzeugKlasse3.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtGesamtFahrzeugKlasse3().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtGesamtFahrzeugKlasse3.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse4 = daten.
							getUnscaledArray
						("GrenzgewichtGesamtFahrzeugKlasse4");
		
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse4.getLength(); ++i) {
		                    if (arrayGrenzgewichtGesamtFahrzeugKlasse4.getValue(i).isState()) {
		                        getGrenzgewichtGesamtFahrzeugKlasse4().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtGesamtFahrzeugKlasse4.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtGesamtFahrzeugKlasse4().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtGesamtFahrzeugKlasse4.
		                    		intValue
		                    (i)));
		                    }
		                }
					// GanzzahlAttributTyp
						final Data.NumberArray arrayGrenzgewichtGesamtFahrzeugKlasse5 = daten.
							getUnscaledArray
						("GrenzgewichtGesamtFahrzeugKlasse5");
		
						for (int i = 0; i < arrayGrenzgewichtGesamtFahrzeugKlasse5.getLength(); ++i) {
		                    if (arrayGrenzgewichtGesamtFahrzeugKlasse5.getValue(i).isState()) {
		                        getGrenzgewichtGesamtFahrzeugKlasse5().add(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                        .getZustand(arrayGrenzgewichtGesamtFahrzeugKlasse5.getValue(i).getState().getName()));
		                    } else {
		                    getGrenzgewichtGesamtFahrzeugKlasse5().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsGewicht2
		                    (arrayGrenzgewichtGesamtFahrzeugKlasse5.
		                    		intValue
		                    (i)));
		                    }
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._grenzgewichtEinzelachslast = getGrenzgewichtEinzelachslast().clone();
						klon._grenzgewichtDoppelachslast = getGrenzgewichtDoppelachslast().clone();
						klon._grenzgewichtDreifachachslast = getGrenzgewichtDreifachachslast().clone();
						klon._grenzgewichtGesamtFahrzeugKlasse3 = getGrenzgewichtGesamtFahrzeugKlasse3().clone();
						klon._grenzgewichtGesamtFahrzeugKlasse4 = getGrenzgewichtGesamtFahrzeugKlasse4().clone();
						klon._grenzgewichtGesamtFahrzeugKlasse5 = getGrenzgewichtGesamtFahrzeugKlasse5().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsAxlParameterFürAchsUndGewichtsKlassen";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsAxlParameterFuerAchsUndGewichtsKlassen(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
