/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Kanalsteuerung (FG alle &#47; Typ 29).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 1: DE-Block-Struktur im Typ
							29"Kanalsteuerung"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 2 (Statusnachrichten)
							in Abruf- und Antwortrichtung oder mit ID 34
							(Statusnachricht aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der DE-Block"Kanalsteuerung" beeinflusst die
							Betriebsweise eines DEs. Bisher sind nur die
							beiden Betriebsweisen"Normalbetrieb"
							und"Passiv" vorgesehen. Über die
							Betriebsweise"Passiv" ist das Passivieren
							eines Kanals möglich.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Funktion ist grundsätzlich für alle DEs
							vorgesehen, mit Ausnahme der Systemkanäle
							(FG 254). Sie dient insbesondere zum
							Abschalten von Kanälen, die Flattermeldungen
							produzieren oder aufgrund von Baustellen
							etc. nicht verwendet werden. Der
							Zustand"Passiv" muss spannungsausfallsicher
							abgelegt sein. Reaktionen eines passivierten
							Kanals (
							&lt;verweis pid="KanalsteuerungFG4" txt="Spezielles Verhalten in der FG4"&gt;&lt;&#47;verweis&gt;

							):
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- spontan entstehende DE-Fehlermeldung (Typ
							1): keine Reaktion
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- DE-Fehlermeldung (Typ 1) im
							Initialisierungsablauf normale Meldung
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Abfrage DE-Fehlermeldungen (Typ 1):
							normale Antwort
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Fehlermeldung im Initialisierungsablauf
							(außer Typ 1) keine Reaktion
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- spontan entstehende Fehlermeldung keine
							Reaktion
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Abfrage Fehlermeldungen (außer Typ 1)
							keine Reaktion1
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- spontan entstehende Anwenderdaten keine
							Reaktion
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Anwenderdaten im Initialisierungsablauf 2
							keine Reaktion
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Abfrage Anwenderdaten keine Reaktion1
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Befehle Anwenderdaten2 keine Antwort,
							keine Ausführung3
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Statusnachricht Kanalsteuerung normale
							Antwort und Ausführung
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							- Zuweisung und Abfrage Parameterdaten
							normale Antwort und Ausführung
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Einstellung des Kanalsteuerbytes erfolgt
							mit einem Kanalsteuerbefehl (ID 2, Typ 29),
							der mit Rückmeldung (ID 2, Typ 29)
							beantwortet wird. Die Meldung kann auch mit
							ID 18, Typ 29 abgefragt werden. Um die
							relevanten Kanalinformationen an einer
							Stelle zur Verfügung zu haben, wird das
							Passivierungsbit zusätzlich in der
							DE-Fehlermeldung übertragen.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							&lt;wichtig&gt;
								&lt;anker pid="KanalsteuerungFG4"&gt;&lt;&#47;anker&gt;

								Spezielles Verhalten in der FG4
							&lt;&#47;wichtig&gt;
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Verhalten beim Passivieren von DEs in der FG
							4:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der Wzg&#47;WWW wird ausgeschaltet oder das
							Rollo geschlossen. Bei Wzgs&#47;WWWs mit
							Prismentechnik wird, falls vorhanden, die
							Neutralstellung eingestellt. Die
							Stellzustandsänderung wird spontan zur UZ
							gesendet.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Verhalten von passivierten DEs in der FG 4:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							1. An passivierte DEs wird im Autarkbetrieb
							keine Grundeinstellung ausgegeben, d.h. sie
							bleiben im Zustand"Aus" oder"Rollo
							geschlossen".
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							2. Befehle an passivierte Kanäle werden
							ausgeführt. Dadurch sind passive DEs
							schaltbar.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							3. Passivierte DEs senden immer ihre
							spontanen Meldungen, unabhängig vom
							Identifier und auch während der
							Initialisierung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Somit ist das Verhalten passiver und aktiver
							Kanäle - außer im Autarkbetrieb - gleich.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Verhalten beim Aktivieren von passivierten
							DEs in der FG 4:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Beim Aktivieren wird der Stellzustand des
							zugehörigen Wzgs&#47;WWWs vom EAK nicht
							verändert. Im Falle"Kommunikationsstatus
							lebt" werden DE-Fehlermeldung (Typ 1, ID 1)
							und bei"DE ok" abhängig von der Technologie
							der Zeichen nicht darstellbare WVZ (ID 1,
							Typ 2), defekte Lampen (ID 1, Typ 3) oder
							gestörte Textpositionen (ID 1, Typ 4) und
							der Stellzustand (ID 5, Typ 55, bei
							Altanlagen auch 48,50,58) gesendet. Im
							Falle"Kommunikationsstatus tot" wird die
							Grundeinstellung ausgegeben.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Ansonsten gilt entsprechend die Definition
							in Anhang 6, Teil 2, Kapitel 3.2.5.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdTlsGloKanalSteuerung extends AbstractParameterDatensatz<PdTlsGloKanalSteuerung.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
				 _dEKanalStatus
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
				 _herstellerDefinierterCode
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			TLS-Kanalstatus.
			<p>
			
			</p>
			
			@return der Wert von DEKanalStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
				 getDEKanalStatus() {
				return _dEKanalStatus;
			}
		
			/**
			TLS-Kanalstatus.
			<p>
			
			</p>
			
			@param _dEKanalStatus der neue Wert von DEKanalStatus.
			*/
			public void setDEKanalStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
			 _dEKanalStatus) {
				this._dEKanalStatus = _dEKanalStatus;
			}
		
			/**
			Nibble im Kanalsteuerbyte für
									herstellerspezifische Statusinformationen.
			<p>
			
			</p>
			
			@return der Wert von HerstellerDefinierterCode.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
				 getHerstellerDefinierterCode() {
				return _herstellerDefinierterCode;
			}
		
			/**
			Nibble im Kanalsteuerbyte für
									herstellerspezifische Statusinformationen.
			<p>
			
			</p>
			
			@param _herstellerDefinierterCode der neue Wert von HerstellerDefinierterCode.
			*/
			public void setHerstellerDefinierterCode(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
			 _herstellerDefinierterCode) {
				this._herstellerDefinierterCode = _herstellerDefinierterCode;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getDEKanalStatus() != null) {
		                if (getDEKanalStatus().isZustand()) {
		                    datum.getUnscaledValue("DEKanalStatus").setText(getDEKanalStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("DEKanalStatus").set(getDEKanalStatus().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getHerstellerDefinierterCode() != null) {
		                if (getHerstellerDefinierterCode().isZustand()) {
		                    datum.getUnscaledValue("HerstellerDefinierterCode").setText(getHerstellerDefinierterCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("HerstellerDefinierterCode").set(getHerstellerDefinierterCode().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("DEKanalStatus").isState()) {
								setDEKanalStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
								.getZustand(daten.getScaledValue("DEKanalStatus").getText()));
							} else {
							setDEKanalStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsDEKanalStatus
							(daten.
								getUnscaledValue
							("DEKanalStatus").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							setHerstellerDefinierterCode(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsHerstellerDefinierterCode
							(daten.
								getUnscaledValue
							("HerstellerDefinierterCode").
									byteValue
							()));
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setDEKanalStatus(getDEKanalStatus());
							klon.setHerstellerDefinierterCode(getHerstellerDefinierterCode());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsGloKanalSteuerung";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsGloKanalSteuerung(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
