/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Parameter für Geschwindigkeitsklassen bei
					Kurzzeitdaten (FG 1 &#47; Typ 37).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 1: DE-Block-Struktur im Typ 37"Parameter
							für Geschwindigkeitsklassen bei
							Kurzzeitdaten"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 3 (Parameter) in
							Abruf- und Antwortrichtung für die
							KlasseLkw-Ähnliche (LkwÄ-33).
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Auf einen Abruf mit ID 19 (Abruf Parameter)
							antwortet die Streckenstationen mit 2
							DE-Blöcken Typ 37, je einem für
							?Pkw-Ähnliche? und für ?Lkw-Ähnliche?.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Diese Nachricht übertragt die Konfiguration
							der Geschwindigkeitsklassen, welche für den
							Betrieb der Datenversion 4 benötigt werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Diese DE-Block-Struktur ist optional.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe extends AbstractParameterDatensatz<PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> _vGrenz = new Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				>(15, true);
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Grenze der Geschwindigkeitsklasse.
			<p>
			&lt;absatz&gt;
										Mit Hilfe dieser Bytes werden die Grenzen
										einer Geschwindigkeitsklasse festgelegt.
										Folgende Regeln müssen dabei eingehalten
										werden:
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										1. Es gilt für alle Klassen untere Grenze
										&amp;kleiner; Wert &amp;kleinerGleich; obere
										Grenze.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										2. Die Reihenfolge der Klassen im DE-Block
										ist immer von der kleinsten
										Geschwindigkeitsklasse zur größten.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										3. Die unterste Grenze der ersten Klasse ist
										immer 0 km&#47;h.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										4. Die letzte Klasse ist immer nach oben
										unbegrenzt.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										5. Die DE-Block-Struktur muss immer alle
										Grenzen für eine Fahrzeugklasse enthalten,
										da die alten Grenzen bei Neudefinition
										vollständig gelöscht werden.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										6. Die neu übermittelten Grenzen werden ab
										dem nächsten Messintervall angewandt. Das
										gerade aktuelle Intervall wird verworfen. Um
										Übergangsprobleme zu vermeiden, sollten die
										DE-Blöcke für Fahrzeugklassen, bei denen
										sich Grenzen ändern, in einem Telegramm
										übermitteln werden.
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										Für Sondermessstellen, an denen innerhalb
										von Verkehrsbeeinflussungsanlagen
										Geschwindigkeitsklassen erfasst werden, wird
										folgende Konfiguration verwendet:
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										15 Klassengrenzen für Pkw-ähnliche: 20, 30,
										40, 50, 60, 70, 80, 90, 100, 110, 120, 130,
										140, 150 und 170 km&#47;h
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										11 Grenzen für die Lkw-ähnliche: 20, 30, 40,
										50, 60, 70, 80, 90, 100, 110 und 120 km&#47;h
									&lt;&#47;absatz&gt;
									&lt;absatz&gt;
										Diese Grenzen gelten außerdem in jedem Fall
										als Defaultwerte, solange sie nicht mit
										einem DE-Block Typ 37 überschrieben worden
										sind.
									&lt;&#47;absatz&gt;
			</p>
			
			@return der Wert von VGrenz.
			*/
				public Feld<de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
				> getVGrenz() {
				return _vGrenz;
			}
		
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getVGrenz() != null) {
						final Data.NumberArray arrayVGrenz = datum.
							getUnscaledArray
							("vGrenz");
						arrayVGrenz.setLength(getVGrenz().size());
						for (int i = 0; i < arrayVGrenz.getLength(); ++i) {
							arrayVGrenz.getValue(i).set(getVGrenz().get(i).getValue());
						}
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
						final Data.NumberArray arrayVGrenz = daten.
							getUnscaledArray
						("vGrenz");
		
						for (int i = 0; i < arrayVGrenz.getLength(); ++i) {
		                    getVGrenz().add(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsLveGrenzGeschwindigkeit
		                    (arrayVGrenz.
		                    		shortValue
		                    (i)));
		                }
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
						klon._vGrenz = getVGrenz().clone();
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsLveParameterFürGeschwindigkeitsKlassenBeiKurzzeitDatenLkwÄ";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsLveParameterFuerGeschwindigkeitsKlassenBeiKurzzeitDatenLkwAe(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
