/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.parameter;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Betriebsart (FG 4 &#47; Typ 17).
<p>
&lt;sektion&gt;
						&lt;titel&gt;
							FG 4: DE-Block-Struktur im Typ
							17"Betriebsart"
						&lt;&#47;titel&gt;
						&lt;absatz&gt;
							Wird verwendet mit ID 2 (Statusnachrichten)
							in Abruf- und Antwortrichtung oder mit ID 34
							(Statusnachricht aus Puffer) in
							Antwortrichtung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Nachricht überträgt die Betriebsart der
							Wzg&#47;WWW-Steuerung. Die Betriebsart wird nur
							für alle Wzgs&#47;WWWs eines EAK verändert. Die
							Nachricht wird daher an&#47;von einem
							Clusterkanal gesendet und von diesem
							spannungsausfallsicher abgelegt. Nach
							erfolgter Zuweisung oder spontan wird die
							Meldung der Betriebsart in Antwortrichtung
							zusammen mit dem DE-Block"Zeitstempel mit
							Folgenummer" (Typ 31) gesendet, um in der
							Zentrale die Betriebsart mit genauen
							Wechselzeitpunkten dokumentieren zu können.
							Die Betriebsarten sind wie folgt definiert:
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;1) Normalbetrieb&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Standardfall, wenn keine Störung oder
							Servicefall vorliegt. Die Steuerung erfolgt
							durch die Zentrale (i.d.R. UZ).
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;2) Blindbetrieb&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							In der Blindbetriebsart wird durch eine
							Blende, einen Rollo, etc., verhindert, dass
							der Verkehrsteilnehmer die WVZs erkennen
							kann. Die Steuerung verhält sich ansonsten
							wie im Normalbetrieb, das Schalten der WVZs
							ist weiterhin möglich. Vom Blindbetrieb
							erfolgt kein automatischer Übergang in den
							autarken Betrieb bei Kommunikationsstörung.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Ist es z.B. bei WWWs mit Prismentechnik
							nicht möglich, die Schilder für den
							Verkehrsteilnehmer nicht erkennbar zu
							machen, so ist die anzuzeigende Prismenseite
							dieser Komponenten in der Betriebsart
							Blindbetrieb vom Auftraggeber explizit
							festzulegen (Festlegung in Anhang 9).
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;3) Handbetrieb&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der Handbetrieb ist dadurch gekennzeichnet,
							dass der Zugriff nicht von der Zentrale,
							sondern nur von einem lokalen Bedienfeld
							möglich ist. Die Zentrale erhält weiterhin
							alle Meldungen und kann diese auch abfragen.
							Alle aktiv ändernden Telegramme werden
							jedoch zurückgewiesen (Stellzustand bzw.
							Programm, Helligkeit, Betriebsart und
							Wechseltext). Parametrierung und
							Kanalsteuerung können während des
							Handbetriebs weiterhin durch die Zentrale
							vorgenommen werden. Der Handbetrieb kann nur
							durch manuelle Eingabe vor Ort aktiviert und
							wieder beendet werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Passivierte DE können im Handbetrieb manuell
							geschaltet werden. Erst nach Beenden des
							Handbetriebs wird vom EAK die Passivierung
							an den entsprechenden Wzg&#47;WWW ausgeführt,
							d.h. sie werden ausgeschaltet oder das Rollo
							geschlossen oder ggf. bei Prismen die
							Neutralstellung eingestellt.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Nach Beenden des Handbetriebs bleibt die
							Anzeige so lange bestehen, bis ein neuer
							Stellzustand vom EAK empfangen wird oder in
							den autarken Betrieb geschaltet wird.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;4) Autarker Betrieb&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Autarker Betrieb bedeutet, dass die
							WVZ-Steuerung die Kontrolle über die
							Wzgs&#47;WWWs selbst übernimmt, sie kann z.B.
							selbsttätig ein für diesen Fall
							projektiertes WVZ bzw. Programm darstellen.
							Wenn sich die Steuerung im Normalbetrieb
							befindet und sie die Kommunikation mit der
							übergeordneten Steuerung als gestört erkennt
							(siehe Anhang 6, Teil 2, Kap. 2.2.6), dann
							wird der autarke Betrieb eingeschaltet. Die
							gesamte WVZ-Steuerung wechselt zurück in den
							Normalbetrieb, wenn ein Befehl (Typ 55, bei
							Altanlagen auch 48..50,58) empfangen wird.
							Die Betriebsart wechselt natürlich auch
							aufgrund eines anderslautenden
							Betriebsarten-Befehls.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Für Wechseltext-DEs muss mit dem
							Auftraggeber abgestimmt werden, ob in der
							Betriebsart ?Autarker Betrieb? die Anzeige
							ausgeschaltet werden soll oder der aktuelle
							Inhalt bestehen bleiben soll.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Der Autarkbetrieb kann auch explizit von
							oben eingestellt werden.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;5) Testbetrieb&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Die Funktion der WVZ-Steuerung im
							Testbetrieb ist rein herstellerspezifisch
							definiert. Durch einen entsprechenden
							anderen Betriebsartenbefehl ist der
							Testbetrieb wieder zu verlassen. Die
							Betriebsart"Testbetrieb" ist optional.
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							6) Notbetrieb (nur bei speziellen Anlagen
							erforderlich)
						&lt;&#47;absatz&gt;
						&lt;absatz&gt;
							Er kann, falls erforderlich, in Anlagen wie
							z.B. Knotenpunktsbeeinflussungsanlagen und
							Zuflusssteuerungen realisiert werden, bei
							denen auch bei Störungen aus
							Sicherheitsgründen eine Verkehrsregelung
							angezeigt werden muss. Er ist jedoch nicht
							für eine WWW oder
							Steckenbeeinflussungsanlage vorgesehen. Der
							Notbetrieb ist der sichere immer erfüllbare
							Zustand wie er z.B. durch Klapptafeln oder
							Rollos erreicht werden kann. I.d.R. wird der
							Notbetrieb nur eingeschaltet, wenn eine
							Hardwarestörung vorliegt, bei der auf einen
							zusätzlichen, vom autarken Betrieb
							unabhängigen Anlagenzustand zurückgegriffen
							werden können muss. Der Zustand im
							Notbetrieb ist im Gegensatz zu dem des
							autarken Betriebs nicht von der Zentrale aus
							parametrierbar. Die Betriebsart Notbetrieb
							ist nicht von der Zentrale oder von den
							Handbedienteilen einschaltbar, sondern wird
							durch Betätigung eines Notausschalters
							aktiviert.
						&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 5
 */
public class PdTlsWzgBetriebsArt extends AbstractParameterDatensatz<PdTlsWzgBetriebsArt.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsParameterVorgabeArchiv,
					Aspekte.ParameterDefault,
					Aspekte.ParameterSoll,
					Aspekte.ParameterVorgabe,
					Aspekte.TlsVorgabeBedienung,
					Aspekte.ParameterIst,
				};
			}
	
			/**
			 * Aspekt für den Quittierungsmechanismus des Archivs. Wird alternativ zu asp.parameterVorgabe
						verwendet, wenn die Vorgabe indirekt nach der Archivierung durch das Archiv
						erfolgen soll.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsParameterVorgabeArchiv = new Aspekte("TlsVorgabeArchiv", "asp.tlsParameterVorgabeArchiv");
			
			/**
			 * Aspekt der zur Versorgung von Defaultwerten für Parameter verwendet werden kann.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterDefault = new Aspekte("Default-Parameter-Aspekt", "asp.parameterDefault");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterSoll = new Aspekte("Soll-Parameter-Aspekt", "asp.parameterSoll");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterVorgabe = new Aspekte("Vorgabe-Parameter-Aspekt", "asp.parameterVorgabe");
			
			/**
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Aspekt für Vorgaben von einer Bedienung, die
						nicht wie die Parametersätze automatisch verschickt
						werden (z.B. Schaltdaten, dient zur Unterscheidung
						der Quelle).	 
			 *
			 * <p>
			 * NICHT VERWENDEN. KANN JEDERZEIT WIEDER GELÖSCHT
						WERDEN. Wird verwendet, wenn zusätzlich zum
						asp.tlsVorgabe weitere unterscheidbare Vorgaben
						benötigt werden. Vorgaben aus diesem Aspekt werden
						i. d. R. nicht direkt an die SS geschickt, sondern
						(z. B. über WAN-COM) an eine Zwischensschicht, um
						DaV-Systeme mit Altsystemen zu koppeln.
	         * </p>
			 */
			public static final Aspekt TlsVorgabeBedienung = new Aspekte("TlsVorgabeBedienung", "asp.tlsVorgabeBedienung");
			
			/**
			 * Wird für Parametersätze als Platzhalter verwendet und später durch die Konfiguration automatisch durch die zugesicherten Aspekte von Parametern ersetzt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt ParameterIst = new Aspekte("Ist-Parameter-Aspekt", "asp.parameterIst");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 _urlasser
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgBetriebsArt
				 _betriebsArt
				;
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@return der Wert von Urlasser.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
				 getUrlasser() {
				return _urlasser;
			}
		
			/**
			Urlasserinformationen.
			<p>
			Urlasserinformationen bestehen aus einer Referenz auf den Benutzer, der die Meldung erzeugt hat, einer Angabe der Ursache für die Meldung und einem Veranlasser für die Meldung.
			</p>
			
			@param _urlasser der neue Wert von Urlasser.
			*/
			public void setUrlasser(de.bsvrz.sys.funclib.bitctrl.modell.tmvewbetriebglobal.attribute.AtlUrlasser
			 _urlasser) {
				this._urlasser = _urlasser;
			}
		
			/**
			Betriebsart in der FG 4 der TLS.
			<p>
			
			</p>
			
			@return der Wert von BetriebsArt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgBetriebsArt
				 getBetriebsArt() {
				return _betriebsArt;
			}
		
			/**
			Betriebsart in der FG 4 der TLS.
			<p>
			
			</p>
			
			@param _betriebsArt der neue Wert von BetriebsArt.
			*/
			public void setBetriebsArt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgBetriebsArt
			 _betriebsArt) {
				this._betriebsArt = _betriebsArt;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().bean2Atl(datum.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
					if (getBetriebsArt() != null) {
		                if (getBetriebsArt().isZustand()) {
		                    datum.getUnscaledValue("BetriebsArt").setText(getBetriebsArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("BetriebsArt").set(getBetriebsArt().getValue());
		                }
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// AttributListenDefinition
						getUrlasser().atl2Bean(daten.getItem("Urlasser"), factory);
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("BetriebsArt").isState()) {
								setBetriebsArt(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgBetriebsArt
								.getZustand(daten.getScaledValue("BetriebsArt").getText()));
							} else {
							setBetriebsArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlsglobal.attribute.AttTlsWzgBetriebsArt
							(daten.
								getUnscaledValue
							("BetriebsArt").
									shortValue
							()));
							}
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon._urlasser = getUrlasser().clone();
							klon.setBetriebsArt(getBetriebsArt());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.tlsWzgBetriebsArt";

	/**
	 * Initialisiert den Parameterdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public PdTlsWzgBetriebsArt(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 

}
