/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.onlinedaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Symbol auf SSt zu Code zuordnen.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class OdBcAssignSymbol extends AbstractOnlineDatensatz<OdBcAssignSymbol.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.TlsVorgabe,
					Aspekte.TlsZustand,
				};
			}
	
			/**
			 * Aspekt für Vorgaben (Daten zum Senden an eine SS),
						die nicht wie die Parametersätze automatisch
						verschickt werden (z.B. goegrafische Kenndaten,
						Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsVorgabe = new Aspekte("TlsVorgabe", "asp.tlsVorgabe");
			
			/**
			 * Aspekt für den aktuellen Zustand , die i.d.R.
						ausfallsicher im SM oder EAK abgelegt werden (z.B.
						goegrafische Kenndaten, Knotennummer).	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt TlsZustand = new Aspekte("TlsZustand", "asp.tlsZustand");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractOnlineDatum {
		
		/**
		 * Initialisiert das Onlinedatum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 _code
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.attribute.AttBcWvzSymbolAssignmentStatus
				 _assignmentStatus
				;
				private String
				 _fileName
				= new String
				()
				;
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@return der Wert von Code.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
				 getCode() {
				return _code;
			}
		
			/**
			Beliebige ganze Zahl im Bereich -2^63 bis (2^63)-1.
			<p>
			
			</p>
			
			@param _code der neue Wert von Code.
			*/
			public void setCode(de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
			 _code) {
				this._code = _code;
			}
		
			/**
			Typ des Zuweisungsstatus von Symbolen.
			<p>
			
			</p>
			
			@return der Wert von AssignmentStatus.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.attribute.AttBcWvzSymbolAssignmentStatus
				 getAssignmentStatus() {
				return _assignmentStatus;
			}
		
			/**
			Typ des Zuweisungsstatus von Symbolen.
			<p>
			
			</p>
			
			@param _assignmentStatus der neue Wert von AssignmentStatus.
			*/
			public void setAssignmentStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.attribute.AttBcWvzSymbolAssignmentStatus
			 _assignmentStatus) {
				this._assignmentStatus = _assignmentStatus;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@return der Wert von FileName.
			*/
				public String
				 getFileName() {
				return _fileName;
			}
		
			/**
			Attribut zur Speicherung eines Textes.
			<p>
			
			</p>
			
			@param _fileName der neue Wert von FileName.
			*/
			public void setFileName(String
			 _fileName) {
				if (_fileName.length() > 32767) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32767 + " Zeichen sein.");
				}
				this._fileName = _fileName;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// GanzzahlAttributTyp
					if (getCode() != null) {
		                if (getCode().isZustand()) {
		                    datum.getUnscaledValue("Code").setText(getCode().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("Code").set(getCode().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getAssignmentStatus() != null) {
		                if (getAssignmentStatus().isZustand()) {
		                    datum.getUnscaledValue("AssignmentStatus").setText(getAssignmentStatus().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("AssignmentStatus").set(getAssignmentStatus().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getFileName() != null) {
						datum.getTextValue("FileName").setText(getFileName());
					}
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// GanzzahlAttributTyp
							setCode(new de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.attribute.AttZahl
							(daten.
								getUnscaledValue
							("Code").
									longValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("AssignmentStatus").isState()) {
								setAssignmentStatus(de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.attribute.AttBcWvzSymbolAssignmentStatus
								.getZustand(daten.getScaledValue("AssignmentStatus").getText()));
							} else {
							setAssignmentStatus(new de.bsvrz.sys.funclib.bitctrl.modell.tmkextlssiemenssst4symbole.attribute.AttBcWvzSymbolAssignmentStatus
							(daten.
								getUnscaledValue
							("AssignmentStatus").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setFileName(daten.getTextValue("FileName").getText());
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setCode(getCode());
							klon.setAssignmentStatus(getAssignmentStatus());
							klon.setFileName(getFileName());
			
			
			klon.dSetZeitstempel(dGetZeitstempel());
			klon.dSetDatenStatus(dGetDatenStatus());
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}

		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.bcAssignSymbol";

	/**
	 * Initialisiert den Onlinedatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public OdBcAssignSymbol(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
