/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Langzeitdaten der Datenart Durchscnittliche tägliche Verkehrslast (DTV).
<p>
Langzeitdaten der Datenart DTV können ab dem Aggregationsintervall Monat ermittelt werden. Der DTV ist die durchschnittliche Fahrzeuganzahl aller korrekt (d.h. lückenlos und nicht fehlerbehaftet) vorliegenden Tageswerte. Der DTV wird mit der Einheit "Fz&#47;Tag" angegeben.angegeben.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 2
 */
public class AtlLangZeitDatenDTV implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitDatenDTV
			 _wert
			;
			private de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 _guete
			= new de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			()
			;
	
		/**
		Wert "Durchschnittliche tägliche Verkehrslast (DTV)".
		<p>
		
		</p>
		
		@return der Wert von Wert.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitDatenDTV
			 getWert() {
			return _wert;
		}
	
		/**
		Wert "Durchschnittliche tägliche Verkehrslast (DTV)".
		<p>
		
		</p>
		
		@param _wert der neue Wert von Wert.
		*/
		public void setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitDatenDTV
		 _wert) {
			this._wert = _wert;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@return der Wert von Guete.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
			 getGuete() {
			return _guete;
		}
	
		/**
		Güteinformationen zum Wert (Güte und Verfahren, welches zur Güteermittlung verwendet wurde).
		<p>
		
		</p>
		
		@param _guete der neue Wert von Guete.
		*/
		public void setGuete(de.bsvrz.sys.funclib.bitctrl.modell.fachmodellglobal.attribute.AtlGuete
		 _guete) {
			this._guete = _guete;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getWert() != null) {
	                if (getWert().isZustand()) {
	                    datum.getUnscaledValue("Wert").setText(getWert().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("Wert").set(getWert().getValue());
	                }
				}
				// AttributListenDefinition
					getGuete().bean2Atl(datum.getItem("Güte"), factory);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						if (daten.getUnscaledValue("Wert").isState()) {
							setWert(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitDatenDTV
							.getZustand(daten.getScaledValue("Wert").getText()));
						} else {
						setWert(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitDatenDTV
						(daten.
							getUnscaledValue
						("Wert").
								intValue
						()));
						}
				// AttributListenDefinition
					getGuete().atl2Bean(daten.getItem("Güte"), factory);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLangZeitDatenDTV clone() {
		AtlLangZeitDatenDTV klon = new AtlLangZeitDatenDTV();
		
						klon.setWert(getWert());
						klon._guete = getGuete().clone();
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
