/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Beschreibung des Richtungsquerschnitts.
<p>
Beschreibung des Richtungsquerschnitts mit den für die BAST erforderlichen Informationen und Verweis auf den zugrundeliegenden Messquerschnitt für die Verkehrsdaten.
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AtlLangZeitDatenRichtungsQuerschnitt implements Attributliste {
	
	
		/*
		 * Beginn Propertiesabschnitt
		 */
	
			private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
			 _nK
			;
			private String
			 _nahziel
			= new String
			()
			;
			private String
			 _fernziel
			= new String
			()
			;
			private String
			 _bezeichnung
			= new String
			()
			;
			private 	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt
			 _auswertequerschnitt
			;
	
		/**
		Netzknotenangabe für BAST.
		<p>
		
		</p>
		
		@return der Wert von NK.
		*/
			public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
			 getNK() {
			return _nK;
		}
	
		/**
		Netzknotenangabe für BAST.
		<p>
		
		</p>
		
		@param _nK der neue Wert von NK.
		*/
		public void setNK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
		 _nK) {
			this._nK = _nK;
		}
	
		/**
		Nahzielangabe für einen Richtungsquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Nahziel.
		*/
			public String
			 getNahziel() {
			return _nahziel;
		}
	
		/**
		Nahzielangabe für einen Richtungsquerschnitt.
		<p>
		
		</p>
		
		@param _nahziel der neue Wert von Nahziel.
		*/
		public void setNahziel(String
		 _nahziel) {
			if (_nahziel.length() > 30) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 30 + " Zeichen sein.");
			}
			this._nahziel = _nahziel;
		}
	
		/**
		Nahzielangabe für einen Richtungsquerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Fernziel.
		*/
			public String
			 getFernziel() {
			return _fernziel;
		}
	
		/**
		Nahzielangabe für einen Richtungsquerschnitt.
		<p>
		
		</p>
		
		@param _fernziel der neue Wert von Fernziel.
		*/
		public void setFernziel(String
		 _fernziel) {
			if (_fernziel.length() > 30) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 30 + " Zeichen sein.");
			}
			this._fernziel = _fernziel;
		}
	
		/**
		nähere Bezeichnung für den Knotenpunk (z.B. Autobahnkreuz).
		<p>
		
		</p>
		
		@return der Wert von Bezeichnung.
		*/
			public String
			 getBezeichnung() {
			return _bezeichnung;
		}
	
		/**
		nähere Bezeichnung für den Knotenpunk (z.B. Autobahnkreuz).
		<p>
		
		</p>
		
		@param _bezeichnung der neue Wert von Bezeichnung.
		*/
		public void setBezeichnung(String
		 _bezeichnung) {
			if (_bezeichnung.length() > 6) {
				throw new IllegalArgumentException("Der Text darf nicht länger als " + 6 + " Zeichen sein.");
			}
			this._bezeichnung = _bezeichnung;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.auswerteQuerschnitt.
		<p>
		
		</p>
		
		@return der Wert von Auswertequerschnitt.
		*/
			public 	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt
			 getAuswertequerschnitt() {
			return _auswertequerschnitt;
		}
	
		/**
		Attribut zur Referenzierung des Objekttyps: typ.auswerteQuerschnitt.
		<p>
		
		</p>
		
		@param _auswertequerschnitt der neue Wert von Auswertequerschnitt.
		*/
		public void setAuswertequerschnitt(	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt
		 _auswertequerschnitt) {
			this._auswertequerschnitt = _auswertequerschnitt;
		}
	
	
		/*
		 * Ende Propertiesabschnitt
		 */
	
		/*
		 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
		public void bean2Atl(final Data datum, final ObjektFactory factory) {
				// GanzzahlAttributTyp
				if (getNK() != null) {
	                if (getNK().isZustand()) {
	                    datum.getUnscaledValue("NK").setText(getNK().toString());
	                } else {
						datum.
						getUnscaledValue
	                	("NK").set(getNK().getValue());
	                }
				}
				// ZeichenkettenAttributTyp
				if (getNahziel() != null) {
					datum.getTextValue("Nahziel").setText(getNahziel());
				}
				// ZeichenkettenAttributTyp
				if (getFernziel() != null) {
					datum.getTextValue("Fernziel").setText(getFernziel());
				}
				// ZeichenkettenAttributTyp
				if (getBezeichnung() != null) {
					datum.getTextValue("Bezeichnung").setText(getBezeichnung());
				}
				// ObjektReferenzAttributTyp
					final Object soAuswertequerschnitt = getAuswertequerschnitt();
					final SystemObject tmpAuswertequerschnitt;
						if (soAuswertequerschnitt instanceof SystemObject) {
							tmpAuswertequerschnitt = (SystemObject)soAuswertequerschnitt;
						} else if(soAuswertequerschnitt instanceof SystemObjekt){
							tmpAuswertequerschnitt = ((SystemObjekt)soAuswertequerschnitt).getSystemObject();
						} else{
							tmpAuswertequerschnitt = null;
						}
					datum.getReferenceValue("Auswertequerschnitt").setSystemObject(tmpAuswertequerschnitt);
		}
	
		public void atl2Bean(final Data daten, final ObjektFactory factory) {
				// GanzzahlAttributTyp
						setNK(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
						(daten.
							getUnscaledValue
						("NK").
								intValue
						()));
				// ZeichenkettenAttributTyp
					setNahziel(daten.getTextValue("Nahziel").getText());
				// ZeichenkettenAttributTyp
					setFernziel(daten.getTextValue("Fernziel").getText());
				// ZeichenkettenAttributTyp
					setBezeichnung(daten.getTextValue("Bezeichnung").getText());
				// ObjektReferenzAttributTyp
					final long idAuswertequerschnitt = daten.getReferenceValue("Auswertequerschnitt").getId();
					final SystemObjekt tmpAuswertequerschnitt;
					if (idAuswertequerschnitt == 0) {
						tmpAuswertequerschnitt = null;
					} else {
						final SystemObject soAuswertequerschnitt = factory.getDav().getDataModel().getObject(idAuswertequerschnitt);
						if (soAuswertequerschnitt == null) {
								tmpAuswertequerschnitt = new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.impl.AuswerteQuerschnittUngueltig(idAuswertequerschnitt);
						} else {
							tmpAuswertequerschnitt = factory.getModellobjekt(soAuswertequerschnitt);
						}
					}
					setAuswertequerschnitt((	de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.objekte.AuswerteQuerschnitt
					) tmpAuswertequerschnitt);
		}
	
		/*
		 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
		 */
	
	
	@Override
	public AtlLangZeitDatenRichtungsQuerschnitt clone() {
		AtlLangZeitDatenRichtungsQuerschnitt klon = new AtlLangZeitDatenRichtungsQuerschnitt();
		
						klon.setNK(getNK());
						klon.setNahziel(getNahziel());
						klon.setFernziel(getFernziel());
						klon.setBezeichnung(getBezeichnung());
						klon.setAuswertequerschnitt(getAuswertequerschnitt());
		

		return klon;
	}
	
	@Override
	public String toString() {
		return BeanUtils.toString(this);
	}
		
}
