/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Himmelsrichtung zur Angabe der Richtung u.a. von Richtungsquerschnitten.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
public class AttHimmelsRichtung extends Zahl<		Byte
> {
	
	private static final long serialVersionUID = 1L;
	
	
	/**
	Himmelsrichtung unbestimmt.
	<p>
	
	</p>
	*/
	public static final AttHimmelsRichtung ZUSTAND_0__ = new AttHimmelsRichtung("?", 		Byte
	.valueOf("0"));

	/**
	Norden.
	<p>
	
	</p>
	*/
	public static final AttHimmelsRichtung ZUSTAND_1_N = new AttHimmelsRichtung("N", 		Byte
	.valueOf("1"));

	/**
	Osten.
	<p>
	
	</p>
	*/
	public static final AttHimmelsRichtung ZUSTAND_2_O = new AttHimmelsRichtung("O", 		Byte
	.valueOf("2"));

	/**
	Süden.
	<p>
	
	</p>
	*/
	public static final AttHimmelsRichtung ZUSTAND_3_S = new AttHimmelsRichtung("S", 		Byte
	.valueOf("3"));

	/**
	Westen.
	<p>
	
	</p>
	*/
	public static final AttHimmelsRichtung ZUSTAND_4_W = new AttHimmelsRichtung("W", 		Byte
	.valueOf("4"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttHimmelsRichtung getZustand(final 		Byte
	 value) {
		for (AttHimmelsRichtung e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttHimmelsRichtung getZustand(final String value) {
		for (AttHimmelsRichtung e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttHimmelsRichtung> getZustaende() {
		List<AttHimmelsRichtung> list = new ArrayList<AttHimmelsRichtung>();
		list.add(ZUSTAND_0__);
		list.add(ZUSTAND_1_N);
		list.add(ZUSTAND_2_O);
		list.add(ZUSTAND_3_S);
		list.add(ZUSTAND_4_W);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut Himmelsrichtung.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttHimmelsRichtung(final 		Byte
	 value) {
		super(value);
	}
	
	private AttHimmelsRichtung(final String zustand, final 		Byte
	 value) {
		super(zustand, value);
	}
	
}
