/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Langzeitzählwert der Datenart Fahrzeuganzahl.
<p>

</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 1
 */
@Wertebereich(
	minimum = 0L,
	maximum = 100000000L,
	einheit = "Fz"
)
public class AttLangZeitDatenFahrzeugAnzahl extends Zahl<		Integer
> {
	
	private static final long serialVersionUID = 1L;
	
	/**
	 * Der minimale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MIN_VALUE =
				Integer
		.valueOf("0");
	
	/**
	 * Der maximale Wert des Attributs.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final 		Integer
	 MAX_VALUE =
				Integer
		.valueOf("100000000");
	
	/**
	 * Die Einheit.
	 *
	 * @deprecated neu: {@link WerteBereich#getWerteBereich(Class)} und {@link #getWerteBereich()}
	 */
	@Deprecated
	public static final String EINHEIT = "Fz";
	
	/**
	Daten sind nicht ermittelbar (ist KEIN Fehler).
	<p>
	Wird gesetzt, wenn der entsprechende Wert nicht ermittelbar ist und keine Interpolation sinnvoll möglich ist (z.B. wenn die Fahrzeugklassifizierung nach 5+1 Fahrzeugarten erfolgt kann der Wert für PkwG zumeist nicht ermittelt werden).
	</p>
	*/
	public static final AttLangZeitDatenFahrzeugAnzahl ZUSTAND_1N_NICHT_ERMITTELBAR = new AttLangZeitDatenFahrzeugAnzahl("nicht ermittelbar", 		Integer
	.valueOf("-1"));

	/**
	Daten sind fehlerhaft.
	<p>
	Der Zustand wird gesetzt, wenn die Daten als fehlerhaft erkannt wurden.
	</p>
	*/
	public static final AttLangZeitDatenFahrzeugAnzahl ZUSTAND_2N_FEHLERHAFT = new AttLangZeitDatenFahrzeugAnzahl("fehlerhaft", 		Integer
	.valueOf("-2"));

	/**
	Wert ist nicht ermittelbar, da bereits Basiswerte fehlen oder fehlerhaft sind.
	<p>
	Dieser Zustand wird gesetzt, wenn Daten die zur Berechnung dieses Wertes notwendig sind, bereits als fehlerhaft gekennzeichnet sind, oder wenn die Berechnung aus anderen Gründen nicht möglich war (z.B: Division durch 0).
	</p>
	*/
	public static final AttLangZeitDatenFahrzeugAnzahl ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT = new AttLangZeitDatenFahrzeugAnzahl("nicht ermittelbar/fehlerhaft", 		Integer
	.valueOf("-3"));

	/**
	 * Gibt den Zustand zu einer Zahl zurück oder <code>null</code>, wenn die
	 * Zahl keinen Zustand repräsentiert.
	 *
	 * @param value ein Zahlenwert
	 * @return der Zustand zu dem Zahlenwert oder <code>null</code>, wenn die
	 * Zahl keine Entsprechnung als Zustand besitzt.
	 */
	public static AttLangZeitDatenFahrzeugAnzahl getZustand(final 		Integer
	 value) {
		for (AttLangZeitDatenFahrzeugAnzahl e : getZustaende()) {
			if (e.getValue().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt den Zustand zu einem Zustandsnamen zurück oder <code>null</code>,
	 * wenn kein Zustand einen solchen Namen hat.
	 * 
	 * @param value
	 *            der Zustandsname
	 * @return der Zustand zu dem Zustandsnamen oder <code>null</code>, wenn
	 *         kein Zustand einen solchen Namen hat.
	 */
	public static AttLangZeitDatenFahrzeugAnzahl getZustand(final String value) {
		for (AttLangZeitDatenFahrzeugAnzahl e : getZustaende()) {
			if (e.toString().equals(value)) {
				return e;
			}
		}
		return null;
	}
	
	/**
	 * Gibt alle Zustände zurück, die das Attribut besitzen kann.
	 *
	 * @return alle Zustände die das Attribut annehmen kann.
	 */
	public static List<AttLangZeitDatenFahrzeugAnzahl> getZustaende() {
		List<AttLangZeitDatenFahrzeugAnzahl> list = new ArrayList<AttLangZeitDatenFahrzeugAnzahl>();
		list.add(ZUSTAND_1N_NICHT_ERMITTELBAR);
		list.add(ZUSTAND_2N_FEHLERHAFT);
		list.add(ZUSTAND_3N_NICHT_ERMITTELBAR_FEHLERHAFT);
		return list;
	}	
	/**
	 * Erzeugte eine neues Attribut LangzeitdatenFahrzeuganzahl.
	 *
	 * @param value der Wert der Zahl.
	 */
	public AttLangZeitDatenFahrzeugAnzahl(final 		Integer
	 value) {
		super(value);
	}
	
	private AttLangZeitDatenFahrzeugAnzahl(final String zustand, final 		Integer
	 value) {
		super(zustand, value);
	}
	
}
