/*
 * Java-Modell des Datenkatalogs.
 * Copyright (C) 2016 BitCtrl Systems GmbH 
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA.
 *
 * Contact Information:
 * BitCtrl Systems GmbH
 * Weißenfelser Straße 67
 * 04229 Leipzig
 * Phone: +49 341-490670
 * mailto: info@bitctrl.de
 */

package de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.konfigurationsdaten;

import java.util.*;

import com.bitctrl.beans.*;

import de.bsvrz.dav.daf.main.*;
import de.bsvrz.dav.daf.main.config.*;
import de.bsvrz.sys.funclib.bitctrl.modell.*;
import de.bsvrz.sys.funclib.bitctrl.modell.annotation.*;
import de.bsvrz.sys.funclib.bitctrl.modell.att.*;
import de.bsvrz.sys.funclib.bitctrl.modell.impl.*;

/**
Charakterisierende Daten einer Langzeitzählstelle.
<p>
&lt;sektion&gt;
						&lt;titel&gt;Langzeitzählstelle&lt;&#47;titel&gt;
						&lt;absatz&gt;Die Langzeitzählstelle dient zur Erhebung von Langzeitzähldaten. Die Daten werden einerseits von der bast und andererseits von den Ländern benötigt. Jede Langzeitzählstelle besitzt eine Zählstellennummer anhand der sie bundesweit eindeutig identifierbar ist. Dazu können geografische Kenndaten, Verwaltungsinformationen und Herstellerangaben (Gerät) hinterlegt werden. Die an einer Langzeitzählstelle erhobenen Verkehrsdaten liegen normalerweise im Intervall 1 Stunde vor.&lt;&#47;absatz&gt;
					&lt;&#47;sektion&gt;
</p>
* @author BitCtrl Systems GmbH, M2T
 * @version Gültig seit KB-Version 9
 */
public class KdLangZeitZaehlstelle extends AbstractKonfigurationsDatensatz<KdLangZeitZaehlstelle.Daten> {

		/**
		 * Die vorhandenen Aspekte des Datensatzes.
		 */
		public static class Aspekte extends de.bsvrz.sys.funclib.bitctrl.modell.metamodellglobal.objekte.impl.AspektImpl implements Aspekt {
	
			public static Aspekt[] values() {
				return new Aspekt[] {
					Aspekte.Eigenschaften,
				};
			}
	
			/**
			 * Wird für konfigurierende Attributgruppen verwendet. Über die entsprechende Attributgruppe werden die konkreten Eigenschaften eines Objekts festgelegt.	 
			 *
			 * <p>
			 * 
	         * </p>
			 */
			public static final Aspekt Eigenschaften = new Aspekte("Eigenschaften", "asp.eigenschaften");
			
			;
			
			private final String name;
			private final String pid;
	
			private Aspekte(final String name, final String pid) {
				this.name = name;
				this.pid = pid;
			}
	
			@Override
			public String getName() {
				if (getSystemObject() == null) {
					return name;
				}
				return super.getName();
			}
	
			@Override
			public String getPid() {
				if (getSystemObject() == null) {
					return pid;
				}
				return super.getPid();
			}
			
			@Override
			public Aspect getSystemObject() {
				return (Aspect) super.getSystemObject();
			}
	
			@Override
			public String toString() {
				if (getSystemObject() == null) {
					return name + " (" + pid + ")";
				}
				return super.toString();
			}
	
		}
	
	/**
	 * Kapselt die Daten des Datensatzes.
	 */
	public static class Daten extends AbstractDatum implements KonfigurationsDatum {
		
		/**
		 * Initialisiert das Datum.
		 * 
		 * @param datensatz
		 *            der Datensatz zu dem das Datum gehört.
		 * @param aspekt
		 *            der Aspekt für das Datum.
		 */
		public Daten(final Datensatz datensatz, final Aspekt aspekt) {
			super(datensatz, aspekt);
		}
		
		
			/*
			 * Beginn Propertiesabschnitt
			 */
		
				private String
				 _zaehlstellenName
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitZaehlStellenNummer
				 _zaehlstellenNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttBundesLandBAST
				 _landesNummer
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttStrassenKlasseBAST
				 _strassenKlasse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttZaehlStellenArt
				 _zaehlstellenArt
				;
				private 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 _strasse
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
				 _vonNK
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
				 _nachNK
				;
				private 	Double
				 _station
				;
				private 	Zeitstempel
				 _beginn
				;
				private 	Zeitstempel
				 _ende
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttKlassifizierungsGruppeBAST
				 _klassifizierungsgruppeBAST
				;
				private String
				 _telefonNummer
				= new String
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				 _inRichtung
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				()
				;
				private de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				 _gegenRichtung
				= new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				()
				;
		
			/**
			Name der Langzeitzählstelle.
			<p>
			
			</p>
			
			@return der Wert von ZaehlstellenName.
			*/
				public String
				 getZaehlstellenName() {
				return _zaehlstellenName;
			}
		
			/**
			Name der Langzeitzählstelle.
			<p>
			
			</p>
			
			@param _zaehlstellenName der neue Wert von ZaehlstellenName.
			*/
			public void setZaehlstellenName(String
			 _zaehlstellenName) {
				if (_zaehlstellenName.length() > 30) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 30 + " Zeichen sein.");
				}
				this._zaehlstellenName = _zaehlstellenName;
			}
		
			/**
			Zählstellennummer für Langzeitzählstellen gemäß Definition der BAST bestehend aus TK25 (4stellig) und BAST-Nummer (4stellig).
			<p>
			
			</p>
			
			@return der Wert von ZaehlstellenNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitZaehlStellenNummer
				 getZaehlstellenNummer() {
				return _zaehlstellenNummer;
			}
		
			/**
			Zählstellennummer für Langzeitzählstellen gemäß Definition der BAST bestehend aus TK25 (4stellig) und BAST-Nummer (4stellig).
			<p>
			
			</p>
			
			@param _zaehlstellenNummer der neue Wert von ZaehlstellenNummer.
			*/
			public void setZaehlstellenNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitZaehlStellenNummer
			 _zaehlstellenNummer) {
				this._zaehlstellenNummer = _zaehlstellenNummer;
			}
		
			/**
			Landeskennung für BAST-Zählstelle.
			<p>
			
			</p>
			
			@return der Wert von LandesNummer.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttBundesLandBAST
				 getLandesNummer() {
				return _landesNummer;
			}
		
			/**
			Landeskennung für BAST-Zählstelle.
			<p>
			
			</p>
			
			@param _landesNummer der neue Wert von LandesNummer.
			*/
			public void setLandesNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttBundesLandBAST
			 _landesNummer) {
				this._landesNummer = _landesNummer;
			}
		
			/**
			Straßenklasse nach Definition der BAST.
			<p>
			
			</p>
			
			@return der Wert von StrassenKlasse.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttStrassenKlasseBAST
				 getStrassenKlasse() {
				return _strassenKlasse;
			}
		
			/**
			Straßenklasse nach Definition der BAST.
			<p>
			
			</p>
			
			@param _strassenKlasse der neue Wert von StrassenKlasse.
			*/
			public void setStrassenKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttStrassenKlasseBAST
			 _strassenKlasse) {
				this._strassenKlasse = _strassenKlasse;
			}
		
			/**
			Zählstellenart nach BAST ().
			<p>
			
			</p>
			
			@return der Wert von ZaehlstellenArt.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttZaehlStellenArt
				 getZaehlstellenArt() {
				return _zaehlstellenArt;
			}
		
			/**
			Zählstellenart nach BAST ().
			<p>
			
			</p>
			
			@param _zaehlstellenArt der neue Wert von ZaehlstellenArt.
			*/
			public void setZaehlstellenArt(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttZaehlStellenArt
			 _zaehlstellenArt) {
				this._zaehlstellenArt = _zaehlstellenArt;
			}
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@return der Wert von Strasse.
			*/
				public 	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
				 getStrasse() {
				return _strasse;
			}
		
			/**
			Verweis auf Straße.
			<p>
			
			</p>
			
			@param _strasse der neue Wert von Strasse.
			*/
			public void setStrasse(	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
			 _strasse) {
				this._strasse = _strasse;
			}
		
			/**
			Netzknotenangabe für BAST.
			<p>
			
			</p>
			
			@return der Wert von VonNK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
				 getVonNK() {
				return _vonNK;
			}
		
			/**
			Netzknotenangabe für BAST.
			<p>
			
			</p>
			
			@param _vonNK der neue Wert von VonNK.
			*/
			public void setVonNK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
			 _vonNK) {
				this._vonNK = _vonNK;
			}
		
			/**
			Netzknotenangabe für BAST.
			<p>
			
			</p>
			
			@return der Wert von NachNK.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
				 getNachNK() {
				return _nachNK;
			}
		
			/**
			Netzknotenangabe für BAST.
			<p>
			
			</p>
			
			@param _nachNK der neue Wert von NachNK.
			*/
			public void setNachNK(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
			 _nachNK) {
				this._nachNK = _nachNK;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@return der Wert von Station.
			*/
				public 	Double
				 getStation() {
				return _station;
			}
		
			/**
			Stationierung auf der Strecken die über zwei Netzknoten eindeutig referenziert werden kann.
			<p>
			
			</p>
			
			@param _station der neue Wert von Station.
			*/
			public void setStation(	Double
			 _station) {
				this._station = _station;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Beginn.
			*/
				public 	Zeitstempel
				 getBeginn() {
				return _beginn;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _beginn der neue Wert von Beginn.
			*/
			public void setBeginn(	Zeitstempel
			 _beginn) {
				this._beginn = _beginn;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@return der Wert von Ende.
			*/
				public 	Zeitstempel
				 getEnde() {
				return _ende;
			}
		
			/**
			Zeit im aktuellen Kontext (Simulationszeit oder Systemzeit).
			<p>
			
			</p>
			
			@param _ende der neue Wert von Ende.
			*/
			public void setEnde(	Zeitstempel
			 _ende) {
				this._ende = _ende;
			}
		
			/**
			entspricht der Fahrzeuggruppierung der TLS gemäß Anhang 2, Punkt 2.4 (maßgeblich für die Generierung des BAST-Bestandsbandsformats).
			<p>
			
			</p>
			
			@return der Wert von KlassifizierungsgruppeBAST.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttKlassifizierungsGruppeBAST
				 getKlassifizierungsgruppeBAST() {
				return _klassifizierungsgruppeBAST;
			}
		
			/**
			entspricht der Fahrzeuggruppierung der TLS gemäß Anhang 2, Punkt 2.4 (maßgeblich für die Generierung des BAST-Bestandsbandsformats).
			<p>
			
			</p>
			
			@param _klassifizierungsgruppeBAST der neue Wert von KlassifizierungsgruppeBAST.
			*/
			public void setKlassifizierungsgruppeBAST(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttKlassifizierungsGruppeBAST
			 _klassifizierungsgruppeBAST) {
				this._klassifizierungsgruppeBAST = _klassifizierungsgruppeBAST;
			}
		
			/**
			Telefonnummer zur direkten Anwahl der Zählstelle.
			<p>
			
			</p>
			
			@return der Wert von TelefonNummer.
			*/
				public String
				 getTelefonNummer() {
				return _telefonNummer;
			}
		
			/**
			Telefonnummer zur direkten Anwahl der Zählstelle.
			<p>
			
			</p>
			
			@param _telefonNummer der neue Wert von TelefonNummer.
			*/
			public void setTelefonNummer(String
			 _telefonNummer) {
				if (_telefonNummer.length() > 32) {
					throw new IllegalArgumentException("Der Text darf nicht länger als " + 32 + " Zeichen sein.");
				}
				this._telefonNummer = _telefonNummer;
			}
		
			/**
			IN-Richtung nach Vorgabe der BAST.
			<p>
			
			</p>
			
			@return der Wert von InRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				 getInRichtung() {
				return _inRichtung;
			}
		
			/**
			IN-Richtung nach Vorgabe der BAST.
			<p>
			
			</p>
			
			@param _inRichtung der neue Wert von InRichtung.
			*/
			public void setInRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
			 _inRichtung) {
				this._inRichtung = _inRichtung;
			}
		
			/**
			GEGEN-Richtung nach Vorgabe der BAST.
			<p>
			
			</p>
			
			@return der Wert von GegenRichtung.
			*/
				public de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
				 getGegenRichtung() {
				return _gegenRichtung;
			}
		
			/**
			GEGEN-Richtung nach Vorgabe der BAST.
			<p>
			
			</p>
			
			@param _gegenRichtung der neue Wert von GegenRichtung.
			*/
			public void setGegenRichtung(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AtlLangZeitDatenRichtungsQuerschnitt
			 _gegenRichtung) {
				this._gegenRichtung = _gegenRichtung;
			}
		
		
			/*
			 * Ende Propertiesabschnitt
			 */
		
			/*
			 * Beginn Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			public void bean2Atl(final Data datum, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
					if (getZaehlstellenName() != null) {
						datum.getTextValue("ZählstellenName").setText(getZaehlstellenName());
					}
					// GanzzahlAttributTyp
					if (getZaehlstellenNummer() != null) {
		                if (getZaehlstellenNummer().isZustand()) {
		                    datum.getUnscaledValue("ZählstellenNummer").setText(getZaehlstellenNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZählstellenNummer").set(getZaehlstellenNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getLandesNummer() != null) {
		                if (getLandesNummer().isZustand()) {
		                    datum.getUnscaledValue("LandesNummer").setText(getLandesNummer().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("LandesNummer").set(getLandesNummer().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getStrassenKlasse() != null) {
		                if (getStrassenKlasse().isZustand()) {
		                    datum.getUnscaledValue("StraßenKlasse").setText(getStrassenKlasse().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("StraßenKlasse").set(getStrassenKlasse().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getZaehlstellenArt() != null) {
		                if (getZaehlstellenArt().isZustand()) {
		                    datum.getUnscaledValue("ZählstellenArt").setText(getZaehlstellenArt().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("ZählstellenArt").set(getZaehlstellenArt().getValue());
		                }
					}
					// ObjektReferenzAttributTyp
						final Object soStrasse = getStrasse();
						final SystemObject tmpStrasse;
							if (soStrasse instanceof SystemObject) {
								tmpStrasse = (SystemObject)soStrasse;
							} else if(soStrasse instanceof SystemObjekt){
								tmpStrasse = ((SystemObjekt)soStrasse).getSystemObject();
							} else{
								tmpStrasse = null;
							}
						datum.getReferenceValue("Straße").setSystemObject(tmpStrasse);
					// GanzzahlAttributTyp
					if (getVonNK() != null) {
		                if (getVonNK().isZustand()) {
		                    datum.getUnscaledValue("vonNK").setText(getVonNK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("vonNK").set(getVonNK().getValue());
		                }
					}
					// GanzzahlAttributTyp
					if (getNachNK() != null) {
		                if (getNachNK().isZustand()) {
		                    datum.getUnscaledValue("nachNK").setText(getNachNK().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("nachNK").set(getNachNK().getValue());
		                }
					}
					// KommazahlAttributTyp
					if (getStation() != null) {
						datum.getUnscaledValue("Station").set(getStation());
					}
					// ZeitstempelAttributTyp
						datum.getTimeValue("Beginn").setMillis(getBeginn().getTime());
					// ZeitstempelAttributTyp
						datum.getTimeValue("Ende").setMillis(getEnde().getTime());
					// GanzzahlAttributTyp
					if (getKlassifizierungsgruppeBAST() != null) {
		                if (getKlassifizierungsgruppeBAST().isZustand()) {
		                    datum.getUnscaledValue("KlassifizierungsgruppeBAST").setText(getKlassifizierungsgruppeBAST().toString());
		                } else {
							datum.
							getUnscaledValue
		                	("KlassifizierungsgruppeBAST").set(getKlassifizierungsgruppeBAST().getValue());
		                }
					}
					// ZeichenkettenAttributTyp
					if (getTelefonNummer() != null) {
						datum.getTextValue("TelefonNummer").setText(getTelefonNummer());
					}
					// AttributListenDefinition
						getInRichtung().bean2Atl(datum.getItem("InRichtung"), factory);
					// AttributListenDefinition
						getGegenRichtung().bean2Atl(datum.getItem("GegenRichtung"), factory);
			}
		
			public void atl2Bean(final Data daten, final ObjektFactory factory) {
					// ZeichenkettenAttributTyp
						setZaehlstellenName(daten.getTextValue("ZählstellenName").getText());
					// GanzzahlAttributTyp
							setZaehlstellenNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttLangZeitZaehlStellenNummer
							(daten.
								getUnscaledValue
							("ZählstellenNummer").
									intValue
							()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("LandesNummer").isState()) {
								setLandesNummer(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttBundesLandBAST
								.getZustand(daten.getScaledValue("LandesNummer").getText()));
							} else {
							setLandesNummer(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttBundesLandBAST
							(daten.
								getUnscaledValue
							("LandesNummer").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("StraßenKlasse").isState()) {
								setStrassenKlasse(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttStrassenKlasseBAST
								.getZustand(daten.getScaledValue("StraßenKlasse").getText()));
							} else {
							setStrassenKlasse(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttStrassenKlasseBAST
							(daten.
								getUnscaledValue
							("StraßenKlasse").
									byteValue
							()));
							}
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("ZählstellenArt").isState()) {
								setZaehlstellenArt(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttZaehlStellenArt
								.getZustand(daten.getScaledValue("ZählstellenArt").getText()));
							} else {
							setZaehlstellenArt(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttZaehlStellenArt
							(daten.
								getUnscaledValue
							("ZählstellenArt").
									byteValue
							()));
							}
					// ObjektReferenzAttributTyp
						final long idStrasse = daten.getReferenceValue("Straße").getId();
						final SystemObjekt tmpStrasse;
						if (idStrasse == 0) {
							tmpStrasse = null;
						} else {
							final SystemObject soStrasse = factory.getDav().getDataModel().getObject(idStrasse);
							if (soStrasse == null) {
									tmpStrasse = new de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.impl.StrasseUngueltig(idStrasse);
							} else {
								tmpStrasse = factory.getModellobjekt(soStrasse);
							}
						}
						setStrasse((	de.bsvrz.sys.funclib.bitctrl.modell.tmverkehrglobal.objekte.Strasse
						) tmpStrasse);
					// GanzzahlAttributTyp
							setVonNK(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
							(daten.
								getUnscaledValue
							("vonNK").
									intValue
							()));
					// GanzzahlAttributTyp
							setNachNK(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttNetzKnoten
							(daten.
								getUnscaledValue
							("nachNK").
									intValue
							()));
					// KommazahlAttributTyp
						setStation(daten.getUnscaledValue("Station").
							doubleValue()
						);
					// ZeitstempelAttributTyp
						setBeginn(new
							Zeitstempel
							(daten.getTimeValue("Beginn").getMillis()));
					// ZeitstempelAttributTyp
						setEnde(new
							Zeitstempel
							(daten.getTimeValue("Ende").getMillis()));
					// GanzzahlAttributTyp
							if (daten.getUnscaledValue("KlassifizierungsgruppeBAST").isState()) {
								setKlassifizierungsgruppeBAST(de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttKlassifizierungsGruppeBAST
								.getZustand(daten.getScaledValue("KlassifizierungsgruppeBAST").getText()));
							} else {
							setKlassifizierungsgruppeBAST(new de.bsvrz.sys.funclib.bitctrl.modell.tmlangzeitverkehrsdaten.attribute.AttKlassifizierungsGruppeBAST
							(daten.
								getUnscaledValue
							("KlassifizierungsgruppeBAST").
									byteValue
							()));
							}
					// ZeichenkettenAttributTyp
						setTelefonNummer(daten.getTextValue("TelefonNummer").getText());
					// AttributListenDefinition
						getInRichtung().atl2Bean(daten.getItem("InRichtung"), factory);
					// AttributListenDefinition
						getGegenRichtung().atl2Bean(daten.getItem("GegenRichtung"), factory);
			}
		
			/*
			 * Ende Abschnitt Konvertierung Datenverteiler <-> Modell
			 */
		
			
		@Override
		public Daten clone() {
			final Daten klon = new Daten(dGetDatensatz(), dGetAspekt());
	
							klon.setZaehlstellenName(getZaehlstellenName());
							klon.setZaehlstellenNummer(getZaehlstellenNummer());
							klon.setLandesNummer(getLandesNummer());
							klon.setStrassenKlasse(getStrassenKlasse());
							klon.setZaehlstellenArt(getZaehlstellenArt());
							klon.setStrasse(getStrasse());
							klon.setVonNK(getVonNK());
							klon.setNachNK(getNachNK());
							klon.setStation(getStation());
							klon.setBeginn(getBeginn());
							klon.setEnde(getEnde());
							klon.setKlassifizierungsgruppeBAST(getKlassifizierungsgruppeBAST());
							klon.setTelefonNummer(getTelefonNummer());
							klon._inRichtung = getInRichtung().clone();
							klon._gegenRichtung = getGegenRichtung().clone();
			
	
			return klon;
		}

		@Override
		public String toString() {
			return BeanUtils.toString(this);
		}
	
	}
	
		/** Die PID der Attributgruppe im Datenverteiler. */
		public static final String PID = "atg.langZeitZählstelle";

	/**
	 * Initialisiert den Konfigurationsdatensatz.
	 * 
	 * @param systemObjekt
	 *            das Systemobjekt zu dem der Datensatz gehört.
	 * @param objektFactory
	 *            die ObjektFabrik, die der Datensatz verwenden soll.
	 */
	public KdLangZeitZaehlstelle(final SystemObjekt systemObjekt,
			final ObjektFactory objektFactory) {
		super(systemObjekt, objektFactory);
	}

	
		@Override
		public void init(final SystemObject systemObject,
				final ObjektFactory objektFactory) {
			super.init(systemObject, objektFactory);
			for (final Aspekt asp : Aspekte.values()) {
				((AbstractSystemObjekt) asp).init(objektFactory.getModellobjekt(asp.getPid()).getSystemObject(), objektFactory);
			}
		}
		
		@Override
		protected String doGetPid() {
			return PID;
		}
	
		public Collection<? extends Aspekt> getAspekte() {
			return Arrays.asList(Aspekte.values());
		}
	
		public Daten createDatum() {
			Daten datum = new Daten(this, null);
			// TODO Auslesen der Defaultwerte geht nicht,
			// weil der Datenverteiler für Attribute ohne Defaultwert initial ungültige Werte setzt!!
			// datum.atl2Bean(createSendeCache(), getObjektFactory());
			return datum;
		}
		 
	
}
